//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code places an event in the event log. You must run
// INSTSRC.CPP first.
//***************************************************************

// logevent.cpp

#include <windows.h>
#include <iostream.h>

#include "msgs.h"

VOID main(VOID)
{
  BOOL ret;
  LPCSTR mergeStrs[] = {"LOGEVENT.EXE"};
  HANDLE logHandle;

  // get a handle to log events with
  logHandle=RegisterEventSource(NULL,
    "LogEvent");
  if (logHandle == NULL)
  {
    cerr << "Unable to get log handle"
      << endl;
    return;
  }

  cout << "Reporting event #1." << endl;

  ret=ReportEvent(logHandle,
    EVENTLOG_INFORMATION_TYPE,
    CAT_ONE, MSG_ONE, NULL, 0, 0,
    NULL, NULL);
  if (!ret)
  {
    cerr << "Unable to log an event"
      << endl;
    return;
  }

  cout << "Reporting event #2." << endl;

  ret=ReportEvent(logHandle,
    EVENTLOG_WARNING_TYPE,
    CAT_TWO, MSG_TWO, NULL, 1,
    sizeof(HANDLE), mergeStrs,
    &logHandle);
  if (!ret)
  {
    cerr << "Unable to log an event"
      << endl;
    return;
  }

  DeregisterEventSource(logHandle);
}
