//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code enumerates the domains, machines and shared drives
// on a network. On each drive it lets you add a connection if
// you like.
//***************************************************************

// drvenum.cpp

#include <windows.h>
#include <iostream.h>

//////////////////
// Needs mpr.lib
//////////////////

// This function handles WNet errors
void ErrorHandler(DWORD errorNum, char *s)
{
	DWORD result, error;
	char errorString[1000];
	char name[1000];

	if (errorNum != ERROR_EXTENDED_ERROR)
		cout << "Error number " << errorNum 
			<< " returned by " << s << endl;
	// If its an extended error, get the error.
	else
	{
		result = WNetGetLastError(&error,
			errorString, 1000, name, 1000); 
		if (result != NO_ERROR)
			cout << "Failure in WNetGetLastError: "
				<< result << endl;
		else
			cout << "Extended Error: " << errorString
				<< ". Provider: " << name << endl; 
	}
}

// This function displays the information in
// a NETRESOURCE structure
void DisplayStruct(NETRESOURCE l)
{
	cout << "Type: ";
	switch (l.dwType)
	{
		case RESOURCETYPE_DISK:
			cout << "disk\n";
			break;
		case RESOURCETYPE_PRINT:
			cout << "Printer\n";
			break;
	};

	cout << "Display type: ";
	switch (l.dwDisplayType)
	{
		case RESOURCEDISPLAYTYPE_DOMAIN:
			cout << "domain\n";
			break;
		case RESOURCEDISPLAYTYPE_GENERIC:
			cout << "generic\n";
			break;
		case RESOURCEDISPLAYTYPE_SERVER:
			cout << "server\n";
			break;
		case RESOURCEDISPLAYTYPE_SHARE:
			cout << "share\n";
			break;
	};

	if (l.lpLocalName)
		cout << "Local name: " << l.lpLocalName 
			<< endl;
	if (l.lpRemoteName)
		cout << "Remote name: " << l.lpRemoteName
			<< endl;
	if (l.lpComment)
		cout << "Comment; " << l.lpComment << endl;
	if (l.lpProvider) 
		cout << "Provider: " << l.lpProvider << endl; 
	cout << endl;
}

// Queries user and adds a connection
void AddConnection(LPNETRESOURCE nr)
{
	char localName[100];
	char s[100];
	DWORD result;
			
	cout << "Do you want to add a connection? ";
	cin.getline(s,100);
	if (s[0]!='y' && s[0]!='Y')
		return;
	cout << "Enter local name (eg 'f:'): ";
	cin.getline(localName, 100);
	nr->lpLocalName = localName;

	result = WNetAddConnection2(nr, 0, 0, 0);
	if (result != NO_ERROR)
		ErrorHandler(result, "WNetAddConnection2");
	else
		cout << "Success.\n";
	cout << endl;
}

// Recursive function to enumerate resources
BOOL EnumerateResources(
	LPNETRESOURCE startingPoint)
{
	DWORD result, resultEnum;
	HANDLE enumHandle;
	LPNETRESOURCE buffer;
	DWORD bufferSize = 16384; 
	DWORD numEntries = 0xFFFFFFFF;
	DWORD i;

	// Open a container
	result = WNetOpenEnum(RESOURCE_GLOBALNET,
		RESOURCETYPE_ANY, 0, startingPoint,
		&enumHandle);

	if (result != NO_ERROR)
	{
		ErrorHandler( result, "WNetOpenEnum");
		return FALSE;
	}

	// allocate a buffer to hold resources
	buffer = (LPNETRESOURCE) GlobalAlloc(GPTR,
		bufferSize);

	// Loop through all the elements in the
	// container
	do
	{
		// reset bufferSize each time thru loop
		bufferSize = 16384;
		numEntries = 0xFFFFFFFF;

		// Get resources
		resultEnum = WNetEnumResource(enumHandle, 
			&numEntries, buffer, &bufferSize);
		if (resultEnum == NO_ERROR)
		{
			// Loop through all entries
			for(i = 0; i < numEntries; i++)
			{
				DisplayStruct( buffer[i]);
				// if the entry is a container,
				// recursively open it
				if (buffer[i].dwUsage &
					RESOURCEUSAGE_CONTAINER)
				{
					if (!EnumerateResources(&buffer[i]))
						cout << "Enumeration failed."
							<< endl;
				}
				// else add a connection
				else 
					AddConnection(&buffer[i]);
			}
		}
		else if (resultEnum != ERROR_NO_MORE_ITEMS)
		{
			ErrorHandler(resultEnum,
				"WNetEnumResource");
			break;
		}
	}
	while(resultEnum != ERROR_NO_MORE_ITEMS);

	// Clean up
	GlobalFree((HGLOBAL) buffer);	
	result = WNetCloseEnum(enumHandle);
	if (result != NO_ERROR)
	{
		ErrorHandler(result, "WNetCloseEnum");
		return FALSE;
	}
	return TRUE;
}

void main()
{
	// Start the recursion at the net level
	EnumerateResources(NULL);
}
