//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates the GetVolumeInformation function.
//***************************************************************

// drvgvi.cpp

#include <windows.h>
#include <iostream.h>

void main()
{
	BOOL success;
	char volumeName[MAX_PATH];
	DWORD volumeSerialNumber;
	DWORD maxNameLength;
	DWORD fileSystemFlags;
	char systemName[MAX_PATH];

	// get the volume information for drive C
	success = GetVolumeInformation("c:\\",
		volumeName, MAX_PATH,
		&volumeSerialNumber,
		&maxNameLength,
		&fileSystemFlags,
		systemName, MAX_PATH);
		
	// output information
	cout << "Volume name: " << volumeName << endl;
	cout << "Volume serial number: "
		<< volumeSerialNumber << endl;

	cout << "File system type: " << systemName
		<< endl;
	cout << "Maximum file name length:"
		<< maxNameLength << endl;

	cout << "File system characteristics: \n";
	if (fileSystemFlags & FS_CASE_IS_PRESERVED)
		cout << "    Case is preserved\n";
	else
		cout << "    Case is not preserved\n";

	if (fileSystemFlags & FS_CASE_SENSITIVE)
		cout << "    Case sensitive\n";
	else
		cout << "    Not case sensitive\n";

	if (fileSystemFlags & FS_UNICODE_STORED_ON_DISK)
		cout << "    Unicode stored\n";
	else
		cout << "    Unicode not stored\n";
}
