//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code retrieves the size of a drive and its free space.
//***************************************************************

// drvsize.cpp

#include <windows.h>
#include <iostream.h>

void main()
{
	BOOL success;
	unsigned long sectorsPerCluster, bytesPerSector,
		freeClusters, clusters;

	// Get disk space for drive C
	success = GetDiskFreeSpace( "c:\\",
		&sectorsPerCluster, 
		&bytesPerSector, &freeClusters, &clusters);
	if (!success)
	{
		cout << "Error number: " << GetLastError()
			<< endl;
		return;
	}

	// Output full disk size and free space
	cout << "Disk size: " << sectorsPerCluster * 
		bytesPerSector * clusters << endl;
	cout << "Free space: " << sectorsPerCluster * 
		bytesPerSector * freeClusters << endl;
	cout << endl;
}
