//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates the GetDriveType function.
//***************************************************************

// drvtype.cpp

#include <windows.h>
#include <iostream.h>

void main()
{
	UINT driveType;

	// Get the drive type for drive C
	driveType = GetDriveType("c:\\");
	switch (driveType)
	{
		case 0:
			cout << "error\n";
			break;
		case 1:
			cout << "Drive does not exist\n";
			break;
		case DRIVE_REMOVABLE:
			cout << "Media removable\n";
			break;
		case DRIVE_FIXED: 
			cout << "Fixed disk\n";
			break;
		case DRIVE_REMOTE:
			cout << "Network drive\n";
			break;
		case DRIVE_CDROM:
			cout << "CD-ROM drive\n";
			break;
		case DRIVE_RAMDISK:
			cout << "RAM disk\n";
			break;
	}
	cout << endl;
}
