//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code lists the current directory's contents.
//***************************************************************

//dir1.cpp

#include <iostream.h> 
#include <windows.h>

// Prints data in findData
void PrintFindData(WIN32_FIND_DATA *findData)
{	
	// If it's a directory, print the name
	if( findData->dwFileAttributes & 
		FILE_ATTRIBUTE_DIRECTORY )
	{
		cout << "Directory: " 
			<< findData->cFileName << endl;
	}
	// else if it's a file, print name and size
	else
	{	
		cout << findData->cFileName;
		cout << "\t(" << findData->nFileSizeLow 
			<< ")";
		cout << endl;
	}
}

// Lists the contents of the current directory
void ListDirectoryContents(char *fileMask)
{
	HANDLE fileHandle;
	WIN32_FIND_DATA findData;

	// get first file
	fileHandle = FindFirstFile( fileMask,
		&findData );
	if( fileHandle != INVALID_HANDLE_VALUE )
	{
		PrintFindData( &findData );

		// loop on all remeaining entries in dir
  		while( FindNextFile( fileHandle, 
			&findData ) )
		{
			PrintFindData( &findData );
		}
 	}
	
	FindClose( fileHandle );
}

int main(int argc, char *argv[])
{
	// List current directory's contents
	ListDirectoryContents( "*.*" );
	return( 0 );
}
