//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code gets the current directory.
//***************************************************************

// dirget.cpp

#include <windows.h>
#include <iostream.h>

void main()
{
	char s[MAX_PATH];
	char buffer[MAX_PATH];
	DWORD len;
	BOOL success;

	// print current directory
	len = GetCurrentDirectory(MAX_PATH, buffer);
	if (len == 0)
		cout << "Get error: " << GetLastError() 
			<< endl;
	else
		cout << "Current Directory = " << buffer 
			<< endl;
	
	// get name of new directory
	cout << "Enter path/name of directory to set: ";
	cin >> s;

	// change directory
	success = SetCurrentDirectory(s);
	if (!success)
		cout << "Set error: " << GetLastError()
			<< endl;

	// print current directory
	len = GetCurrentDirectory(MAX_PATH, buffer);
	if (len == 0)
		cout << "Get error: " << GetLastError() 
			<< endl;
	else
		cout << "Current Directory = " << buffer
			<< endl;
}
