//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code finds a file in the system or user path.
//***************************************************************

// dirsrch.cpp

#include <windows.h>
#include <iostream.h>

void main()
{
	char name[MAX_PATH];
	char pathName[MAX_PATH];
	char *pathPointer;
	char *p;
	char buffer[MAX_PATH];
	DWORD len;

	// get name of file
	cout << "Enter the name of the file to find: ";
	cin >> name;

	// get name of directory to start search
	cout << "Enter path to start search, or PATH: ";
	cin >> pathName;

	// Search named path, or system path
	if (strcmp(pathName, "PATH") == 0)
		pathPointer = NULL;
	else
		pathPointer = pathName;

	// do the search. It may take a while
	len = SearchPath(pathPointer, name, 0, 
		MAX_PATH, buffer, &p);
	cout << "The search may take awhile...\n";

	if (len == 0)
		cout << "Not found: " << GetLastError()
			<< endl;
	else
		cout << "Found in " << buffer << endl;
}
