//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates the dining philosophers problem that
// can fail due to deadlock.
//***************************************************************

// dinphil.cpp

#include <windows.h>
#include <stdlib.h>
#include <iostream.h>

const INT numPhilosophers=3;
HANDLE chopsticks[numPhilosophers];
CHAR csStat[numPhilosophers+1];
CHAR pStat[numPhilosophers+1];

void PhilosopherThread(INT id)
{
  while (1)
  {
    //thinking
    Sleep(GetTickCount() % 50);

    // hungry, so picks up chopsticks
    WaitForSingleObject(chopsticks[id], 
      INFINITE);
    csStat[id]='1';
    WaitForSingleObject(
      chopsticks[(id+1)%numPhilosophers],
      INFINITE);
    csStat[(id+1)%numPhilosophers]='1';
    pStat[id]='1';

    // eating
    cout << csStat << "  " << pStat << endl;
    Sleep(GetTickCount() % 50);

    pStat[id]='0';
    // done eating
    ReleaseMutex(chopsticks[id]);
    csStat[id]='0';
    ReleaseMutex(
      chopsticks[(id+1)%numPhilosophers]);
    csStat[(id+1)%numPhilosophers]='0';
  }
}

void main(void)
{
  HANDLE handles[numPhilosophers];
  DWORD threadID;
  INT i;

  csStat[numPhilosophers]='\0';
  pStat[numPhilosophers]='\0';

  // Create the chopstick mutexes
  for (i=0; i<numPhilosophers; i++)
    chopsticks[i] = CreateMutex(0, FALSE, 0);

  // Create the philosopher threads
  for (i=0; i<numPhilosophers; i++)
  {
    // create the philosopher threads
    handles[i]=CreateThread(0, 0,
      (LPTHREAD_START_ROUTINE) PhilosopherThread, 
      (VOID *) i, 0, &threadID);
  }

  // wait for all threads to finish execution
  WaitForMultipleObjects(numPhilosophers, handles, 
    TRUE, INFINITE);  

  for (i=0; i<numPhilosophers; i++)
    CloseHandle(chopsticks[i]);

  cout << "Done" << endl;
}
