//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code demonstrates a solution to the reader-writer
// problem.
//***************************************************************

// rw.cpp

#include <windows.h>
#include <stdlib.h>
#include <iostream.h>

volatile INT readerCount=0;
HANDLE mutex;
HANDLE write;

void ReaderThread(INT id)
{
  while (1)
  {
    // Simulate the reader processing
    Sleep(GetTickCount() % 100);

    // The reader needs to read
    WaitForSingleObject(mutex, INFINITE);
    readerCount++;
    if (readerCount==1) 
      WaitForSingleObject(write, INFINITE);
    ReleaseMutex(mutex);

    // The reader is reading
    cout << readerCount << " readers"
      << endl;
    Sleep(GetTickCount() % 100);

    // The reader is done reading
    WaitForSingleObject(mutex, INFINITE);
    readerCount--;
    cout << readerCount << " readers"
      << endl;
    if (readerCount==0) 
      ReleaseSemaphore(write, 1, 0);
    ReleaseMutex(mutex);
  }
}

void WriterThread(INT id)
{
  while (1)
  {
    // Simulate the write processing
    Sleep(GetTickCount() % 1000);

    // The writer needs to write
    cout << "writer " << id << " waiting"
      << endl;
    WaitForSingleObject(write, INFINITE);

    // The writer is writing
    cout << id << " writing\n";
    Sleep(GetTickCount() % 1000);
    cout << "writer " << id << " done"
      << endl;

    // The writer is done
    ReleaseSemaphore(write, 1, 0);
  }
}

const INT numReaders=6;
const INT numWriters=3;

void main(void)
{
  HANDLE handles[numReaders+numWriters];
  DWORD threadID;
  INT i;

  mutex = CreateMutex(0, FALSE, 0);
  write = CreateSemaphore(0, 1, 1, 0);

  for (i=0; i<numReaders; i++)
  {
    handles[i]=CreateThread(0, 0,
      (LPTHREAD_START_ROUTINE) ReaderThread, 
      (VOID *) i, 0, &threadID);
  }

  for (i=0; i<numWriters; i++)
  {
    handles[i+numReaders]=CreateThread(0, 0,
      (LPTHREAD_START_ROUTINE) WriterThread, 
      (VOID *) i, 0, &threadID);
  }

  // wait for all threads to finish execution
  WaitForMultipleObjects(numReaders+numWriters,
    handles, TRUE, INFINITE);  

  CloseHandle(mutex);
  CloseHandle(write);
}
