//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code implements a UDP sender.
//***************************************************************

// mcipsend.cpp

#include <windows.h>
#include <iostream.h>
#include <winsock.h>

#define NO_FLAGS_SET 0

#define PORT (u_short) 44966

INT main(VOID)
{
  WSADATA Data;
  SOCKADDR_IN destSockAddr;
  SOCKET destSocket;
  int status;
  int numsnt;
  int enable=1;
  char *toSendtxt="Test String";

  /* initialize the Windows Socket DLL */
  status=WSAStartup(MAKEWORD(1, 1), &Data);
  if (status != 0)
    cerr << "ERROR: WSAStartup unsuccessful"
      << endl;

  /* specify the IP address */
  destSockAddr.sin_addr.s_addr=
    htonl(INADDR_BROADCAST);
  /* specify the port portion of the address */
  destSockAddr.sin_port=htons(PORT);
  /* specify the address family as Internet */
  destSockAddr.sin_family=AF_INET;

  /* create a socket */
  destSocket=socket(AF_INET, SOCK_DGRAM, 0);
  if (destSocket == INVALID_SOCKET)
  {
    cerr << "ERROR: socket unsuccessful" << endl;
    status=WSACleanup();
    if (status == SOCKET_ERROR)
      cerr << "ERROR: WSACleanup unsuccessful"
        << endl;
    return(1);
  }

  /* permit broadcasting on the socket */
  status=setsockopt(destSocket, SOL_SOCKET,
    SO_BROADCAST, (char *) &enable,
      sizeof(enable));
  if (status != 0)
    cerr << "ERROR: setsockopt unsuccessful"
      << endl;
  
  while(1)
  {
    cout << "Sending..." << endl;
    numsnt=sendto(destSocket, toSendtxt,
      strlen(toSendtxt) + 1, NO_FLAGS_SET,
      (LPSOCKADDR) &destSockAddr,
        sizeof(destSockAddr));
    if (numsnt != (int)strlen(toSendtxt) + 1)
    {
      cerr << "ERROR: sendto unsuccessful" << endl;
      status=closesocket(destSocket);
      if (status == SOCKET_ERROR)
        cerr << "ERROR: closesocket unsuccessful"
          << endl;
      status=WSACleanup();
      if (status == SOCKET_ERROR)
        cerr << "ERROR: WSACleanup unsuccessful"
          << endl;
      return(1);
    }

  /* Wait before sending the message again */
  Sleep(4800);
  } /* while */
}
