//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code implements a named pipe server that accepts
// connections from multiple clients.
//***************************************************************

// msnpserv.cpp

#include <windows.h>
#include <iostream.h>
#include <string.h>
#include <stddef.h>
#include <process.h>

#define BUFSIZE 128
#define MAX_INSTANCES 3

void msnpClientThread(HANDLE msnpPipe)
{
  CHAR textBuffer[BUFSIZE];
  DWORD numBytesRead;
  DWORD numBytesWritten;

  while (1)
  {
    if (!ReadFile(msnpPipe,
      textBuffer, BUFSIZE,
      &numBytesRead, (LPOVERLAPPED) NULL))
    {
      cerr 
        << "ERROR: Unable to read from named pipe"
        << endl;
      break;
    }

    _strupr(textBuffer);

    if (!WriteFile(msnpPipe,
      textBuffer, strlen(textBuffer) + 1,
      &numBytesWritten, (LPOVERLAPPED) NULL))
    {
      cerr 
        << "ERROR: Unable to write to named pipe"
        << endl;
      break;
    }

    cout << textBuffer << endl;
  } /* while */

  FlushFileBuffers(msnpPipe);
  DisconnectNamedPipe(msnpPipe);
  CloseHandle(msnpPipe);
}

INT main(VOID)
{
  HANDLE msnpPipe;
  DWORD msnpThread;

  while (1)
  {
    /* Create a named pipe for receiving 
       messages */
    msnpPipe=CreateNamedPipe("\\\\.\\pipe\\msnp",
      PIPE_ACCESS_DUPLEX, 
      PIPE_TYPE_BYTE | PIPE_WAIT,
      MAX_INSTANCES, 0, 0, 150,
      (LPSECURITY_ATTRIBUTES) NULL);

    /* Check and see if the named pipe was 
       created */
    if (msnpPipe == INVALID_HANDLE_VALUE)
    {
      cerr 
        << "ERROR: Unable to create a named pipe"
        << endl;
      return (1);
    }

    /* Allow a client to connect to the name pipe,
       terminate if unsuccessful */
    if (!ConnectNamedPipe(msnpPipe, 
      (LPOVERLAPPED) NULL))
    {
      cerr 
        << "ERROR: Unable to connect a named pipe."
        << endl;
      CloseHandle(msnpPipe);
      return (1);
    }

    msnpThread=_beginthread(msnpClientThread,
      0, (HANDLE) msnpPipe);
    if (msnpThread == -1)
    {
      cerr << "ERROR: Unable to create thread"
        << endl;
      CloseHandle(msnpPipe);
    }

  } /* while */
}
