//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code implements the "ran" portion of ranmon.
//***************************************************************

// ran.cpp

// Usage: ran <executable|batch file|-stopmon>

#include <windows.h>
#include <process.h>
#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "ran.h"

#define MAX_USERNAME 15

int main(int argc, char *argv[])
{
  HANDLE RANSlot;
  BOOL Status;
  DWORD NumBytesWritten;
  DWORD length;
  RANData randata;
  char cmdLine[MAX_PATH];
  char slotPath[MAX_PATH];
  char userName[MAX_USERNAME + 1];
  int i;
  long elapsedTime;
  time_t startTime;
  time_t stopTime;
  char *timeString;

  if (argc < 2)
  {
    cout << 
      "Usage: ran <executable|batch file|-\
stopmon>\n" 
      << endl;
    return(1);
  }


  /* If -stopmon, stop ranmon */
  if (!strcmp(argv[1], "-stopmon"))
  {
    randata.stopMonitors=1;
    cout << "Sending Ranmon the stop signal..."
      << endl;
  }
  /* otherwise, run the requested program */
  else
  {
    /* Get the comp name and record it */
    randata.stopMonitors=0;
    strcpy(randata.AppName, argv[1]);
    length=sizeof(randata.WkstnName);
    GetComputerName(randata.WkstnName, &length);
    strcpy(cmdLine, argv[1]);
    for (i=2; i<argc; i++)
    {
      strcat(cmdLine, " ");
      strcat(cmdLine, argv[i]);
    }

    /* Get the start time */
    time(&startTime);
    timeString=ctime(&startTime);
    cout << argv[1] << " started: " << timeString 
      << endl;

    /* run the program */
    system(cmdLine);

    /* Record the stop time */
    time(&stopTime);
    timeString=ctime(&stopTime);
    cout << argv[1] << " exited: " << timeString 
      << endl;

    elapsedTime=stopTime-startTime;
    randata.RunHrs=elapsedTime / 3600; 
    elapsedTime-=(randata.RunHrs * 3600);
    randata.RunMin=elapsedTime / 60; 
    elapsedTime-=(randata.RunMin * 60);
    randata.RunSec=elapsedTime;

    cout << argv[1] << " executed: " 
      << randata.RunHrs
      << " hours, " <<  randata.RunMin 
      << " minutes, and "
      << randata.RunSec << " seconds\n" << endl;
  }

  /* Set up mailslot path */
  strcpy(slotPath, "\\\\*\\mailslot\\ran\\");
  length=sizeof(userName);
  GetUserName(userName, &length);
  strcat(slotPath, userName);
  /* Create the mailslot file handle 
     for sending messages */
  RANSlot=CreateFile(slotPath,
    GENERIC_WRITE, FILE_SHARE_READ,
    (LPSECURITY_ATTRIBUTES) NULL,
    OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL,
    (HANDLE) NULL);

  /* Check and see if the mailslot file was opened,
     if not terminate program */
  if (RANSlot == INVALID_HANDLE_VALUE)
  {
    cerr << "ERROR: Unable to create a mailslot"
      << endl;
    return (1);
  }

  /* Send message that program has terminated */
  /* Write message to mailslot */
  Status=WriteFile(RANSlot,
    &randata, sizeof(RANData),
    &NumBytesWritten, (LPOVERLAPPED) NULL);

  /* If error occurs when writing to mailslot,
     terminate program */
  if (!Status)
  {
    cerr << "ERROR: Unable to write message" 
      << endl;
    CloseHandle(RANSlot);
    return (1);
  }

  CloseHandle(RANSlot);
  return(0);
}
