//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code implements the RPC server.
//***************************************************************

// ctxtserv.cpp

#include <windows.h>
#include <iostream.h>
#include <rpc.h>
#include "sum.h"
#include "memstub"

INT main(VOID)
{
  // use the protocols specified in the IDL file
  // for this interface
  if (RpcServerUseAllProtseqsIf(1,
    sumup_ServerIfHandle,
    NULL))
  {
    cerr << "ERROR: Could not specify protocols"
      << endl;
    return(1);
  }

  // register the interface
  if (RpcServerRegisterIf(sumup_ServerIfHandle,
    NULL, NULL))
  {
    cerr
      << "ERROR: Could not register intf handle"
      << endl;
    return(1);
  }

  // listen for and service RPC requests
  if (RpcServerListen(1, 5, FALSE))
  {
    cerr
      << "ERROR: Unable to listen for RPC requests"
      << endl;
    return(1);
  }

  return(0);
}
