//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code implements the RPC server function.
//***************************************************************

// sum.cpp

#include <windows.h>
#include "sum.h"

typedef struct
{
  long currentSum;
} sumContext;

// function to initialize sum context
void InitSum(SumUpContext *contextHandle)
{
  sumContext *tmpSum;

  tmpSum=(sumContext *)
    midl_user_allocate(sizeof(sumContext));

  tmpSum->currentSum=0;

  *contextHandle=(SumUpContext)tmpSum;
}

long SumUp(SumUpContext contextHandle,
  short sumVal)
{
  short iter;
  long theSum;

  theSum=((sumContext *)contextHandle)->currentSum;

  for (iter=1; iter<=sumVal; theSum+=iter, iter++);

  ((sumContext *)contextHandle)->currentSum=theSum;

  Beep(300, 30);

  return(theSum);
}

// function to uninitialize sum context
void UnInitSum(SumUpContext *contextHandle)
{
  midl_user_free(*contextHandle);

  *contextHandle=NULL;
}

// function which gets called if client
// looses contact with server
void __RPC_USER SumUpContext_rundown
  (SumUpContext contextHandle)
{
  midl_user_free(contextHandle);
}
