//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code enumerates all services currently installed.
//***************************************************************

// enum.cpp

#include <windows.h>
#include <iostream.h>

void ErrorHandler(char *s, DWORD err)
{
	cout << s << endl;
	cout << "Error number: " << err << endl;
	ExitProcess(err);
}

void main(int argc, const char *argv[])
{
	SC_HANDLE scm;
	BOOL success;
	LPENUM_SERVICE_STATUS status;
	DWORD numServices=0, sizeNeeded=0, resume=0;

	// Open a connection to the SCM
	scm = OpenSCManager(0, 0,
		SC_MANAGER_ALL_ACCESS);
	if (!scm)
		ErrorHandler("In OpenScManager",
			GetLastError());

	// get the number of bytes to allocate
	// MAKE SURE resume starts at 0
	resume = 0;
	success = EnumServicesStatus(scm, 
		SERVICE_WIN32 | SERVICE_DRIVER,
		SERVICE_ACTIVE | SERVICE_INACTIVE,
		0, 0, &sizeNeeded, &numServices, &resume);
	if (GetLastError() != ERROR_MORE_DATA)
		ErrorHandler("In EnumServicesStatus1", 
			GetLastError());
	// Allocate space
	status = (LPENUM_SERVICE_STATUS)
		LocalAlloc(LPTR, sizeNeeded);

	// Get the status records. Making an assumption
	// here that no new services get added during
	// the allocation (could lock the database to
	// guarantee that...)
	resume = 0;
	success = EnumServicesStatus(scm, 
		SERVICE_WIN32 | SERVICE_DRIVER,
		SERVICE_ACTIVE | SERVICE_INACTIVE,
		status, sizeNeeded, &sizeNeeded,
			&numServices, &resume);
	if (!success)
		ErrorHandler("In EnumServicesStatus", 
			GetLastError());

	DWORD i;
	for (i=0; i < numServices; i++)
		cout << i << " " 
			<< status[i].lpServiceName << " " 
			<< status[i].lpDisplayName << endl;
	
	// Clean up
	LocalFree(status);
	CloseServiceHandle(scm);
}
