//***************************************************************
// From the book "Win32 System Services: The Heart of Windows NT"
// by Marshall Brain
// Published by Prentice Hall
//
// Copyright 1994, by Prentice Hall.
//
// This code starts a service.
//***************************************************************

// startsvc.cpp

#include <windows.h>
#include <iostream.h>

void ErrorHandler(char *s, DWORD err)
{
	cout << s << endl;
	cout << "Error number: " << err << endl;
	ExitProcess(err);
}

void main(int argc, const char *argv[])
{
	SC_HANDLE service, scm;
	BOOL success;

	if (argc < 2)
	{
		cout << "Usage:\n";
		cout << "   start service_name arguments\n";
		cout << "   the arguments are passed as \
startup arguments to the service\n";
		return;
	}
	
	// Open a connection to the SCM
	scm = OpenSCManager(0, 0, 
		SC_MANAGER_ALL_ACCESS | GENERIC_WRITE);
	if (!scm)
		ErrorHandler("In OpenScManager",
			GetLastError());

	// Get the service's handle
	service = OpenService(
		scm, argv[1],
		SERVICE_ALL_ACCESS);
	if (!service)
		ErrorHandler("In OpenService",
			GetLastError());

	// Start the service, passing 
	// it startup parameters 
	success = StartService(service,
		argc-2, &argv[2]);
	if (!success)
		ErrorHandler("In StartService",
			GetLastError());
	
	// Clean up
	CloseServiceHandle(service);
	CloseServiceHandle(scm);
}
