#ifndef __PORT_H
#define __PORT_H

#define ismac 0
#define	isppc 0
#define iswin 1
#define isdos 0

#define	isdebug	1

#if iswin

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\stat.h>
#include <time.h>
#include <math.h>
#include <io.h>
#include <windows.h>
#include <mmsystem.h>

#endif

typedef enum
{
	badsid = 100,        // bad star id
	badsiz,              // bad star file size
	badmem,              // memory error
	badmat,              // bad star file version
	badfil,              // file error
	badtxt,              // text error
	badlok,              // bad lock use count
	badlog               // logic error
} rescode;

void		portFatalError(rescode, short);

/* -------- PORTMEM.C -- Memory allocation -------- */

#if ismac
	#define handle Handle
	#define pmem Ptr
#endif
#if iswin
	#define handle HANDLE
	#define	pmem LPSTR
#endif

long		memGetMaxAlloc(void);
long		memGetStackSpace(void);
void		memClear(pmem, long);
void		memSet(pmem, char, long);
void		memCopy(pmem, pmem, long);
void		memMove(pmem, pmem, long);
pmem		memNew(long);
void		memDispose(pmem);
long		memGetSize(pmem);

/* -------- PORTWAVE.C -- Sound output -------- */

#define waveRateBase	11025L

#if ismac
	#define	mixRingSize		(2048L+16)
#endif

#if iswin
	#define	mixRingSize		(65536L+16)
#endif

typedef enum 
{
	waveRate11k 		= 1,
	waveRate22k 		= 2,
	waveRate44k 		= 4
} waveRate;

typedef enum
{
	waveBits8 	 		= 1,
	waveBits16 			= 2
} waveBits;

typedef enum
{
	waveSpeakMono   	= 1,
	waveSpeakStereo		= 2
} waveSpeak;

rescode		waveOpen(waveRate, waveBits, waveSpeak, int*, int*, int*);
rescode		waveClose(void);
rescode		waveReset(void);
rescode		waveGetPlayPtr(pmem *);
rescode		wavePlay(void);
rescode		waveGetSampleCount(long *);
rescode		waveGetVolume(short *);
rescode		waveSetVolume(short);

/* -------- GENMIX.C -- Sound mixer -------- */

typedef struct
{
	long		mul;
	char		shift;
} mixVolChan;

typedef struct
{
	mixVolChan	left;
	mixVolChan	right;
	mixVolChan	both;
} mixVol, *pmixVol;

#define mixNumCodec	4

typedef enum
{
	mixCodecPCM 		= 0,
	mixCodecADPCM 		= 1,
	mixCodecCyberflix	= 2,
	mixCodecCyberflix2	= 3
} mixCodecType;

typedef struct tagmixSound *pmixSound;

typedef void (*mixCodecRendFn)(pmem,pmem,void*);
typedef void (*mixCodecInitFn)(pmixSound,void*);

typedef struct
{
	mixCodecType	type;
	long			blocksize;
	long			datasize;
	mixCodecRendFn	rendfn;
	mixCodecInitFn	initfn;
} mixCodec, *pmixCodec;

typedef struct
{
	mixCodec		codec;
	void			*privdata;
	pmem			*pablocks;
	long			numblocks;
	long			curblock;
	long			curpos;
} mixCodecInst, *pmixCodecInst;

typedef struct tagmixSound
{
	mixCodecType	type;
	pmem			pdata;
	long			samples;
	waveRate		rate;
	waveBits		bits;
	waveSpeak		speak;
	mixVol			vol;
} mixSound;

rescode		mixOpen(short, waveRate, waveBits, waveSpeak);
rescode		mixClose(void);
rescode		mixPlay(short, pmixSound);
rescode		mixUnplay(pmem);
rescode		mixAppend(short, pmixSound);
rescode		mixSilence(short);
rescode		mixIsSilent(short);
rescode		mixLoadChannel(short, pmixSound *, short);
rescode		mixSetVolume(short, pmixVol);
rescode		mixGetVolume(short, pmixVol);
rescode		mixIsDataPlaying(pmem);
rescode		mixPause(void);
rescode		mixResume(void);
rescode		mixPump(void);
rescode		mixVolCreate(pmixVol, double, double);
rescode 	mixVolMult(pmixVol, pmixVol, pmixVol);
rescode		mixInstallCodec(pmixCodec);

#endif	// ifndef __PORT_H

