/*
 *  This file forms part of "TKERN" - "Troy's Kernel for Windows".
 *
 *  Copyright (C) 1994  Troy Rollo <troy@cbme.unsw.EDU.AU>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __tkern_h
#define __tkern_h

#ifndef __tfile__h
#include <sys/tfile.h>
#endif
#ifndef __task_h
#include <sys/task.h>
#endif

/* This file is only userful to TKERN and TKFMANGR, so we don't bother
 * with __TKPROTO
 */

extern	struct	tfile	_files[];
extern	struct	task	_tasks[];

extern	void	far tkern_wakeup_call(void);
extern	int	tkern_is_device(int, char const *);

extern	void	GetMessages(struct task *pt);
extern	void	FlushMessages(void);
extern	void	Copy_Array(char ***dest, char **source);

extern	struct task *GetTaskInfo(void);

extern	void	process_init(void);
extern	void	files_init(void);
extern	void	files_cleanup(void);

extern	void	internal_close(int fd, int iTask);


extern	int	nSleepers;
extern	int	nTasks;
extern	HWND	hwndManager;
extern	struct	tfunc *ptf;

#define	TKWM_WAKEUP	WM_USER + 100

#endif

