/*
 *  This file forms part of "TKERN" - "Troy's Kernel for Windows".
 *
 *  Copyright (C) 1994  Troy Rollo <troy@cbme.unsw.EDU.AU>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* This file defines the ioctl calls available for a window */
#ifndef __TKWIN_H
#define	__TKWIN_H

#ifndef	__TKIOCTL_H
#include <sys/ioctl.h>
#endif

#define	_WIOMAXNAME	255
typedef	char	_window_name_buf[_WIOMAXNAME];

struct	wio_parms
{
	int	wiop_scroll_lines;	/* Lines printed before forced scroll */
	int	wiop_history_lines;	/* Lines in history buffer */
	int	wiop_display_lines;	/* Maximum lines in display */
};

#define	WIOCGETHANDLE	_IO('w', 1)
#define	WIOCGETNAME	_IOWS('w', 2, _window_name_buf)
#define	WIOCSETNAME	_IORS('w', 3, _window_name_buf)
#define	WIOCGETPARMS	_IOW('w', 4, struct wio_parms)
#define	WIOCSETPARMS	_IOR('w', 5, struct wio_parms)

#endif /* __TKWIN_H */
