/*
 *  This file forms part of "TKERN" - "Troy's Kernel for Windows".
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <windows.h>
#include <toolhelp.h>
#include <sys/tdevice.h>
#include <sys/tfile.h>

extern	void	tkern_seterrno(int, int);
extern	void	tkern_register_manager(HWND);
extern	void	tkern_kill_ok(void);
extern	void	tkern_program_dead(HTASK, int);
extern	void	tkern_program_started(HTASK);

HINSTANCE	hInstance;
int	nLocks = 0;	// The number of things which must be freed before
			// we can exit
int	nError = 0;
BOOL	bTriedToExit = FALSE;

void
LockManager(void)
{
	nLocks++;
}

void
UnlockManager(void)
{
	nLocks--;
	if (!nLocks && bTriedToExit)
	{
		bTriedToExit = FALSE;
		tkern_kill_ok();
	}
}

int
GetMessages(void)
{
	MSG	msg;

	if (!GetMessage(&msg, 0, 0, 0))
		return 0;
	TranslateMessage(&msg);
	DispatchMessage(&msg);
	return 1;
}

void
FlushMessages(void)
{
	MSG	msg;

	while (PeekMessage(&msg, 0, 0, 0, PM_REMOVE))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
}

LRESULT	CALLBACK _export
CommsWindowProc(HWND	hWnd,
		UINT	wMsg,
		WPARAM	wParam,
		LPARAM	lParam)
{
	struct	tfunc	*ptf = (struct tfunc *) lParam;
	int		idFile = wParam;
	LONG	nResult;

	nError = 0;

	switch(wMsg)
	{
	case TKWM_OPEN:
		nResult =  (*dev_list[ptf->iDevice].open_strat)
				(ptf->achFile,
				 ptf->nMode,
				 ptf->nAccess);
		tkern_seterrno(nError, ptf->iTask);
		return nResult;

	case TKWM_CLOSE:
		nResult =  (*dev_list[ptf->iDevice].close_strat) (idFile);
		tkern_seterrno(nError, ptf->iTask);
		return nResult;

	case TKWM_SEEK:
		nResult =  (*dev_list[ptf->iDevice].seek_strat)
				(idFile,
				 ptf->nPosition,
				 ptf->nFrom);
		tkern_seterrno(nError, ptf->iTask);
		return nResult;

	case TKWM_READ:
		nResult =  (*dev_list[ptf->iDevice].read_strat)
				(idFile,
				 ptf->achBuffer,
				 ptf->nBytes);
		tkern_seterrno(nError, ptf->iTask);
		return nResult;

	case TKWM_WRITE:
		nResult =  (*dev_list[ptf->iDevice].write_strat)
				(idFile,
				 ptf->achBuffer,
				 ptf->nBytes);
		tkern_seterrno(nError, ptf->iTask);
		return nResult;

	case TKWM_IOCTL:
		nResult =  (*dev_list[ptf->iDevice].ioctl_strat) (idFile,
								  &ptf->tki);
		tkern_seterrno(nError, ptf->iTask);
		return nResult;

	case TKWM_GETDEVNO:
		nResult =  get_device_number(ptf->achFile);
		tkern_seterrno(nError, ptf->iTask);
		return nResult;

	case TKWM_ISATTY:
		nResult = (dev_list[ptf->iDevice].flags & DF_TTY) ? 1 : 0;
		tkern_seterrno(nError, ptf->iTask);
		return nResult;

	case TKWM_ALLDONE:
		if (nLocks)
			bTriedToExit = TRUE;
		else
			PostQuitMessage(0);
		return 1;

	default:
		return DefWindowProc(hWnd, wMsg, wParam, lParam);
	}
}

BOOL	CALLBACK _export
NotifyProc(	WORD	wID,
		DWORD	dwData)
{
	NFYRIP	*prip;

	switch(wID)
	{
	case NFY_EXITTASK:
		tkern_program_dead(GetCurrentTask(), LOWORD(dwData));
		break;

	case NFY_STARTTASK:
		tkern_program_started(GetCurrentTask());
		break;
	}
	return FALSE;
}

#pragma argsused
int	far	pascal
WinMain(HINSTANCE hInstance,
	HINSTANCE hPrec,
	LPSTR	lpCmdLine,
	int	nShow)
{
	MSG	msg;
	WNDCLASS wc;
	HWND	hWnd;
	LPFNNOTIFYCALLBACK lpfnNotify;
	char	achBuffer[80];

	wc.style = CS_GLOBALCLASS |
		   CS_HREDRAW |
		   CS_VREDRAW;
	wc.lpfnWndProc = CommsWindowProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(hInstance, "TKERN_ICO");
	wc.hCursor = 0;
	wc.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
	wc.lpszMenuName = 0;
	wc.lpszClassName = "Troy's Kernel Comms";
	RegisterClass(&wc);

	hWnd = CreateWindow(	"Troy's Kernel Comms",
				"TKERN Communications",
				WS_OVERLAPPEDWINDOW,
				CW_USEDEFAULT,
				0,
				CW_USEDEFAULT,
				0,
				0,
				0,
				hInstance,
				0
			);

	tkern_register_manager(hWnd);

	FlushMessages(); // If this isn't done, the NotifyRegister below, while
			 // returning success, just doesn't work.

	lpfnNotify = (LPFNNOTIFYCALLBACK) MakeProcInstance((FARPROC) NotifyProc, hInstance);
	NotifyRegister(GetCurrentTask(), lpfnNotify, NF_TASKSWITCH);

	while(GetMessages());

	NotifyUnRegister(GetCurrentTask());
	FreeProcInstance((FARPROC) lpfnNotify);
	DestroyWindow(hWnd);

	return 0;
}
