///////////////////////////////////////////////////////////////////////////
// TabDlg Version 3.0
// Copyright (c) 1994 Edward McCreary.
// All rights reserved.
//
// Redistribution and use in source and binary forms are freely permitted
// provided that the above copyright notice and attibution and date of work
// and this paragraph are duplicated in all such forms.
// THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
// WARRANTIES OF MERCHANTIBILILTY AND FITNESS FOR A PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////
// File:    internal.h
// Author:  Ed McCreary
// Date:    11/7/94
// Purpose: defines structures and constants internal to library
///////////////////////////////////////////////////////////////////////////
#ifndef _INTERNAL_H
#define _INTERNAL_H

// class style
#define TAB_CLASS    CS_GLOBALCLASS | CS_HREDRAW | CS_VREDRAW

// fudge factor for end of tab
#define WIDTH_FUDGE 5

// internal structures

// one control in a tab
typedef struct tagTabChildControl
{
    WORD    wID;                        // control id
    struct tagTabChildControl *next;    // next in linked list of controls
} TABCHILDCTL, FAR *LPTABCHILDCTL;


// single tab page
typedef struct tagTabPage
{
    char    *szCaption;                 // caption of tab
    RECT    rcTab;                      // tab rectangle    
    RECT    rcCaption;                  // caption of rectangle
    
    WORD    wIndex;                     // index of tab    
    LPTABCHILDCTL   lpControls;         // linked list of controls in tab
    
    struct tagTabPage   *next;          // next in linked list of tab pages
    struct tagTabPage   *prev;          // previous in linked list of tab pages

}   TABPAGE, FAR *LPTABPAGE;



// one per tab control
typedef struct tagTabControlBlock
{
    HWND        hWnd;                       // window handle of main control    
    WORD        wNumTabs;                   // number of tabs in control
    WORD        wStaticCount;               // count of controls with -1 id
    
    LPTABPAGE   pActiveTab;                 // pointer to currently active tab
    WORD        wTabHeight;                 // height of tab in pixels    
    LPTABPAGE   lpHead;                     // head of linked list of tab pages 
    LPTABPAGE   lpTail;                     // tail of linked list of tab pages
    BOOL        bShadow;                    // true if draw shadow text for caption

} TABCTLBLK, FAR *LPTABCTLBLK;


// window word bytes
#define CBWNDEXTRA  8   // number of required extra fonts
#define GWW_DATA    0   // offset to data info
#define GWW_FONT    2   // offset to active font data
#define GWW_DEPRESSEDFONT   4  // ofset to depressed font data
#define GWW_TABWIDTH   6          // offset to width of tab data

// index into pen arrays
#define PEN_BLACK   0
#define PEN_WHITE   1
#define PEN_SHADOW  2

// structs used for manipulating dialog templates
typedef struct {
   long dtStyle;
   BYTE dtItemCount;
   int  dtX;
   int  dtY;
   int  dtCX;
   int  dtCY;
// char dtMenuName[];      // Variable-length string.
// char dtClassName[];     // Variable-length string.
// char dtCaptionText[];   // Variable-length string.
} DLGTEMPLATE, FAR *LPDLGTEMPLATE;

typedef struct {
   short int PointSize;
// char  szTypeFace[];     // Variable-length string.
} FONTINFO, FAR *LPFONTINFO;

typedef struct {
   int  dtilX;
   int  dtilY;
   int  dtilCX;
   int  dtilCY;
   int  dtilID;
   long dtilStyle;
// char dtilClass[];       // Variable-length string.
// char dtilText[];        // Variable-length string.
// BYTE dtilInfo;          // # bytes in following memory block.
// BYTE dtilData;          // Variable-length memory block.
} DLGITEMTEMPLATE, FAR *LPDLGITEMTEMPLATE;


#define PREDEFINEDCNTRLBIT       0x80
#define BUTTONCNTRLCODE          0x80
#define EDITCNTRLCODE            0x81
#define STATICCNTRLCODE          0x82
#define LISTBOXCNTRLCODE         0x83
#define SCROLLBARCNTRLCODE       0x84
#define COMBOBOXCNTRLCODE        0x85


// local prototypes
BOOL WINAPI TabControlInit(void);
void WINAPI TabControlExit(void);
LRESULT WINAPI TabDlgWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
void WINAPI DrawRoundBorder(HDC hdc, LPRECT lprc, LPTABCTLBLK pData, HPEN *pPens);
WORD WINAPI CalcTabHeight(HWND hWnd);
HFONT WINAPI GetDepressedTabFont(void);
HFONT WINAPI GetActiveTabFont(HWND hWnd);
LRESULT WINAPI OnNCCreate(HWND hWnd, CREATESTRUCT FAR *lpcs);
LRESULT WINAPI OnPaint(LPTABCTLBLK pData);

LRESULT WINAPI OnAddTab(LPTABCTLBLK pData, WPARAM wParam, LPARAM lParam);
int WINAPI CreateNewTab(LPTABCTLBLK pData,LPDLGTEMPLATE lpDlgTemplate);

BOOL WINAPI AppendControlToTab(LPTABPAGE pTab, WORD nID);
BOOL WINAPI CreateTabControls(LPTABCTLBLK pData, LPTABPAGE pTab, LPDLGTEMPLATE lpDlgTemplate);
void WINAPI FreeTab(LPTABPAGE pTab);
LRESULT WINAPI OnNCDestroy(LPTABCTLBLK pData); 
LPTABPAGE WINAPI GetTabPtrByIndex(LPTABCTLBLK pData, WORD wIndex);
LRESULT WINAPI OnSetCurSel(LPTABCTLBLK pData, WORD wIndex);
void WINAPI CalcTabRect(LPTABCTLBLK pData,LPTABPAGE  pTabPage);
void WINAPI DrawUpTab(HDC hdc, LPTABCTLBLK pData,LPTABPAGE  pTabPage, HPEN *pPens);
void WINAPI DrawDownTab(HDC hdc, LPTABCTLBLK pData,LPTABPAGE  pTabPage, HPEN *pPens);
LRESULT OnLButtonDown(LPTABCTLBLK pData, POINT  *lpPt);
void WINAPI DrawTabText(HDC hdc, LPTABCTLBLK pData,LPTABPAGE  pTabPage);
LRESULT WINAPI NotifyParent(HWND hWndControl, WORD wNotifyCode) ;
LRESULT WINAPI OnDeleteTab(LPTABCTLBLK pData,WORD wIndex);                    
LRESULT WINAPI OnFindTab(LPTABCTLBLK pData,LPCSTR lpBuffer);
LRESULT WINAPI OnGetTextLength(LPTABCTLBLK pData,WORD wIndex);
LRESULT WINAPI OnGetText(LPTABCTLBLK pData,WORD wIndex,LPSTR lpBuffer);
LPTABPAGE GetTabByIndex(LPTABCTLBLK pData,WORD wIndex);
WORD CalcTabWidth(LPTABCTLBLK pData);
#endif /* _INTERNAL_H */