Option Explicit


Type RECT
    left As Integer
    top As Integer
    right As Integer
    bottom As Integer
End Type

' Windows API calls
Declare Sub ClipCursor Lib "User" (lpRect As RECT)
Declare Sub GetClipCursor Lib "User" (lprc As RECT)
Declare Sub GetWindowRect Lib "User" (ByVal hWnd As Integer, lpRect As RECT)
Declare Function GetDesktopWindow Lib "User" () As Integer

' Restore cursor clipping to whole screen
Sub ClipCursorToScreen ()
Dim rectScreen As RECT

    ' Get unclipped whole screen for later.
    Call GetWindowRect(GetDesktopWindow(), rectScreen)

    ' Set clipping to rectangle
    Call ClipCursor(rectScreen)
End Sub

' Clip cursor to window of handle parameter
Sub ClipCursorToWindow (ByVal hWnd As Integer)
Dim r As RECT

    ' get window rectangle
    Call GetWindowRect(hWnd, r)

    ' clip to rectangle
    Call ClipCursor(r)
    
End Sub
