'VBLZH.DLL by Philip Bush - Copyright 1995
'
' Compression/Decompression, file functions, and disk space functions for Visual Basic
'
' SHAREWARE FEE $15
'
' Benefits:  - Unlimited distribution rights for registered users.
'            - Receive the latest registered version by floppy disk.
'            - Removes shareware notice from compression/decompression status window.
'
' Borland Delphi (pascal) VBLZH.DLL source code $99.
'
' Philip Bush
' Macware
' 748 N. Hwy 67, Suite 163
' Florissant, MO  63031
'
' check/money order/cash/Visa/Mastercard payments accepted
'
' phone: (314) 838-7620    email: WWHH86A@PRODIGY.COM

'**PROCEDURE/FUNCTION SUMMARY**

'  LZH                lzh compression & decompression of files, includes status Window
'  DelFile%           deletes file from a disk
'  RenFile%           renames a file
'  GetFileSize&       file size in bytes
'  FileExist%         does file exist
'  CopyFile%          copies a file
'  RetrieveFileName$  retrieves the file name from fully or partially qualified path name
'  RetrieveFilePath$  retrieves the file path from fully or partially qualified path name
'  FileDate&          date of the file named by FName as a LongInt (use CVDATE to evaluate)
'  FileExtension$     returns a string containing the three-character extension
'  FSearch$           searches through directories for a particular file name
'  FAttribDescr$      returns a file attribute description (/ delimited text description)
'  FAttribVal%        returns file attribute value
'  FileSetAttrib%     set a file's attributes
'  DiskFreeSpace&     returns a disk's free space in bytes
'  DiskSpace&         returns disk size in bytes

'**DECLARE**

Declare Sub LZH Lib "VBLZH.DLL" (ByVal fromfile$, ByVal tofile$, ByVal action$, errc&, inf&, otf&)
Declare Function DelFile% Lib "VBLZH.DLL" (ByVal FName$)
Declare Function RenFile% Lib "VBLZH.DLL" (ByVal OldF$, ByVal NewF$)
Declare Function GetFileSize& Lib "VBLZH.DLL" (ByVal FName$)
Declare Function FileExist% Lib "VBLZH.DLL" (ByVal FName$)
Declare Function CopyFile% Lib "VBLZH.DLL" (ByVal FromF$, ByVal ToF$)
Declare Function RetrieveFileName$ Lib "VBLZH.DLL" (ByVal FName$)
Declare Function RetrieveFilePath$ Lib "VBLZH.DLL" (ByVal FName$)
Declare Function FileDate& Lib "VBLZH.DLL" (ByVal FName$)
Declare Function FileExtension$ Lib "VBLZH.DLL" (ByVal FName$)
Declare Function FSearch$ Lib "VBLZH.DLL" (ByVal FName$, ByVal DirList$)
Declare Function FAttribVal% Lib "VBLZH.DLL" (ByVal FName$)
Declare Function FAttribDescr$ Lib "VBLZH.DLL" (ByVal FName$)
Declare Function FileSetAttrib% Lib "VBLZH.DLL" (ByVal FName$, ByVal attr%)
Declare Function DiskFreeSpace& Lib "VBLZH.DLL" (ByVal driveltr$)
Declare Function DiskSpace& Lib "VBLZH.DLL" (ByVal driveltr$)

'**INSTRUCTIONS**

'*LZH file compression & decompression
' usage:
'  fromfile$ = original file
'  tofile$   = destination file (caution, will be overwritten!)
'  action$   = "E" = compresss (encode)  "D" = uncompress (decode)
'
' returns:
'  errc& (error codes):
'   errc& = -1   no error encountered
'   errc& =  1   Error reading input file
'   errc& =  2   Error writing output file
'   errc& =  3   Error opening input
'   errc& =  4   Error opening output
'   errc& =  5   Error: use [D] for Decompression or [E] for Compression
'   errc& =  6   overflow read error - usually during decode on a non-compressed file
'   errc& =  7   overflow write error - usually during decode on a non-compressed file
'   errc& =  8   Error getting filesize
'
'  inf& = original file size in bytes
'  otf& = destination file size in bytes
'
'Declare Sub LZH Lib "VBLZH.DLL" (ByVal fromfile$, ByVal tofile$, ByVal action$, errc&, inf&, otf&)

'*Delete File
' -1 = successful, 0 = failed (file cannot be deleted or does not exist)
'
'Declare Function DelFile% Lib "VBLZH.DLL" (ByVal Fname$)

'*RenFile function attempts to change the name of the file specified by Old to New
' -1 = successful, false = failed (will not rename if new already exists)
'
'Declare Function RenFile% Lib "VBLZH.DLL" (ByVal OldF$,ByVal NewF$)

'*GetFileSize function returns the file size in bytes
'HFILE_ERROR or -1 = failed, >= 0 file size in bytes
'
'Declare Function GetFileSize& Lib "VBLZH.DLL" (ByVal Fname$)

'*FileExist function tests if a file exists
' -1 = file exists, 0 = file doesn't exist
'
'Declare Function FileExist% Lib "VBLZH.DLL" (ByVal Fname$)

'*CopyFile function copies the FromFile to the ToFile
' -1 = successful, 0 = file copy failed
'
'Declare Function CopyFile% Lib "VBLZH.DLL" (ByVal FromF$, ByVal ToF$)

'*RetrieveFileName takes a fully or partially qualified path name in FName and returns
'  a string containing only the file name part, including the name and extension.
'
'Declare Function RetrieveFileName$ Lib "VBLZH.DLL" (ByVal FName$)

'*RetrieveFilePath takes a fully or partially qualified path name in FName and returns
'  a string containing only the path part (drive letter and directories).
'
'Declare Function RetrieveFilePath$ Lib "VBLZH.DLL" (ByVal FName$)

'*FileDate function returns the date of the file named by FName as a LongInt.
'  Use the VB function CVDATE to evaluate. Ex: Dt$=CVDATE(FileDate&("C:\AUTOEXEC.BAT"))
'  -999999 = error. usually indicates that the file doesn't exist.
'             (note: check for this value - CVDATE will return an error using this value)
'
'Declare Function FileDate& Lib "VBLZH.DLL" (ByVal FName$)

'*FileExtension function takes a fully qualified FileName and returns a string
'  containing the three-character extension.
'
'Declare Function FileExtension$ Lib "VBLZH.DLL" (ByVal FName$)

'*FSearch function searches through the directories passed in DirList for a file named
'  Name. DirList should be in the same format as a DOS PATH: directory names
'  separated by semicolons. If FileSearch locates a file matching Name, it returns a string
'  containing a fully-qualified path name for that file. If no matching file exists,
'  FileSearch returns an empty string.
'
'Declare Function FSearch$ Lib "VBLZH.DLL" (ByVal FName$, Byval DirList$)

'*FAttribVal returns the file attributes of the file given by FName.  The attributes can
'  be examined by AND-ing with the constants listed below. If the return value is negative,
'  an  error occurred and the value is a negative DOS error code.
'    Normal            0
'    Read-only files   1
'    Hidden files      2
'    System files      4
'    Volume ID files   8
'    Directory files  16
'    Archive files    32
'    Unusual          63
'
' <0 = error
'
'Declare Function FAttribVal% Lib "VBLZH.DLL" (ByVal FName$)

'*FAttribDescr returns the file attributes of the file given by FName.  The attributes are
'  in a slash (\) delimited string.
'  Returns may include: Normal,Read-only,Hidden,System,Volume, Directory, Archive, Unusual
'                       and Error
'
'Declare Function FAttribDescr$ Lib "VBLZH.DLL" (ByVal FName$)

'*FileSetAttrib sets the file attributes of the file given by FileName to the value given
'  by Attr. The attribute value is formed by OR-ing the appropriate constants (listed below).
'  The return value is zero if the function was successful. Otherwise the return value is a
'   negative DOS error code.
'    Normal            0
'    Read-only files   1
'    Hidden files      2
'    System files      4
'    Volume ID files   8
'    Directory files  16
'    Archive files    32
'    Unusual          63
'
' <0 = error
'
'Declare Function FileSetAttrib% Lib "VBLZH.DLL" (ByVal FName$, ByVal attr%)


'Disk Free Space returns the free space in bytes of the specified drive
' -1 = drive letter is invalid, >=0 = disk free space in bytes
'
'Declare Function DiskFreeSpace& Lib "VBLZH.DLL" (ByVal driveltr$)

'*DiskSpace returns the size in bytes of the specified drive
' -1 = drive letter is invalid, >=0 = disk size in bytes
'
'Declare Function DiskSpace& Lib "VBLZH.DLL" (ByVal driveltr$)

