#include <windows.h>
#include <stdio.h>
#include "visualib.h"
#include "vlibdemo.h"
#include "dialogs.h"

static POINT3D	p3;
static POINT2D	p2;

BOOLEAN	DlgInputPoint3D (HWND hdlg, UINT msg, WPARAM wp, LPARAM lp)
{
	char	buf[20];
	REAL	x;

    switch (msg) {
		case WM_INITDIALOG:
			sprintf (buf, "%.3f", (REAL) p3.x);
			SetDlgItemText (hdlg, XCOORD, buf);
			sprintf (buf, "%.3f", (REAL) p3.y);
			SetDlgItemText (hdlg, YCOORD, buf);
			sprintf (buf, "%.3f", (REAL) p3.z);
			SetDlgItemText (hdlg, ZCOORD, buf);
			return (TRUE);
		case WM_COMMAND:
			switch (wp) {
				case IDOK:
					GetDlgItemText (hdlg, XCOORD, buf, 20);
					if (sscanf (buf, "%f", &x))
						p3.x = x;
					GetDlgItemText (hdlg, YCOORD, buf, 20);
					if (sscanf (buf, "%f", &x))
						p3.y = x;
					GetDlgItemText (hdlg, ZCOORD, buf, 20);
					if (sscanf (buf, "%f", &x))
						p3.z = x;
					EndDialog (hdlg, TRUE);
					return (TRUE);

                case IDCANCEL:
					EndDialog (hdlg, TRUE);
					break;
			}
			break;
    }
    return (FALSE);			      /* Didn't process a message    */
}

BOOLEAN	InputPoint3D (LPPOINT3D p)
{
	BOOL	flag;
	
	p3 = *p;
	flag = DialogBox (hinst, MAKEINTRESOURCE(DLGSETPOINT3D), NULL, DlgInputPoint3D) > 0;
	if (flag)
		*p = p3;
	return (flag);
}

BOOLEAN DlgInputPoint2D (HWND hdlg, UINT msg, WPARAM wp, LPARAM lp)
{
	char	buf[20];
	REAL	x;

    switch (msg) {
		case WM_INITDIALOG:
			sprintf (buf, "%.3f", (REAL) p2.x);
			SetDlgItemText (hdlg, XCOORD, buf);
			sprintf (buf, "%.3f", (REAL) p2.y);
			SetDlgItemText (hdlg, YCOORD, buf);
			return (TRUE);
		case WM_COMMAND:
			switch (wp) {
				case IDOK:
					GetDlgItemText (hdlg, XCOORD, buf, 20);
					if (sscanf (buf, "%f", &x))
						p2.x = x;
					GetDlgItemText (hdlg, YCOORD, buf, 20);
					if (sscanf (buf, "%f", &x))
						p2.y = x;
					EndDialog (hdlg, TRUE);
					return (TRUE);

                case IDCANCEL:
					EndDialog (hdlg, TRUE);
					break;
			}
			break;
    }
    return (FALSE);			      /* Didn't process a message    */
}

BOOLEAN	InputPoint2D (LPPOINT2D p)
{
	BOOL	flag;
	
	p2 = *p;
	flag = DialogBox (hinst, MAKEINTRESOURCE(DLGSETPOINT2D), NULL, DlgInputPoint2D) > 0;
	if (flag)
		*p = p2;
	return (flag);
}

BOOLEAN	DlgLightSetup (HWND hdlg, UINT msg, WPARAM wp, LPARAM lp)
{
	char	buf[20];
	REAL	x, lx, ly, lz, dx, dy, dz;
	BOOL	lighton;
	COLORREF color;

    switch (msg) {
		case WM_INITDIALOG:
			GetLightLocation (VL_CURRENT, &lx, &ly, &lz);
			GetLightDirection (VL_CURRENT, &dx, &dy, &dz);
			lighton = SwitchLight (VL_CURRENT, VL_INQUIRE);
			
			sprintf (buf, "%.3f", (REAL) lx);
			SetDlgItemText (hdlg, LIGHTLOCX, buf);
			sprintf (buf, "%.3f", (REAL) ly);
			SetDlgItemText (hdlg, LIGHTLOCY, buf);
			sprintf (buf, "%.3f", (REAL) lz);
			SetDlgItemText (hdlg, LIGHTLOCZ, buf);
			
			sprintf (buf, "%.3f", (REAL) dx);
			SetDlgItemText (hdlg, LIGHTDIRX, buf);
			sprintf (buf, "%.3f", (REAL) dy);
			SetDlgItemText (hdlg, LIGHTDIRY, buf);
			sprintf (buf, "%.3f", (REAL) dz);
			SetDlgItemText (hdlg, LIGHTDIRZ, buf);

			CheckDlgButton (hdlg, LIGHTON, lighton);
			
			return (TRUE);
		case WM_COMMAND:
			switch (wp) {
				case LIGHTCOLOR:
					color = LightColor (VL_CURRENT, VL_INQUIRE);
					color = SelectColor (color);
					LightColor (VL_CURRENT, color);
					return (TRUE);
			
				case IDOK:
					GetDlgItemText (hdlg, LIGHTLOCX, buf, 20);
					if (sscanf (buf, "%f", &x))
						lx = x;
					GetDlgItemText (hdlg, LIGHTLOCY, buf, 20);
					if (sscanf (buf, "%f", &x))
						ly = x;
					GetDlgItemText (hdlg, LIGHTLOCZ, buf, 20);
					if (sscanf (buf, "%f", &x))
						lz = x;
					
					GetDlgItemText (hdlg, LIGHTDIRX, buf, 20);
					if (sscanf (buf, "%f", &x))
						dx = x;
					GetDlgItemText (hdlg, LIGHTDIRY, buf, 20);
					if (sscanf (buf, "%f", &x))
						dy = x;
					GetDlgItemText (hdlg, LIGHTDIRZ, buf, 20);
					if (sscanf (buf, "%f", &x))
						dz = x;
					
					lighton = IsDlgButtonChecked (hdlg, LIGHTON);
					
					SetLightLocation (VL_CURRENT, lx, ly, lz);
					SetLightDirection (VL_CURRENT, dx, dy, dz);
					SwitchLight (VL_CURRENT, lighton);
					
					EndDialog (hdlg, TRUE);
					return (TRUE);

                case IDCANCEL:
					EndDialog (hdlg, TRUE);
					break;
			}
			break;
    }
    return (FALSE);			      /* Didn't process a message    */
}


BOOLEAN DlgMaterial (HWND hdlg, UINT msg, WPARAM wp, LPARAM lp)
{
	COLORREF color;
	
    switch (msg) {
		case WM_INITDIALOG:
			return (TRUE);
			
		case WM_COMMAND:
			switch (wp) {
				case MATDIFFUSE:
					color = MaterialDiffuse (VL_CURRENT, VL_INQUIRE);
					color = SelectColor (color);
					MaterialDiffuse (VL_CURRENT, color);
					return (TRUE);
				case MATAMBIENT:
					color = MaterialAmbient (VL_CURRENT, VL_INQUIRE);
					color = SelectColor (color);
					MaterialAmbient (VL_CURRENT, color);
					return (TRUE);
				case MATSPECULAR:
					color = MaterialSpecular (VL_CURRENT, VL_INQUIRE);
					color = SelectColor (color);
					MaterialSpecular (VL_CURRENT, color);
					return (TRUE);
				case MATEMISSION:
					color = MaterialEmission (VL_CURRENT, VL_INQUIRE);
					color = SelectColor (color);
					MaterialEmission (VL_CURRENT, color);
					return (TRUE);
			
				case IDOK:
					EndDialog (hdlg, TRUE);
					return (TRUE);

                case IDCANCEL:
					EndDialog (hdlg, TRUE);
					break;
			}
			break;
    }
    return (FALSE);			      /* Didn't process a message    */
}

BOOLEAN	DlgTexture (HWND hdlg, UINT msg, WPARAM wp, LPARAM lp)
{
	static WORD texture = TEXTURENONE;
	static WORD check1, check2, check3, check4;
	
    switch (msg) {
		case WM_INITDIALOG:
			CheckRadioButton (hdlg, TEXTURENONE, TEXTUREGRANITE, texture);
			check1 = ShadingPerturbation (VL_PERTURBMATERIAL, VL_INQUIRE);
			CheckDlgButton (hdlg, IDC_CHECK1, check1);
			check2 = ShadingPerturbation (VL_PERTURBNORMAL, VL_INQUIRE);
			CheckDlgButton (hdlg, IDC_CHECK2, check2);
			check3 = ShadingPerturbation (VL_PERTURBPIXEL, VL_INQUIRE);
			CheckDlgButton (hdlg, IDC_CHECK3, check3);
			check4 = ShadingPerturbation (VL_PERTURBFACET, VL_INQUIRE);
			CheckDlgButton (hdlg, IDC_CHECK4, check4);
			return (TRUE);
			
		case WM_COMMAND:
			switch (wp) {
				case TEXTURENONE:
				case TEXTUREMARBLE:
				case TEXTUREWOOD:
				case TEXTUREGRANITE:
					texture = wp;
					CheckRadioButton (hdlg, TEXTURENONE, TEXTUREWOOD, wp);
					return (TRUE);
				case IDC_CHECK1:
					check1 = !check1;
					CheckDlgButton (hdlg, IDC_CHECK1, check1);
					break;
				case IDC_CHECK2:
					check2 = !check2;
					CheckDlgButton (hdlg, IDC_CHECK2, check2);
					break;
				case IDC_CHECK3:
					check3 = !check3;
					CheckDlgButton (hdlg, IDC_CHECK3, check3);
					break;
				case IDC_CHECK4:
					check4 = !check4;
					CheckDlgButton (hdlg, IDC_CHECK4, check4);
					break;
				case IDOK:
					switch (texture) {
						case TEXTUREMARBLE:
							SolidTexture (VL_MARBLE);
							break;
						case TEXTUREWOOD:
							SolidTexture (VL_WOODGRAIN);
							break;
						case TEXTUREGRANITE:
							SolidTexture (VL_GRANITE);
							break;
						default:
							SolidTexture (VL_NONE);
							break;
					}
					ShadingPerturbation (VL_PERTURBMATERIAL, check1);
					ShadingPerturbation (VL_PERTURBNORMAL, check2);
					ShadingPerturbation (VL_PERTURBPIXEL, check3);
					ShadingPerturbation (VL_PERTURBFACET, check4);
					EndDialog (hdlg, TRUE);
					return (TRUE);

                case IDCANCEL:
					EndDialog (hdlg, TRUE);
					break;
			}
			break;
    }
    return (FALSE);			      /* Didn't process a message    */
}

BOOLEAN DlgShading (HWND hdlg, UINT msg, WPARAM wp, LPARAM lp)
{
	static int mode, mbutton;
	
    switch (msg) {
		case WM_INITDIALOG:
			mode = ShadingMethod (VL_INQUIRE);
			switch (mode){
				case VL_WIREFRAME:
                    mbutton = WIREFRAME;
                    break;
                case VL_SOLIDFILL:
                    mbutton = SOLIDFILL;
                    break;
                case VL_FLATSHADE:
                    mbutton = FLATSHADING;
                    break;
                case VL_GOURAUDSHADE:
                    mbutton = GOURAUD;
                    break;
                case VL_PHONGSHADE:
                    mbutton = PHONG;
                    break;
				case VL_SPECULARMODEL:
					break;
			}
			CheckRadioButton (hdlg, WIREFRAME, SPECULAR, mbutton);
			
			CheckDlgButton (hdlg, DEPTHBUFFER, DepthBuffer (VL_INQUIRE));
			CheckDlgButton (hdlg, LOCALVIEWER, LocalViewer (VL_INQUIRE));
			CheckDlgButton (hdlg, TWOSIDE, TwoSideShading (VL_INQUIRE));
			CheckDlgButton (hdlg, BACKFACEREM, BackFaceRemoval (VL_INQUIRE));

			return (TRUE);
			
		case WM_COMMAND:
			switch (wp) {
				case WIREFRAME:
                case SOLIDFILL:
                case FLATSHADING:
                case GOURAUD:
                case PHONG:
				case SPECULAR:
					mbutton = wp;
					CheckRadioButton (hdlg, WIREFRAME, SPECULAR, wp);
					return (TRUE);
			
				case IDOK:
					switch (mbutton) {
						case WIREFRAME:
							mode = VL_WIREFRAME;
							break;
						case SOLIDFILL:
							mode = VL_SOLIDFILL;
							break;
						case FLATSHADING:
							mode = VL_FLATSHADE;
							break;
						case GOURAUD:
							mode = VL_GOURAUDSHADE;
							break;
						case PHONG:
							mode = VL_PHONGSHADE;
							break;
						case SPECULAR:
							mode = VL_PHONGSHADE;
							break;
				    }
					ShadingMethod (mode);
					
					DepthBuffer (IsDlgButtonChecked (hdlg, DEPTHBUFFER));
					LocalViewer (IsDlgButtonChecked (hdlg, LOCALVIEWER));
					TwoSideShading (IsDlgButtonChecked (hdlg, TWOSIDE));
					BackFaceRemoval (IsDlgButtonChecked (hdlg, BACKFACEREM));

					EndDialog (hdlg, TRUE);
					return (TRUE);

                case IDCANCEL:
					EndDialog (hdlg, TRUE);
					break;
			}
			break;
    }
    return (FALSE);			      /* Didn't process a message    */
}
