APPDIR = 
LIBDIR = 
SRCDIR = 
MISCDIR = 

MODULE	= vlibdemo
SOURCE	= vlibdemo.c demoproc.c dialogs.c

LIBS    = libw mlibcew commdlg $(LIBDIR)\visualib $(LIBDIR)\modellib

##### DEBUG Defined #####
DEBUG	= 0

##### Build Option Macros #####
!if $(DEBUG)
DDEF	= -DDEBUG
CLOPT	= -Zid -Od
LOPT	= /CO /LI
!else
DDEF	= -DNDEBUG
CLOPT	= -Oxwzp
LOPT	=
!endif

##### Tool Macros #####
CC	= cl -AM -Gw -nologo -c -G3s -Zp -W1 $(CLOPT) $(DDEF) $(DEF)

LINK	= link /NOD /NOE $(LOPT)
IMPLIB  = implib -nologo -noignorecase
RC	= rc $(DDEF)

##### Main (default) Target #####
goal:	$(APPDIR)\$(MODULE).exe

{$(SRCDIR)\}.c.obj:
	$(CC) $(SRCDIR)\$*.c

$(MODULE).res:	$(SRCDIR)\$(MODULE).rc
	rc -i $(MISCDIR) -r -fo$@ $**

$(APPDIR)\$(MODULE).exe: $(MODULE).res $(SOURCE:.c=.obj) $(SRCDIR)\$(MODULE).def $(LIBDIR)\visualib.lib $(LIBDIR)\modellib.lib
    $(LINK) @<<
    $(SOURCE:.c=.obj),
    $(APPDIR)\$*.exe,,
    $(LIBS),
    $(SRCDIR)\$(MODULE).def
<<
	$(RC) -T -K $(MODULE).res $@

$(LIBDIR)\$(MODULE).lib:	$(SRCDIR)\$(MODULE).def
    $(IMPLIB) $@ $**

##### Clean Directory #####
clean:
	del *.obj
	del *.res
