/****************************************************************
 **  Driver for Microsoft's CTL3D and CTL3DV2 3D Controls DLLs **
 **                  (c) Pekic Zoltan, 1994.                   **
 ****************************************************************/
#include <string.h>
#include <windows.h>
#include <toolhelp.h>
#include <mmsystem.h>

#define WM_FILLLB WM_USER+1
#define WM_ADDLB  WM_USER+2

const int iVer=01,iRev=27;
const char *cDrvName="3D Controls Driver";
const char *cDrvFile="z3dc.drv";
BOOL b3DV1,b3DV2,bBeep,bSubX,bDisabled;
OFSTRUCT OFS;
HHOOK Hook;
HINSTANCE hIDrv;
HINSTANCE hICtl3D;
HWND hWndSetup,hWndShell;
FARPROC OldShellWndProc;

const UINT  uResource[3]={GFSR_SYSTEMRESOURCES,GFSR_USERRESOURCES,GFSR_GDIRESOURCES};
const char* pcResource[3]={"%u %% (SYSTEM)"     ,"%u %% (USER)"    ,"%u %% (GDI)"};

struct Z3DENTRY{
					 HWND  hwndZ;
					 HTASK htaskZ;
					 TASKENTRY TE;
					 HINSTANCE hlibZ;
					};

#define MAX_Z3 31
struct Z3DENTRY Z3List[MAX_Z3+1];

#define MAX_M 31
char cModuleOffTheHook[MAX_M+1][MAX_MODULE_NAME+1];
int iLastOffTheHook;

#define MAX_BUFF (MAX_M+1)*(MAX_MODULE_NAME+1)
char cTxtBuff[MAX_BUFF];

char cShellName[128];

void CenterDialog(HWND hD)
{
 RECT R;
 GetWindowRect(hD,&R);
 SetWindowPos(hD,HWND_TOP,(GetSystemMetrics(SM_CXSCREEN)-R.right+R.left) >>1,(GetSystemMetrics(SM_CYSCREEN)-R.bottom+R.top) >>1,0,0,SWP_NOSIZE | SWP_NOZORDER);
}

RECT GetControlRect(HWND hWDlg,int iCtlID)
{
 RECT DlgRect,CtlRect,R;
 int iW,iH;
 GetWindowRect(hWDlg,&DlgRect);
 GetWindowRect(GetDlgItem(hWDlg,iCtlID),&CtlRect);
 iW=CtlRect.right-CtlRect.left;iH=CtlRect.bottom-CtlRect.top;
 R.left=CtlRect.left-DlgRect.left;
 R.top=CtlRect.top-DlgRect.top;
 R.right=R.left+iW;
 R.bottom=R.top+iH;
 return R;
}

BOOL CALLBACK DlgExitWinProc(HWND hDlg,UINT Msg,WPARAM wParam,LPARAM lParam)
{
#define IDEXITTODOS   200
#define IDEXITRESTART 201
#define IDEXITREBOOT  202
 static int i,iExitMode,iTimer;
 int iTick,iHrs,iMin,iSec;
 static RECT IconRect;
 HDC hDlgDC;
 PAINTSTRUCT PS;
 static HICON hModeIcon[3];
 switch (Msg)
 {
  case WM_INITDIALOG:
  {
	CenterDialog(hDlg);
	iTimer=SetTimer(hDlg,1,1000,NULL);
	if (iTimer) PostMessage(hDlg,WM_TIMER,1,0);
	hModeIcon[0]=LoadIcon(hIDrv,"ICN_DOS");
	hModeIcon[1]=LoadIcon(hIDrv,"ICN_WIN");
	hModeIcon[2]=LoadIcon(hIDrv,"ICN_BOOT");
	IconRect=GetControlRect(hDlg,101);
	IconRect.top +=10;IconRect.bottom=IconRect.top +40;
	IconRect.left+=10;IconRect.right =IconRect.left+40;
	iExitMode=IDEXITTODOS;
	CheckRadioButton(hDlg,IDEXITTODOS,IDEXITREBOOT,iExitMode);
	return TRUE;
  }
  case WM_TIMER:
  {
	iTick=GetTickCount() / 1000;
	iHrs=iTick / 3600;iTick-=3600*iHrs;
	iMin=iTick /   60;
	iSec=iTick-60*iMin;
	wsprintf(cTxtBuff,"%02d : %02d : %02d",iHrs,iMin,iSec);
	SetDlgItemText(hDlg,300,(LPCSTR) cTxtBuff);
	return TRUE;
  }
  case WM_PAINT:
  {
	hDlgDC=BeginPaint(hDlg,&PS);
	DrawIcon(hDlgDC,IconRect.left,IconRect.top,hModeIcon[iExitMode-IDEXITTODOS]);
	EndPaint(hDlg,&PS);
  };break;
  case WM_COMMAND:
  {
	switch (wParam)
	{
	 case IDOK:
	 {
	  for(i=0;i<3;i++) DestroyIcon(hModeIcon[i]);
	  if (iTimer) KillTimer(hDlg,1);
	  EndDialog(hDlg,iExitMode==IDEXITTODOS ? 0 :(iExitMode==IDEXITRESTART ? EW_RESTARTWINDOWS : EW_REBOOTSYSTEM));
	  return TRUE;
	 }
	 case IDCANCEL:
	 {
	  for(i=0;i<3;i++) DestroyIcon(hModeIcon[i]);
	  if (iTimer) KillTimer(hDlg,1);
	  EndDialog(hDlg,IDCANCEL);
	  return TRUE;
	 }
	 case IDEXITTODOS:
	 case IDEXITRESTART:
	 case IDEXITREBOOT:
	 {
	  iExitMode=wParam;
	  CheckRadioButton(hDlg,IDEXITTODOS,IDEXITREBOOT,iExitMode);
	  InvalidateRect(hDlg,&IconRect,TRUE);
	  UpdateWindow(hDlg);
	  return TRUE;
	 }
	}
  }
 }
 return FALSE;
}

void PrintVersion(HWND hD,int iResID,int iMajor,int iMinor)
{
 wsprintf(cTxtBuff,"%u.%02u",iMajor,iMinor);
 SetDlgItemText(hD,iResID,cTxtBuff);
};

BOOL CALLBACK DlgAboutProc(HWND hDlg,UINT Msg,WPARAM wParam,LPARAM lParam)
{
 switch (Msg)
 {
  case WM_INITDIALOG:
  {
	int i,iMin,uPercent[3];
	DWORD dwFS,dwWinVer=GetVersion(),dwWinFlg=GetWinFlags();
	CenterDialog(hDlg);
	strcpy(cTxtBuff,"8086");
	if (dwWinFlg & WF_CPU286) strcpy(cTxtBuff,"80286");
	if (dwWinFlg & WF_CPU386) strcpy(cTxtBuff,"80386");
	if (dwWinFlg & WF_CPU486) strcpy(cTxtBuff,"80486");
	SetDlgItemText(hDlg,300,cTxtBuff);
	strcpy(cTxtBuff,(dwWinFlg & WF_80x87) ? "Present":"Not present");
	SetDlgItemText(hDlg,301,cTxtBuff);
	strcpy(cTxtBuff,"Real");
	if (dwWinFlg & WF_WIN286) strcpy(cTxtBuff,"Standard");
	if (dwWinFlg & WF_WIN386) strcpy(cTxtBuff,"Enhanced");
	SetDlgItemText(hDlg,302,cTxtBuff);
	dwFS=GetFreeSpace(LOWORD(dwFS));
	wsprintf(cTxtBuff,"%li bytes",dwFS);
	SetDlgItemText(hDlg,303,cTxtBuff);
	for(i=0;i<3;i++) uPercent[i]=GetFreeSystemResources(uResource[i]);
	iMin=0;for(i=1;i<3;i++) iMin=uPercent[i]<uPercent[iMin] ? i : iMin;
	wsprintf(cTxtBuff,pcResource[iMin],uPercent[iMin]);
	SetDlgItemText(hDlg,304,cTxtBuff);
	PrintVersion(hDlg,200,LOBYTE(LOWORD(dwWinVer)),HIBYTE(LOWORD(dwWinVer)));
	PrintVersion(hDlg,201,HIBYTE(HIWORD(dwWinVer)),LOBYTE(HIWORD(dwWinVer)));
	PrintVersion(hDlg,202,4,0);
	PrintVersion(hDlg,203,iVer,iRev);
	SetDlgItemText(hDlg,206,cDrvName);
	return TRUE;
  }
  case WM_COMMAND:
  {
	if (wParam==IDOK)
	{
	 EndDialog(hDlg,IDOK);
	 return TRUE;
	}
	break;
  }
 }
 return FALSE;
}

BOOL CALLBACK DlgSetupProc(HWND hDlg,UINT Msg,WPARAM wParam,LPARAM lParam)
{
#define IDABOUT        3
#define IDMODULELB   300
#define IDREMOVE     301
#define IDADD        302
#define IDMODULEED   303
#define IDDISABLECHK 201
#define IDBEEPCHK    304
#define IDSUBXCHK    404
 int i,iLBCnt,iLBSel;
 switch (Msg)
 {
  case WM_INITDIALOG:
  {
	hWndSetup=hDlg;
	CenterDialog(hDlg);
	SetDlgItemText(hDlg,100,(LPCSTR) &OFS.szPathName);
	SetDlgItemText(hDlg,400,(LPCSTR) cShellName);
	wsprintf(cTxtBuff,"%04X",hWndShell);
	SetDlgItemText(hDlg,401,(LPCSTR) cTxtBuff);
	CheckDlgButton(hDlg,IDBEEPCHK,bBeep ? 1 : 0);
	CheckDlgButton(hDlg,IDSUBXCHK,bSubX ? 1 : 0);
	CheckDlgButton(hDlg,IDDISABLECHK,bDisabled ? 1 : 0);
	SendDlgItemMessage(hDlg,IDMODULELB,LB_RESETCONTENT,0,0);
	for (i=0;i<=iLastOffTheHook;i++) SendDlgItemMessage(hDlg,IDMODULELB,LB_ADDSTRING,-1,(LPARAM) AnsiUpper(cModuleOffTheHook[i]));
	EnableWindow(GetDlgItem(hDlg,IDREMOVE),FALSE);
	EnableWindow(GetDlgItem(hDlg,IDADD),iLastOffTheHook<MAX_M);
	PostMessage(hWndSetup,WM_FILLLB,0,0);
	return TRUE;
  }
  case WM_FILLLB:
  {
	SendDlgItemMessage(hDlg,200,LB_RESETCONTENT,0,0);
	for(i=0;i<=MAX_Z3;i++) if (Z3List[i].hwndZ !=NULL) SendMessage(hDlg,WM_ADDLB,0,(LPARAM) &Z3List[i]);
	return TRUE;
  }
  case WM_ADDLB:
  {
	char cI[MAX_MODULE_NAME+1],cM[MAX_MODULE_NAME+1];
	struct Z3DENTRY *pNE;
	pNE=(struct Z3DENTRY far*) lParam;
	wvsprintf(cTxtBuff,"%04X   %04X  ",pNE);
	wsprintf(cI," %04X  ",pNE->TE.hInst);strcat(cTxtBuff,cI);
	wsprintf(cM,"   %04X   ",pNE->TE.hModule);strcat(cTxtBuff,cM);
	strcat(cTxtBuff,pNE->TE.szModule);
	SendDlgItemMessage(hDlg,200,LB_ADDSTRING,-1,(LPARAM) cTxtBuff);
	return TRUE;
  }
  case WM_COMMAND:
  {
	switch (wParam)
	{
	 case IDADD:
	 {
	  GetDlgItemText(hDlg,IDMODULEED,(LPSTR) cTxtBuff,MAX_MODULE_NAME+1);
	  if (cTxtBuff[0] !=0)
	  {
		if (SendDlgItemMessage(hDlg,IDMODULELB,LB_FINDSTRINGEXACT,-1,(LPARAM) &cTxtBuff)==LB_ERR)
		{
		 SendDlgItemMessage(hDlg,IDMODULELB,LB_ADDSTRING,-1,(LPARAM) AnsiUpper(cTxtBuff));
		 EnableWindow(GetDlgItem(hDlg,IDADD),SendDlgItemMessage(hDlg,IDMODULELB,LB_GETCOUNT,0,0)<MAX_M);
		}
	  }
	  return TRUE;
	 }
	 case IDREMOVE:
	 {
	  iLBSel=SendDlgItemMessage(hDlg,IDMODULELB,LB_GETCURSEL,0,0);
	  if (iLBSel>=0)
	  {
		SendDlgItemMessage(hDlg,IDMODULELB,LB_GETTEXT,iLBSel,(LPARAM) &cTxtBuff);
		SendDlgItemMessage(hDlg,IDMODULELB,LB_DELETESTRING,iLBSel,0);
		SetDlgItemText(hDlg,IDMODULEED,cTxtBuff);
		iLBCnt=SendDlgItemMessage(hDlg,IDMODULELB,LB_GETCOUNT,0,0);
		if (iLBCnt>0) SendDlgItemMessage(hDlg,IDMODULELB,LB_SETCURSEL,iLBSel==0 ? 0 : iLBSel-1,0);
		else
		{
		 SendDlgItemMessage(hDlg,IDMODULELB,LB_SETCURSEL,-1,0);
		 EnableWindow(GetDlgItem(hDlg,IDREMOVE),FALSE);
		}
		EnableWindow(GetDlgItem(hDlg,IDADD),TRUE);
	  }
	  return TRUE;
	 }
	 case IDOK:
	 {
	  cTxtBuff[0]=0;
	  iLastOffTheHook=SendDlgItemMessage(hDlg,IDMODULELB,LB_GETCOUNT,0,0)-1;
	  if (iLastOffTheHook<0) iLastOffTheHook=-1;
	  else
	  {
		for (i=0;i<=iLastOffTheHook;i++)
		{
		 SendDlgItemMessage(hDlg,IDMODULELB,LB_GETTEXT,i,(LPARAM) cModuleOffTheHook[i]);
		 strcat(cTxtBuff,cModuleOffTheHook[i]);strcat(cTxtBuff," ");
		}
	  }
	  WritePrivateProfileString(cDrvFile,"IncompatibleModules",cTxtBuff,"SYSTEM.INI");
	  WritePrivateProfileString(cDrvFile,"BeepWhenRejected",(bBeep=(IsDlgButtonChecked(hDlg,IDBEEPCHK)==1)) ? "Yes" : "No","SYSTEM.INI");
	  WritePrivateProfileString(cDrvFile,"SubclassExitProc",(bSubX=(IsDlgButtonChecked(hDlg,IDSUBXCHK)==1)) ? "Yes" : "No","SYSTEM.INI");
	  WritePrivateProfileString(cDrvFile,"Disabled",(bDisabled=(IsDlgButtonChecked(hDlg,IDDISABLECHK)==1)) ? "Yes" : "No","SYSTEM.INI");
	  hWndSetup=NULL;
	  EndDialog(hDlg,IDOK);
	  return TRUE;
	 }
	 case IDCANCEL:
	 {
	  hWndSetup=NULL;
	  EndDialog(hDlg,IDCANCEL);
	  return TRUE;
	 }
	 case IDABOUT:
	 {
	  DLGPROC DlgP;
	  DlgP=(DLGPROC) MakeProcInstance(DlgAboutProc,hIDrv);
	  DialogBox(hIDrv,"DLG_ABOUT",hDlg,DlgP);
	  FreeProcInstance((FARPROC) DlgP);
	 }
	 case IDMODULELB:if (HIWORD(lParam)==LBN_SELCHANGE) EnableWindow(GetDlgItem(hDlg,IDREMOVE),TRUE);
	}
  }  /* case WM_COMMAND */
 }
 return FALSE;
}

long far _export NewShellWndProc(HWND hW,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
 DLGPROC DlgP;
 int wReturnCode;
 HMENU hMenuOptions;
 BYTE pbKeyState[256];
 static BYTE abDimmer[]={0xcc,0xcc,0x33,0x33,0xcc,0xcc,0x33,0x33};
 HDC hDCDesktop;
 if ((uMsg==WM_CLOSE) && bSubX && !(GetKeyState(VK_SHIFT) & 0x8000)) /* Shift saves current settings */
 {
  DlgP=(DLGPROC) MakeProcInstance(DlgExitWinProc,hIDrv);
  wReturnCode=DialogBox(hIDrv,"DLG_EXITWIN",hW,DlgP);
  FreeProcInstance((FARPROC) DlgP);
  if (wReturnCode == IDCANCEL)
	return 0;                   /* Nothing happens */
  else
  {
	hDCDesktop=GetDC(NULL);
	SelectObject(hDCDesktop,CreatePatternBrush(CreateBitmap(8,8,1,1,abDimmer)));
	PatBlt(hDCDesktop,0,0,GetSystemMetrics(SM_CXSCREEN),GetSystemMetrics(SM_CYSCREEN),0x00a000c9L);
	if (strstr(cShellName,"PROGMAN.EXE"))  /* We know how to trick the Program Manager */
	{
	 if (hMenuOptions=GetSubMenu(GetMenu(hWndShell),1)) /* Options Menu handle */
	 {
	  if (GetMenuState(hMenuOptions,2,MF_BYPOSITION) & MF_CHECKED) /* Save settings on Exit Active? */
	  {
		GetKeyboardState((LPBYTE) &pbKeyState);
		pbKeyState[VK_SHIFT] |= 0x80;
		SetKeyboardState((LPBYTE) &pbKeyState);          /* Press the SHIFT key */
		CallWindowProc(OldShellWndProc,hW,WM_CLOSE,0,0); /* Just save settings  */
	  }
	 }
	}
	ExitWindows(wReturnCode,0); /* Exit Windows if all apps agree */
  }
 }
 return CallWindowProc(OldShellWndProc,hW,uMsg,wParam,lParam);
}

int far _export LibMain(HINSTANCE hILib,WORD wDataSeg,WORD cbHeapSize,LPSTR lpszCmdLine)
{
 int i;
 hIDrv=hILib;
 hICtl3D=NULL;
 hWndSetup=NULL;
 Hook=NULL;
 hWndShell=NULL;
 OldShellWndProc=NULL;
 for(i=0;i<=MAX_Z3;i++) Z3List[i].TE.dwSize=sizeof(TASKENTRY);
 for(i=0;i<=MAX_M ;i++) memset(cModuleOffTheHook[i],0,MAX_MODULE_NAME+1);
 return 1;
}

long far _export CBTProc(int iCode,WPARAM wParam,LPARAM lParam)
{
#define CTL3DREGISTER     12
#define CTL3DUNREGISTER   13
#define CTL3DAUTOSUBCLASS 16
 HTASK hTZ;
 int iFreeEntry,i;
 BOOL bNewTask,bOKToReg;
 BOOL (far *lpfn3DProc) (HINSTANCE hInst);
 if (iCode<0) return CallNextHookEx(Hook,iCode,wParam,lParam);
 else
 {
  switch (iCode)
  {
	case HCBT_CREATEWND:
	{
	 char cModuleName[MAX_MODULE_NAME+1];
	 hTZ=GetWindowTask(wParam);
	 iFreeEntry=-1;
	 bNewTask=TRUE;
	 for(i=0;(i<=MAX_Z3) && bNewTask;i++)
	 {
	  if ((Z3List[i].hwndZ==NULL) && (iFreeEntry==-1)) iFreeEntry=i;
	  if (Z3List[i].htaskZ==hTZ) bNewTask=FALSE;
	 }
	 if (bNewTask && (iFreeEntry>-1))
	 {
	  hICtl3D=LoadLibrary(OFS.szPathName);
	  if (hICtl3D>HINSTANCE_ERROR)
	  {
		Z3List[iFreeEntry].hlibZ =hICtl3D;
		Z3List[iFreeEntry].hwndZ =(HWND) wParam;
		Z3List[iFreeEntry].htaskZ=hTZ;
		if (TaskFindHandle(&Z3List[iFreeEntry].TE,hTZ))
		{
		 strcpy(cModuleName,Z3List[iFreeEntry].TE.szModule);
		 if (!hWndShell)                          /* If Shell not found yet */
		 {
		  if (strstr(cShellName,cModuleName)) hWndShell=(HWND) wParam; /* If found, save its handle  */
		 }
		 bOKToReg=!bDisabled;                     /* No action if bOKToReg=FALSE  */
		 for (i=0;(i<=iLastOffTheHook) && bOKToReg;i++) bOKToReg=!(stricmp(cModuleOffTheHook[i],cModuleName) == 0);
		 if (bOKToReg)
		 {
		  SetProp((HWND) wParam,"Z3DC",(HANDLE) iFreeEntry+1);
		  (FARPROC) lpfn3DProc=GetProcAddress(Z3List[iFreeEntry].hlibZ,(LPCSTR) MAKELONG(CTL3DREGISTER,0));
		  (*lpfn3DProc)(Z3List[iFreeEntry].TE.hInst);
		  (FARPROC) lpfn3DProc=GetProcAddress(Z3List[iFreeEntry].hlibZ,(LPCSTR) MAKELONG(CTL3DAUTOSUBCLASS,0));
		  (*lpfn3DProc)(Z3List[iFreeEntry].TE.hInst);
		  if (hWndSetup) PostMessage(hWndSetup,WM_ADDLB,0,(LPARAM) &Z3List[iFreeEntry]);
		 }
		 else
		 {
		  Z3List[iFreeEntry].hwndZ=NULL;
		  if (bBeep) MessageBeep(MB_ICONEXCLAMATION);
		 }
		}
	  }
	 };
	 return 0;
	}
	case HCBT_ACTIVATE:
	{
	 if ((hWndShell==(HWND) wParam) && !OldShellWndProc)
	 {
	  OldShellWndProc=(FARPROC) GetWindowLong(hWndShell,GWL_WNDPROC); /* Subclass it! */
	  SetWindowLong(hWndShell,GWL_WNDPROC,(LPARAM) NewShellWndProc);
	 }
	 return 0;
	}
	case HCBT_DESTROYWND:
	{
	 i=GetProp((HWND) wParam,"Z3DC")-1;
	 if (i>=0)
	 {
	  (FARPROC) lpfn3DProc=GetProcAddress(Z3List[i].hlibZ,(LPCSTR) MAKELONG(CTL3DUNREGISTER,0));
	  (*lpfn3DProc)(Z3List[i].TE.hInst);
	  Z3List[i].hwndZ=NULL;
	  RemoveProp((HWND) wParam,"Z3DC");
	  FreeLibrary(Z3List[i].hlibZ);
	  if (hWndSetup) PostMessage(hWndSetup,WM_FILLLB,0,0);
	 }
	 return 0;
	}
  }
 }
 return 0;
}

long far _export DriverProc(DWORD dwDrvID,HDRVR hDrv,UINT wMsg,LPARAM lParam1,LPARAM lParam2)
{
 DWORD dwRes=0;
 int i,j;
 char cC,cP;
 switch(wMsg)
 {
  case DRV_LOAD:
  {
	b3DV1=FALSE;b3DV2=FALSE;
	if (OpenFile("CTL3DV2.DLL",&OFS,OF_EXIST)>=0) b3DV2=TRUE;
	else
	{
	 if (OpenFile("CTL3D.DLL",&OFS,OF_EXIST)>=0) b3DV1=TRUE;
	}
	if (b3DV1 | b3DV2) dwRes=1L;
	else
	{
	 MessageBox(NULL,"CTL3DV2.DLL or CTL3D.DLL not found.\n           Cannot Load.",cDrvName,MB_OK | MB_ICONSTOP);
	 dwRes=0L;
	}
	break;
  }
  case DRV_FREE:
  {
	dwRes=1L;        /* Ignored */
	break;
  }
  case DRV_OPEN:
  {
	GetPrivateProfileString(cDrvFile,"IncompatibleModules","EQNEDIT WINWORD ZTM",cTxtBuff,MAX_BUFF,"SYSTEM.INI");
	iLastOffTheHook=-1;
	cP=' ';i=0;
	while ((i<MAX_BUFF) && (iLastOffTheHook<=MAX_M))
	{
	 cC=cTxtBuff[i];
	 if (cC==0) i=1024;
	 else
	 {
	  if (cC !=' ')
	  {
		if (cP==' ')
		{
		 iLastOffTheHook++;
		 j=0;
		}
		cModuleOffTheHook[iLastOffTheHook][j]=cC;
		j++;
	  }
	  cP=cC;i++;
	 }
	}
	GetPrivateProfileString(cDrvFile,"BeepWhenRejected","Yes",cTxtBuff,MAX_BUFF,"SYSTEM.INI");
	bBeep=(strstr(cTxtBuff,"Yes") != NULL);
	dwRes=1L;        /* This will be dwDrvID in subsequent calls */
	break;
  }
  case DRV_CLOSE:
  {
	if (hWndSetup) SendMessage(hWndSetup,WM_CLOSE,0,0);
	dwRes=1L;
	break;
  }
  case DRV_ENABLE:   /* Hook here */
  {
	GetPrivateProfileString(cDrvFile,"SubclassExitProc","Yes",cTxtBuff,MAX_BUFF,"SYSTEM.INI");
	bSubX=(strstr(cTxtBuff,"Yes") != NULL);
	GetPrivateProfileString(cDrvFile,"Disabled","No",cTxtBuff,MAX_BUFF,"SYSTEM.INI");
	bDisabled=(strstr(cTxtBuff,"Yes") != NULL);
	GetPrivateProfileString("boot","shell","progman.exe",cShellName,128,"SYSTEM.INI");
	AnsiUpper((LPSTR) cShellName);
	if (FindWindow(NULL,"Add Unlisted or Updated Driver") !=NULL) dwRes=1L;
	else
	{
	 for(i=0;i<=MAX_Z3;i++) Z3List[i].hwndZ=NULL;
	 Hook=SetWindowsHookEx(WH_CBT,(HOOKPROC) CBTProc,hIDrv,(HTASK) NULL);
	 if (Hook) dwRes=1L;
	 else
	 {
	  MessageBox(NULL,"Cannot Hook - Not Enabled.",cDrvName,MB_OK | MB_ICONSTOP);
	  dwRes=0L;
	 }
	}
	break;
  }
  case DRV_DISABLE:  /* Unhook here */
  {
	if (Hook) UnhookWindowsHookEx(Hook);
	Hook=NULL;
	dwRes=1L;
	break;
  }
  case DRV_INSTALL:
  {
	GetPrivateProfileString("boot","drivers"," ",cTxtBuff,MAX_BUFF,"SYSTEM.INI");
	if (strstr(cTxtBuff,cDrvFile)==NULL)
	{
	 strcat(cTxtBuff," ");
	 strcat(cTxtBuff,cDrvFile);
	 WritePrivateProfileString("boot","drivers",cTxtBuff,"SYSTEM.INI");
	 MessageBox(NULL,"           SYSTEM.INI updated.\nRestart Windows to activate the driver.",cDrvName,MB_OK | MB_ICONEXCLAMATION);
	}
	else MessageBox(NULL,"   Already present in\nSYSTEM.INI [boot] section.",cDrvName,MB_OK | MB_ICONEXCLAMATION);
	dwRes=DRV_OK;
	break;
  }
  case DRV_REMOVE:
  {
	char *pcPos;
	WritePrivateProfileString(cDrvFile,NULL,NULL,"SYSTEM.INI"); /* Remove the [z3dc.drv] section */
	GetPrivateProfileString("boot","drivers"," ",cTxtBuff,MAX_BUFF,"SYSTEM.INI");
	pcPos=strstr(cTxtBuff,cDrvFile);
	if (pcPos)
	{
	 strnset(pcPos,' ',8);
	 WritePrivateProfileString("boot","drivers",cTxtBuff,"SYSTEM.INI");
	}
	dwRes=1;                /* Ignored */
	break;
  }
  case DRV_QUERYCONFIGURE: /* Is there a configuration? */
  {
	dwRes=1L;               /* Yes! */
	break;
  }
  case DRV_CONFIGURE:
  {
	DLGPROC DlgP;
	DlgP=(DLGPROC) MakeProcInstance(DlgSetupProc,hIDrv);
	DialogBox(hIDrv,"DLG_SETUP",FindWindow(NULL,"Drivers"),DlgP);
	FreeProcInstance((FARPROC) DlgP);
	dwRes=DRV_OK;
	break;
  }
  default:return DefDriverProc(dwDrvID,hDrv,wMsg,lParam1,lParam2);
 }
 return dwRes;
}

