program Joy_ctrl;

uses   Winapi
     , WinTypes
     , WinProcs
     , OWindows
     , ODialogs
     , MMSystem
     , Validate
     , Strings
     , Ctl3D
     ;

{$R Joy_ctrl.res}

const

{ Resource IDs }

  id_Dialog = 10;
  id_Menu = 20;
  idd_x = 101;
  idd_y = 102;

{ Menu item IDs }

  idm_output_none = 201;
  idm_start = 300;
  idm_stop = 400;
  idm_setting = 500;

  idm_set_res = 501;
  idm_set_xmov = 510;
  idm_set_ymov = 511;
  idm_set_abut = 520;
  idm_set_bbut = 521;
  idm_joypanel = 599;
  { submenu positions }
  mpos_output = 0;

TYPE
   TMovMesg = object
      bStatus, bChannel, bData1 : Byte;
      fReverse : boolean;
      function GetMidiMsg(jpos:WORD):LongInt;
   end;

   TButtMesg = object
      bStatus, bChannel, bData1 : Byte;
      iLow, iHigh : integer;
      function GetMidiMsg(bpos:WORD):LongInt;
   end;

   TMidiMsg = record
     case integer of
     0: (msg_db : array [0..3] of Byte );
     1: (msg_dw : LongInt);
   end;

{ TJoyCtrl is the main window of the application }

  PJoyCtrl = ^TJoyCtrl;
  TJoyCtrl = object(TDlgWindow)

    wOutputNums : integer;
    wCurOutput  : integer;
    hmod : HMIDI;

    psx : PStatic;
    psy : PStatic;

    fStarted : Boolean;

    jsThr : WORD;
    jsPeriod : WORD;

    xmidmsg, ymidmsg : TMovMesg;
    lastXmsg,lastYmsg : LongInt;
    amidmsg, bmidmsg : TButtMesg;

    constructor Init;
    destructor done; virtual;
    procedure SetupWindow; virtual;
    function GetClassName: PChar; virtual;
    procedure GetWindowClass(var AWndClass: TWndClass); virtual;

    procedure SetupOutputs;
    procedure SetOutput(newCurOutput:integer);

    procedure OpenOutput;
    procedure CloseOutput;

    procedure wmCommand(var Msg:TMessage); virtual wm_first+wm_command;

    procedure wmJoy1ButtonDown(var Msg:TMessage); virtual wm_first + MM_JOY1BUTTONDOWN;
    procedure wmJoy1ButtonUp  (var Msg:TMessage); virtual wm_first + MM_JOY1BUTTONUP;
    procedure wmJoy1Move      (var Msg:TMessage); virtual wm_first + MM_JOY1MOVE;

    procedure cmStart(var Msg:TMessage); virtual cm_first + idm_start;
    procedure cmStop(var Msg:TMessage); virtual cm_first + idm_stop;

    procedure cmRes(var Msg:TMessage); virtual cm_first + idm_set_res;
    procedure cmXMov(var Msg:TMessage); virtual cm_first + idm_set_xmov;
    procedure cmYMov(var Msg:TMessage); virtual cm_first + idm_set_ymov;
    procedure cmABut(var Msg:TMessage); virtual cm_first + idm_set_abut;
    procedure cmBBut(var Msg:TMessage); virtual cm_first + idm_set_bbut;
    procedure cmJoyPanel(var Msg:TMessage); virtual cm_first + idm_joypanel;

    procedure MovDlg(var midmsg: TMovMesg;ATitle:PChar);
    procedure ButtDlg(var midmsg: TButtMesg;ATitle:PChar);

    procedure InitProfile;
    procedure WriteProfile;
  end;

{ TJoyCtrlApp is the application object. It creates a main window of
  type TJoyCtrl. }

  TJoyCtrlApp = object(TApplication)
    procedure InitMainWindow; virtual;
  end;


function TMovMesg.GetMidiMsg(jpos:WORD):LongInt;
var msg : TMidiMsg;
begin
   msg.msg_dw := 0;
   msg.msg_db[0] := bStatus or bChannel;
   if fReverse then jpos := not jpos;
   if bStatus < $C0 then
    begin
       msg.msg_db[1] := bData1 and $7F;
       jpos := jpos shr 9;
       msg.msg_db[2] := jpos and $7F;
    end
   else
    if bStatus < $E0 then { Pgm or Aftertouch }
     begin
       jpos := jpos shr 9;
       msg.msg_db[1] := jpos and $7F;
     end
    else { Pitch Bend }
     begin
       jpos := jpos shr 2;
       msg.msg_db[1] := jpos and $7F;
       jpos := jpos shr 7;
       msg.msg_db[2] := jpos and $7F;
     end;

   GetMidiMsg := msg.msg_dw;
end;

function TButtMesg.GetMidiMsg(bpos:WORD):LongInt;
var msg : TMidiMsg;
    iData2 : integer;
begin
   msg.msg_dw := 0;
   if bpos=0 then iData2:=iHigh else iData2:=iLow ;
   msg.msg_db[0] := bStatus or bChannel;
   if bStatus < $C0 then
    begin
       msg.msg_db[1] := bData1 and $7F;
       msg.msg_db[2] := iData2 and $7F;
    end
   else
    if bStatus < $E0 then { Pgm or Aftertouch }
       msg.msg_db[1] := iData2 and $7F
    else { Pitch Bend }
     begin
       msg.msg_db[1] := iData2 and $7F;
       msg.msg_db[2] := (iData2 shr 7) and $7F;
     end;

   GetMidiMsg := msg.msg_dw;
end;

{ TJoyCtrl }

{ Convert dialog constructor. }

constructor TJoyCtrl.Init;
begin
  TDlgWindow.Init(nil, PChar(id_Dialog));
  wOutputNums := 0;
  wCurOutput := 0;
  hmod := 0;
  psx := New(PStatic,InitResource(@self,idd_x,10));
  psy := New(PStatic,InitResource(@self,idd_y,10));
  fStarted := false;
  jsThr := 0;
  jsPeriod := 50;
  FillChar(xmidmsg,sizeof(xmidmsg),0);
  FillChar(ymidmsg,sizeof(ymidmsg),0);
  FillChar(amidmsg,sizeof(amidmsg),0);
  FillChar(bmidmsg,sizeof(bmidmsg),0);
  LastXMsg := 0;
  LastYMsg := 0;
end;

destructor TJoyCtrl.Done;
var i:integer;
begin
  if fstarted then JoyReleaseCapture(JOYSTICKID1);
  CloseOutput;
  WriteProfile;
  TDlgWindow.Done;
end;
{ SetupWindow is called right after the Convert dialog is created. }

procedure TJoyCtrl.SetupWindow;
var i:integer;
    mh : THandle;
begin
   inherited SetupWindow;
   InitProfile;
   SetupOutputs;
   SetOutput(0);
end;


{ add available Midi Outputs to Output Menu }
procedure TJoyCtrl.SetupOutputs;
VAR mc : TMIDIOUTCAPS;
    i: integer;
    h_pmenu : HMENU;
begin
   h_pmenu := GetSubMenu(GetMenu(hWindow),mpos_output);
   wOutputNums := midiOutGetNumDevs + 1;
   for i:=-1 to wOutputNums-2 do { start with MIDI_MAPPER }
   begin
      midiOutGetDevCaps(i,@mc,sizeof(mc));
      if (h_pmenu<>0) then
         AppendMenu(h_pmenu,MF_STRING,idm_output_none+2+i,mc.szPName);
   end;
end;

{ Check Midi Output Menu }
procedure TJoyCtrl.SetOutput(newCurOutput:integer);
VAR
    i: integer;
    h_pmenu : HMENU;
begin
   h_pmenu := GetSubMenu(GetMenu(hWindow),mpos_output);
   if newCurOutput>wOutputNums then newCurOutput:=0;
   wCurOutput := newCurOutput;
   for i:=0 to wOutputNums  do begin
       if h_pmenu<>0 then
          if i=wCurOutput then
             CheckMenuItem(h_pmenu,idm_output_none+i,MF_BYCOMMAND or MF_CHECKED)
          else
             CheckMenuItem(h_pmenu,idm_output_none+i,MF_BYCOMMAND or MF_UNCHECKED);
   end;

end;

procedure modErr(HWindow:HWnd; err:WORD; caption:PChar);
var errbuf : array [0..255] of char;
begin
   if midiOutGetErrorText(err,errbuf,sizeof(errbuf)-1)<>0 then begin
      wvsprintf(errbuf,'Unknown Error %04Xh',err);

   end;
   if caption=nil then caption:='Midi Output Error';
   MessageBox(HWindow,errbuf,caption,MB_ICONSTOP or MB_OK);
end;

{ Open Midi Output }
procedure TJoyCtrl.OpenOutput;
VAR err : WORD;
begin
   if hmod<>0 then CloseOutput;
   if wCurOutput >= 1 then begin

   err := midiOutOpen(@hmod,wCurOutput-2,0,0,0);
   if err<>0 then modErr(hWindow,err,'midiOutOpen');
   end;
end;

{ Close Midi Output }
procedure TJoyCtrl.CloseOutput;
VAR
    i: integer;
    err : WORD;
begin
   if hmod <> 0 then begin
      err := midiOutReset(hmod);
      if err<>0 then modErr(hWindow,err,'midiOutReset');
      err := midiOutClose(hmod);
      if err<>0 then modErr(hWindow,err,'midiOutClose');
      hmod := 0;
  end;
end;

{ Return window class name. This name correspons to the class name
  specified for the Convert dialog in the resource file. }

function TJoyCtrl.GetClassName: PChar;
begin
  GetClassName := 'JoyCtrlDlg';
end;

procedure TJoyCtrl.GetWindowClass(var AWndClass: TWndClass);
begin
    inherited GetWindowClass(AWndClass);
    AWndClass.hicon := LoadIcon(hInstance,'ICON_1');
end;

{$IFDEF DEBUG}
var dbgbuf: array [0..63] of char;
{$ENDIF}
procedure TJoyCtrl.wmJoy1ButtonDown(var Msg:TMessage);
begin
{$IFDEF DEBUG}
   wvsprintf(dbgbuf,'J1DN %04X %04X %08lX'#13#10,Msg.Message);
   OutputDebugString(dbgbuf);
{$ENDIF}
   if hmod<>0 then begin
      if (Msg.wParam and JOY_BUTTON1CHG)<>0 then
         if amidmsg.bStatus<>0 then
             midiOutShortMsg(hmod,amidmsg.GetMidiMsg(0));
      if (Msg.wParam and JOY_BUTTON2CHG)<>0 then
         if bmidmsg.bStatus<>0 then
             midiOutShortMsg(hmod,bmidmsg.GetMidiMsg(0));
      end;
   Msg.Result := 0;
end;

procedure TJoyCtrl.wmJoy1ButtonUp  (var Msg:TMessage);
begin
{$IFDEF DEBUG}
   wvsprintf(dbgbuf,'J1UP %04X %04X %08lX'#13#10,Msg.Message);
   OutputDebugString(dbgbuf);
{$ENDIF}
   if hmod<>0 then begin
      if (Msg.wParam and JOY_BUTTON1CHG)<>0 then
         if amidmsg.bStatus<>0 then
             midiOutShortMsg(hmod,amidmsg.GetMidiMsg(1));
      if (Msg.wParam and JOY_BUTTON2CHG)<>0 then
         if bmidmsg.bStatus<>0 then
             midiOutShortMsg(hmod,bmidmsg.GetMidiMsg(1));
      end;
   Msg.Result := 0;
end;

procedure TJoyCtrl.wmJoy1Move      (var Msg:TMessage);
var tbuf : array[0..7] of char;
    vpar: Word;
    m : Longint;

    Function MidMsgString(mmsg:LongInt):PChar;
    begin
       if ((mmsg and $F0) < $C0) then
          vpar := LoByte(HiWord(mmsg))
       else if ((mmsg and $F0) < $E0) then
          vpar := HiByte(LoWord(mmsg))
       else
          vpar := 128*(LoByte(Hiword(mmsg))-64) + HiByte(LoWord(mmsg));
      wvsprintf(tbuf,'%3d',vpar);
      MidMsgString:=tbuf;
    end;
begin
{$IFDEF DEBUG}
   wvsprintf(dbgbuf,'J1MV %04X %04X %08lX'#13#10,Msg.Message);
   OutputDebugString(dbgbuf);
{$ENDIF}
(*
   wvsprintf(tbuf,'X %5u',Msg.LParamLo);
   psx^.SetText(tbuf);
   wvsprintf(tbuf,'Y %5u',Msg.LParamHi);
   psy^.SetText(tbuf);
*)
   if hmod<>0 then begin
      if xmidmsg.bStatus<>0 then begin
         m := xmidmsg.GetMidiMsg(Msg.LParamLo);
         if m<>LastXMsg then begin
            midiOutShortMsg(hmod,m);
            LastXMsg := m;
            psx^.SetText(MidMsgString(m));
         end;
      end;
      if ymidmsg.bStatus<>0 then begin
         m := ymidmsg.GetMidiMsg(Msg.LParamHi);
         if m<>LastYMsg then begin
            midiOutShortMsg(hmod,m);
            LastYMsg := m;
            psy^.SetText(MidMsgString(m));
         end;
      end;
   end;

   Msg.Result := 0;
end;

{ dispatch Midi Output Menu Commands }
procedure TJoyCtrl.wmCommand(var Msg:TMessage);
var i:integer;
BEGIN
   if (Msg.LParam = 0) then begin { a menu command }
      i := Msg.WParam - idm_output_none;
      if ( i >= 0) and ( i <= wOutputNums ) then begin
         SetOutput(i);
         OpenOutput;
         Msg.Result := 0;
         exit;
      end;
   end;
   inherited wmCommand(Msg);
END;

procedure TJoyCtrl.cmStart(var Msg:TMessage);
var hm : HMenu;
begin
   if not fStarted then begin
      fStarted := JoySetCapture(hWindow,JOYSTICKID1,jsPeriod,true)=0;
      joySetThreshold(JOYSTICKID1,jsThr);
      end;
   if fStarted then begin
      hm := GetMenu(hWindow);
      EnableMenuItem(hm,idm_stop,MF_BYCOMMAND or MF_ENABLED);
      EnableMenuItem(hm,idm_start,MF_BYCOMMAND or MF_GRAYED );
      SetMenu(hWindow,hm);
   end;
   Msg.Result := 1;
end;

procedure TJoyCtrl.cmStop(var Msg:TMessage);
var hm : HMenu;
begin
   if fStarted then begin
      JoyReleaseCapture(JOYSTICKID1);
      hm := GetMenu(hWindow);
      EnableMenuItem(hm,idm_stop,MF_BYCOMMAND or MF_GRAYED );
      EnableMenuItem(hm,idm_start,MF_BYCOMMAND or MF_ENABLED);
      SetMenu(hWindow,hm);
   end;
   fStarted := false;

   Msg.Result := 1;
end;

procedure TJoyCtrl.cmRes(var Msg:TMessage);
var D : PDialog;
    E : PEdit;
    jc : TJOYCAPS;
    trans_buf : record
       e_thres : array [0..7] of char;
       e_res : array [0..7] of char;
    end;
    r:integer;
begin
   if joyGetDevCaps(JOYSTICKID1,@jc,sizeof(jc))<>0 then exit;
   D := New(PDialog, Init(@Self, 'JOYRES'));
   E := New(PEdit, InitResource(D,102,sizeof(trans_buf.e_thres)));
   E^.SetValidator( New(PRangeValidator,Init(0,65535)));
   wvsprintf(trans_buf.e_thres,'%u',jsThr);
   E := New(PEdit, InitResource(D,104,sizeof(trans_buf.e_res)));
   E^.SetValidator( New(PRangeValidator,Init(jc.wPeriodMin,jc.WPeriodMax)));
   wvsprintf(trans_buf.e_res,'%u',jsPeriod);
   D^.TransferBuffer := @trans_buf;
   if Application^.ExecDialog(D)=IDOK then
   begin
      Val(trans_buf.e_thres,jsThr,r);
      Val(trans_buf.e_res,jsPeriod,r);
      if fStarted then begin
         {joyReleaseCapture(JOYSTICKID1);
         joySetCapture(JOYSTICKID1,hWindow,jsPeriod,true);
         joySetThreshold(JOYSTICKID1,jsThr);
         }
         cmStop(Msg);
         cmStart(Msg);
      end;
   end;
end;

procedure TJoyCtrl.cmXMov(var Msg:TMessage);
begin
   MovDlg(xmidmsg,'X Axis');
end;
procedure TJoyCtrl.cmYMov(var Msg:TMessage);
begin
   MovDlg(ymidmsg,'Y Axis');
end;
procedure TJoyCtrl.cmABut(var Msg:TMessage);
begin
   ButtDlg(amidmsg,'A Button');
end;
procedure TJoyCtrl.cmBBut(var Msg:TMessage);
begin
   ButtDlg(bmidmsg,'B Button');
end;

procedure TJoyCtrl.cmJoyPanel(var Msg:TMessage);
begin
   WinExec('control joystick.cpl',SW_SHOW);
end;

procedure TJoyCtrl.MovDlg(var midmsg: TMovMesg; ATitle : PChar);
const StatBytes : array[0..6] of byte = (0,$90,$A0,$B0,$C0,$D0,$E0);
var D : PDialog;
    E : PEdit;
    P : Pointer;
    S : PStatic;
    trans : record
       e_chn : array[0..5] of char;
       e_d1 : array[0..5] of char;
       r_rev : Wordbool;
       r_ev : array[0..6] of Wordbool;
       s_titl : array [0..9] of char;
    end;
    i,r : integer;
begin
   D := New (PDialog,Init(@self,'MOVMSG'));
   E := New(PEdit,InitResource(D,141,sizeof(trans.e_chn)));
   E^.SetValidator( New(PRangeValidator,Init(1,16)));
   i:=midmsg.bChannel + 1;
   wvsprintf(trans.e_chn,'%d',i);
   E := New(PEdit,InitResource(D,111,sizeof(trans.e_d1)));
   E^.SetValidator( New(PRangeValidator,Init(0,127)));
   i:=midmsg.bData1;
   wvsprintf(trans.e_d1,'%d',i);
   P:=New(PCheckBox,InitResource(D,121));
   trans.r_rev := midmsg.fReverse;
   for i:=0 to 6 do begin
       trans.r_ev[i] := (midmsg.bStatus = StatBytes[i]);
       P:=New(PRadioButton,InitResource(D,101+i));
   end;

   StrLCopy(trans.s_titl,ATitle,sizeof(trans.s_titl));
   S := New(PStatic, InitResource(D,160,sizeof(trans.s_titl)));

   D^.TransferBuffer := @trans;
   if Application^.ExecDialog(D)=IDOK then begin
      Val(trans.e_chn,i,r);
      midmsg.bChannel := i-1;
      Val(trans.e_d1,i,r);
      midmsg.bData1 := i;
      midmsg.fReverse := trans.r_rev;
      for i:=0 to 6 do begin
          if trans.r_ev[i] then midmsg.bStatus := StatBytes[i];
      end;
   end;
end;

procedure TJoyCtrl.ButtDlg(var midmsg: TButtMesg;ATitle:PChar);
const StatBytes : array[0..6] of byte = (0,$90,$A0,$B0,$C0,$D0,$E0);
var D : PDialog;
    E : PEdit;
    P : Pointer;
    S : PStatic;
    trans : record
       e_chn : array[0..5] of char;
       e_d1 : array[0..5] of char;
       e_up : array[0..7] of char;
       e_dn : array[0..7] of char;
       r_ev : array[0..6] of Wordbool;
       s_titl : array [0..9] of char;
    end;
    i,r : integer;
begin
   D := New (PDialog,Init(@self,'BUTMSG'));
   E := New(PEdit,InitResource(D,141,sizeof(trans.e_chn)));
   E^.SetValidator( New(PRangeValidator,Init(1,16)));
   i:=midmsg.bChannel + 1;
   wvsprintf(trans.e_chn,'%d',i);
   E := New(PEdit,InitResource(D,111,sizeof(trans.e_d1)));
   E^.SetValidator( New(PRangeValidator,Init(0,127)));
   i:=midmsg.bData1;
   wvsprintf(trans.e_d1,'%d',i);
   E := New(PEdit,InitResource(D,121,sizeof(trans.e_up)));
   E^.SetValidator( New(PRangeValidator,Init(-8192,8191)));
   wvsprintf(trans.e_up,'%d',midmsg.ihigh);
   E := New(PEdit,InitResource(D,122,sizeof(trans.e_dn)));
   E^.SetValidator( New(PRangeValidator,Init(-8192,8191)));
   wvsprintf(trans.e_dn,'%d',midmsg.ilow);
   for i:=0 to 6 do begin
       trans.r_ev[i] := (midmsg.bStatus = StatBytes[i]);
       P:=New(PRadioButton,InitResource(D,101+i));
   end;

   StrLCopy(trans.s_titl,ATitle,sizeof(trans.s_titl));
   S := New(PStatic, InitResource(D,160,sizeof(trans.s_titl)));

   D^.TransferBuffer := @trans;
   if Application^.ExecDialog(D)=IDOK then begin
      Val(trans.e_chn,i,r);
      midmsg.bChannel := i-1;
      Val(trans.e_d1,i,r);
      midmsg.bData1 := i;
      Val(trans.e_up,midmsg.iHigh,r);
      Val(trans.e_dn,midmsg.iLow,r);
      for i:=0 to 6 do begin
          if trans.r_ev[i] then midmsg.bStatus := StatBytes[i];
      end;
   end;
end;

const AppName : PChar = 'MidiJoy';

      szRes : PChar = 'Resolution';
      szPeriod : PChar = 'Period';

      szXStatus : PChar = 'Xmsg';
      szXchn : PChar = 'XChn';
      szXData : PChar = 'XData';
      szXrev : PChar = 'Xrev';

      szYStatus : PChar = 'Ymsg';
      szYchn : PChar = 'YChn';
      szYData : PChar = 'YData';
      szYrev : PChar = 'Yrev';

      szAStatus : PChar = 'Amsg';
      szAchn : PChar = 'AChn';
      szAData : PChar = 'AData';
      szAup : PChar = 'Aup';
      szAdown : PChar = 'Adown';

      szBStatus : PChar = 'Bmsg';
      szBchn : PChar = 'BChn';
      szBData : PChar = 'BData';
      szBup : PChar = 'Bup';
      szBdown : PChar = 'Bdown';


procedure TJoyCtrl.InitProfile;
   function GetInt(key:PChar;def:integer):integer;
   begin
      GetInt:=Integer(GetProfileInt(AppName,key,def));
   end;
begin
   jsThr := GetInt(szRes,0);
   jsPeriod := GetInt(szPeriod,50);

   xmidmsg.bStatus:=GetInt(szXStatus,$B0);
   xmidmsg.bChannel:=GetInt(szXchn,1)-1;
   xmidmsg.bData1:=GetInt(szXData,1);
   xmidmsg.fReverse:=(GetInt(szXrev,0)=1);

   ymidmsg.bStatus:=GetInt(szYStatus,$E0);
   ymidmsg.bChannel:=GetInt(szYchn,1)-1;
   ymidmsg.bData1:=GetInt(szYData,0);
   ymidmsg.fReverse:=(GetInt(szYrev,1)=1);

   amidmsg.bStatus:=GetInt(szAStatus,$B0);
   amidmsg.bChannel:=GetInt(szAchn,1)-1;
   amidmsg.bData1:=GetInt(szAData,64);
   amidmsg.iLow := GetInt(szAup,0);
   amidmsg.iHigh:= GetInt(szAdown,127);

   bmidmsg.bStatus:=GetInt(szBStatus,$B0);
   bmidmsg.bChannel:=GetInt(szBchn,1)-1;
   bmidmsg.bData1:=GetInt(szBData,64);
   bmidmsg.iLow := GetInt(szBup,0);
   bmidmsg.iHigh:= GetInt(szBdown,127);

end;

procedure TJoyCtrl.WriteProfile;
   procedure WriteInt(key:PChar;value:integer);
   var buf:array [0..7] of char;
   begin
      wvsprintf(buf,'%d',value);
      WriteProfileString(AppName,key,buf);
   end;
   procedure WriteHex(key:PChar;value:integer);
   var buf:array [0..7] of char;
   begin
      wvsprintf(buf,'0x%x',value);
      WriteProfileString(AppName,key,buf);
   end;

begin
   WriteInt(szRes,jsThr);
   WriteInt(szPeriod,jsPeriod);

   WriteHex(szXStatus,xmidmsg.bStatus);
   WriteInt(szXchn,   xmidmsg.bChannel+1);
   WriteInt(szXData,  xmidmsg.bData1);
   WriteInt(szXrev,   integer(xmidmsg.fReverse));

   WriteHex(szYStatus,ymidmsg.bStatus);
   WriteInt(szYchn,   ymidmsg.bChannel+1);
   WriteInt(szYData,  ymidmsg.bData1);
   WriteInt(szYrev,   integer(ymidmsg.fReverse));

   WriteHex(szAStatus,amidmsg.bStatus);
   WriteInt(szAchn,   amidmsg.bChannel+1);
   WriteInt(szAData,  amidmsg.bData1);
   WriteInt(szAup,    amidmsg.iLow);
   WriteInt(szAdown,  amidmsg.iHigh);

   WriteHex(szBStatus,bmidmsg.bStatus);
   WriteInt(szBchn,   bmidmsg.bChannel+1);
   WriteInt(szBData,  bmidmsg.bData1);
   WriteInt(szBup,    bmidmsg.iLow);
   WriteInt(szBdown,  bmidmsg.iHigh);
end;
{ TJoyCtrlApp }

{ Create a Midimon dialog as the application's main window. }

procedure TJoyCtrlApp.InitMainWindow;
begin
  MainWindow := New(PJoyCtrl, Init);
end;

var
  JoyCtrlApp: TJoyCtrlApp;

begin
   Ctl3dRegister(HInstance);
   Ctl3dAutoSubclass(HInstance);

  JoyCtrlApp.Init('JoyCtrlApp');
  JoyCtrlApp.Run;
  JoyCtrlApp.Done;

   Ctl3dUnregister(HInstance);
end.
