//-- implementation code
// core code filename params.cpp
//----------------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "nndefs.h"
#include "params.h"

	void Logit(const char* fmt, ...);

PARAMS *CreateParams( )
{
	PARAMS *pM;
	pM = (PARAMS *) malloc (sizeof(PARAMS));

	pM->m_TrainFlags=0;
	pM->m_AImaxhid=4;
	pM->m_goodness=3;
	pM->m_autosave = 1000;
	pM->m_seed = 15;
	pM->m_eon = 100;

	pM->m_cnt_max = 1000;

	pM->m_hiddegrad=0.75f;
	pM->m_errtol = 0.001f;
	pM->m_goodrsq = .9f;
	pM->m_signinc = .05f;
	pM->m_nosigninc = .005f;
	pM->m_alpha = .8f;
	pM->m_theta = .5f;
	pM->m_randz = .5f;
	pM->m_inrandzdiv = 0.f;
	pM->m_tol = .05f;
	pM->m_learning_rate = .75f;
	pM->m_Hlearning_rate = 1.5f;
	pM->m_tlearning_rate = .75f;
	pM->m_inoutlearn = .1f;
                          
	return pM;                          	
}
/*
// CParams::CParams Copy Constructor 

CParams::CParams( const CParams& b )
{
    ASSERT_VALID( this );
    ASSERT_VALID( &b );
	m_TrainFlags= b.m_TrainFlags;
	m_AImaxhid = b.m_AImaxhid;
	m_goodness = b.m_goodness;
	m_autosave = b.m_autosave;
	m_seed = b.m_seed;
	m_eon = b.m_eon;

	m_cnt_max = b.m_cnt_max;

	m_hiddegrad = b.m_hiddegrad;
	m_errtol = b.m_errtol;
	m_goodrsq = b.m_goodrsq;
	m_signinc = b.m_signinc;
	m_nosigninc = b.m_nosigninc;
	m_alpha = b.m_alpha;
	m_theta = b.m_theta;
	m_randz = b.m_randz;
	m_inrandzdiv = b.m_inrandzdiv;
	m_tol = b.m_tol;
	m_learning_rate = b.m_learning_rate;
	m_Hlearning_rate = b.m_Hlearning_rate;
	m_tlearning_rate = b.m_tlearning_rate;
	m_inoutlearn = b.m_inoutlearn;

}

// Overloaded operator=

CParams& CParams::operator=( const CParams& b)
{
    ASSERT_VALID( this );
    ASSERT_VALID( &b );
	m_TrainFlags= b.m_TrainFlags;
	m_AImaxhid = b.m_AImaxhid;
	m_goodness = b.m_goodness;
	m_autosave = b.m_autosave;
	m_seed = b.m_seed;
	m_eon = b.m_eon;

	m_cnt_max = b.m_cnt_max;

	m_hiddegrad = b.m_hiddegrad;
	m_errtol = b.m_errtol;
	m_goodrsq = b.m_goodrsq;
	m_signinc = b.m_signinc;
	m_nosigninc = b.m_nosigninc;
	m_alpha = b.m_alpha;
	m_theta = b.m_theta;
	m_randz = b.m_randz;
	m_inrandzdiv = b.m_inrandzdiv;
	m_tol = b.m_tol;
	m_learning_rate = b.m_learning_rate;
	m_Hlearning_rate = b.m_Hlearning_rate;
	m_tlearning_rate = b.m_tlearning_rate;
	m_inoutlearn = b.m_inoutlearn;

	return *this;
}
void CParams::DumpParams(FILE *fd )
{
	static char BASED_CODE fmt1[] = 
"\nDump of Parameters\nTrainFlags = %d\nAImaxhid  = %d\
\ngoodness   = %d\nautosave   = %d\nseed       = %d\neonh      = %d\n";

    fprintf (fd,fmt1, m_TrainFlags, m_AImaxhid,  
    	m_goodness, m_autosave, m_seed, m_eon);

	static char BASED_CODE fmt2[] = 
"cnt_max        = %ld\nhiddegrad      = %10f\nerrtol         = %10f\
\ngoodrsq        = %10f\nsigninc        = %10f\nnosigninc      = %10f\
\nalpha          = %10f\n";

    fprintf (fd,fmt2,m_cnt_max,m_hiddegrad,m_errtol,m_goodrsq,m_signinc,
    	m_nosigninc,m_alpha);

	static char BASED_CODE fmt3[] = 
"theta          = %10f\nrandz          = %10f\ninrandzdiv     = %10f\
\ntol            = %10f\nlearning_rate  = %10f\nHlearning_rate = %10f\
\ntlearning_rate = %10f\nInOutLearn     = %10f\n";

    fprintf (fd,fmt3,m_theta,m_randz,m_inrandzdiv,m_tol,m_learning_rate,
    	m_Hlearning_rate,m_tlearning_rate,m_inoutlearn);
}
*/

int ImportParams (FILE *fd, PARAMS *pM)
{
	char cdummy[80];
	int ex;
	static char *fmt1 = {"%d %d %d %d %d %d"};
	static char *fmt2 = {"%ld %f %f %f %f %f %f"};
	static char *fmt3 = {"%f %f %f %f %f %f %f %f"};

#ifdef VERBOSE
	Logit("Start import params\n");
#endif
	
	fscanf (fd,"%s" , cdummy);
	if (strncmp("P00",cdummy,3)!=0) goto errorexit;
	fscanf (fd,"%d" , &ex);
	if (ex != EXPORTVERSION) {
#ifdef VERBOSE
		Logit("The ENN file is the wrong export version\n");
#endif
		return -1;
	}

	fscanf (fd,"%s" , cdummy);
	if (strncmp("P01",cdummy,3)!=0) goto errorexit;
	fscanf (fd,fmt1 , &pM->m_TrainFlags,
		&pM->m_AImaxhid, &pM->m_goodness, &pM->m_autosave, &pM->m_seed,
		&pM->m_eon);

	fscanf (fd,"%s" , cdummy);
	if (strncmp("P02",cdummy,3)!=0) goto errorexit;
	fscanf (fd,fmt2,&pM->m_cnt_max,
		&pM->m_hiddegrad, &pM->m_errtol, &pM->m_goodrsq, &pM->m_signinc, &pM->m_nosigninc,
		&pM->m_alpha);

	fscanf (fd,"%s" , cdummy);
	if (strncmp("P03",cdummy,3)!=0) goto errorexit;
	fscanf (fd,fmt3,&pM->m_theta,
		&pM->m_randz, &pM->m_inrandzdiv, &pM->m_tol, &pM->m_learning_rate,
		&pM->m_Hlearning_rate, &pM->m_tlearning_rate, &pM->m_inoutlearn);
	return 0;                                     

errorexit:        
	return -1;
	
}

void DumpParams(PARAMS *pM, FILE *fd )
{
	static char fmt1[] = 
"\nDump of Parameters\nTrainFlags = %d\nAImaxhid  = %d\
\ngoodness   = %d\nautosave   = %d\nseed       = %d\neonh      = %d\n";
	static char fmt2[] = 
"cnt_max        = %ld\nhiddegrad      = %10f\nerrtol         = %10f\
\ngoodrsq        = %10f\nsigninc        = %10f\nnosigninc      = %10f\
\nalpha          = %10f\n";
	static char fmt3[] = 
"theta          = %10f\nrandz          = %10f\ninrandzdiv     = %10f\
\ntol            = %10f\nlearning_rate  = %10f\nHlearning_rate = %10f\
\ntlearning_rate = %10f\nInOutLearn     = %10f\n";

    fprintf (fd,fmt1, pM->m_TrainFlags, pM->m_AImaxhid,  
    	pM->m_goodness, pM->m_autosave, pM->m_seed, pM->m_eon);

    fprintf (fd,fmt2,pM->m_cnt_max,pM->m_hiddegrad,pM->m_errtol,pM->m_goodrsq,pM->m_signinc,
    	pM->m_nosigninc,pM->m_alpha);

    fprintf (fd,fmt3,pM->m_theta,pM->m_randz,pM->m_inrandzdiv,pM->m_tol,pM->m_learning_rate,
    	pM->m_Hlearning_rate,pM->m_tlearning_rate,pM->m_inoutlearn);
}

