#ifndef _EXPDEF_H_
#define _EXPDEF_H_  90

/*
  2101941615 <- last update (yymmddhh'')
     _____________________________________________________________
    /                                                             \ 
    | Headerfile:   EXPANSION LIBRARY DEFINITIONS FILE
    \_____________________________________________________________/

    Description:    this contains basical definitions needed for
                    correct compilation under the target operating
                    system and compiler.

    Refers to:      explib.h - this should also be included

    Included by:    any source file of any program (part)

    NOTE:   mind these portability traps:

            -   every pointer pointing to data >64k must be
                declared with HUGE (defined below) if the could
                should also run with WIN16 (Windows 3.1) !
                If this is not done, pointer arithmetics will
                work only within the first 64k segment.

            -   NEVER use 'int' again! use instead

                    INT or long     to declare 32 bit integer
                    sysint          to declare ints which are used
                                    in system calls and may be 16
                                    or 32 bits wide (depending on
                                    system)
                    short           to declare 16 bit integer   

    Local Terminology:

        Abbrev. Meaning
        ------- ------------------------
        ...     ...

    Developers: ID: Name:
    =========== --- -----
                JTH Juergen Thumm

  _____________________________________/VERSION HISTORY\____________________
 /Date_ Version Who What____________________________________________________\ 
 yymmdd ------- --- ---------------------------------------------------------
 930814 0.90    JTH created
 940121             added DIRSEP_LEN

 940905 0.91    JTH ported to Windows 3.1

*/

#include <ctype.h>
#include <errno.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
// #include <stream.h>
#include <string.h>
#include <time.h>

//   _____________________________________________________________  
//  /                                                             \ 
//  |  Operating system selection                                 | 
//  \_____________________________________________________________/ 


//  Under what operating system (OS) do we compile?

// #define  MSDOS   1   // IBM/MicroSoft PCDOS/MSDOS 5.0 and higher
#define WIN16   2   // MicroSoft Windows 16 Bit (3.1)
// #define  OS2     4   // IBM OS/2 1.3, 2.0 and higher
// #define  AMIGA   8   // Commodore AMIGA Kickstart 1.3, 2.0 and higher
// #define  UNIX    16  // any UNIX derivate
// ...

//  Under what version (or derivate) of that OS do we compile?

// ...

//   _____________________________________________________________
//  /                                                             \ 
//  |   Operating system dependent symbol definitions             |
//  \_____________________________________________________________/

//  Filename formats:

#if defined AMIGA

#   define DIRSEP   "/"
#   define ROOTDIR  ":"

#elif defined UNIX

#   define DIRSEP   "/"
#   define ROOTDIR  "/"

#else

#   define DIRSEP   "\\"
#   define ROOTDIR  "\\"
#   define LOGDRIVE ""

#endif

#define DIRSEP_LEN  1
#define ROOTDIR_LEN 1

//   _____________________________________________________________
//  /                                                             \ 
//  |   Type definitions
//  \_____________________________________________________________/

typedef unsigned char   bool;
typedef unsigned char   byte;
typedef unsigned short  uword;

#ifndef UNIX
typedef unsigned char   uchar;
typedef unsigned short  ushort;
typedef unsigned int    uint;
typedef unsigned long   ulong;
#endif

//   _____________________________________________________________
//  /                                                             \ 
//  |   extended string functions
//  \_____________________________________________________________/

#ifdef  OS2
void strlwr(char *);    // IBM C/2 1.3
void strupr(char *);
int stricmp(char *, char *);
#endif

#ifdef AMIGA
char *strlwr(char*);    // Maxon C++
char *strupr(char*);
int stricmp(const char*, const char*);
int strnicmp(char *, char *, int);
#endif

//   _____________________________________________________________
//  /                                                             \ 
//  |   Most basic macros
//  \_____________________________________________________________/

#ifndef max
#define max(x,y) ((x) > (y) ? (x) : (y))
#endif

#ifndef min
#define min(x,y) ((x) < (y) ? (x) : (y))
#endif

// ifn - IF NOT:
#define ifn(x) if(!(x))

/*
#define setbuf(x,val) memset(x,val,sizeof(x))
#define varset(x,val) memset(&x,val,sizeof(x))
#define varcpy(d,s) memcpy(d,s,sizeof(d))
*/

#define MemErr(x) perr("OUT OF MEMORY at %lu (file %s line %d)",x,__FILE__,__LINE__)

#define SysErr(x) perr("INTERNAL PROGRAM ERROR at %lu (file %s line %d)",x,__FILE__,__LINE__)

//  _____________________________________________________________
// /                                                             \ 
// | function return codes:                                      |
// \_____________________________________________________________/

enum rcode {

    OK=0,       // action performed successful

    FAILED,     // unspecified error (better use one of the following)
    MEMORY,     // out of memory
    FILEOPEN,   // file opening failed
    IO,         // any I/O error except file opening
    INDATA,     // input data syntax or values were faulty
    NOTAVAIL,   // some required information was not available
    EOD,        // end of data (stream) reached.
    INTERNAL,   // program internal error, SysErr printf'ed
    SPECIAL,    // no error, but special condition happened
    RC_OVFLOW,  // overflow of something

    };  //  USAGE EXAMPLE:
        //      rcode r;
        //      if(r=func())    {printf("Error.\n"); return r;}

//  _____________________________________________________________
// /                                                             \ 
// | memory handling & some data type adaption:
// | (further adaptions in explib.h)
// \_____________________________________________________________/

#ifdef  WIN16
#   include <alloc.h>
#endif

#ifdef WIN16

#   define HUGE huge
//  FAR will be defined by windows.h
#   define INT  long

#else

    // non-WIN16 systems:

#   define HUGE             // no 'huge' needed
#   define FAR              // no 'far'  needed
#   define INT  int         // int's expected to be 32 bit

#endif  // end of mem adaption

#endif  // end of file
