program change_background;

{
  Author:  Jason Birch (jbirch@uvaix.uvic.ca)
  Organization:  Pond Scum Productions
  Date started:  November 30, 1995
  Last update:  December 4, 1995
  Version #:  1.0

  Called With:  BAK_CHNG [windows dir] [graphic dir]

  Add this line to your AUTOEXEC.BAT file:
     call [bakchng location]bak_chng.exe [windows dir] [graphic dir]

  Where the windows dir is the location of MS Windows, and the
  graphic dir is where the images are kept.

  If no parameters are specified, then the defaults are
     windows dir = C:\WINDOWS\
     graphic dir = C:\WINDOWS\

  If only one parameter is specified, then it is assumed to be the
  windows dir, and the graphic dir defaults to the same value

  Trailing backslashes '\' are allowed as part of the directories,
  but are not required.

  In order for this program to work, after running it the first
  time, the user must go into the desktop settings and change
  the background image to [windows directory]CURRENT.BMP

  From then on, each iteration of bak_chng.exe will replace the
  CURRENT.BMP file with a random image from the graphic dir.

}

{$M 8192,0,0}           { Leave memory for child process }

uses
   Dos,
   Crt;

type
   stringtype = string[80];

var
   DirInfo        : SearchRec;
   counter,
   rndnum         : Integer;
   filename       : array[1..700] of stringtype;
   current        : file;
   backdir,
   win_dir,
   newfile        : stringtype;

function FileExists(FName: String): Boolean;

{ Boolean function that returns True if the file exists }

var
    F: file;

begin
    {$I-}
    Assign(F, FName);
    FileMode := 0;  { Set file access to read only }
    Reset(F);
    Close(F);
    {$I+}
    FileExists := (IOResult = 0) and (FName <> '');
end;  { FileExists }


Procedure DoDOS(command:stringtype);

{ This just allows calls to external DOS processes,
  executables, and batch programs. No error trapping.
  echos output to NUL}

begin   {DoDOS}
   SwapVectors;
   Exec(GetEnv('COMSPEC'), '/C ' + Command + ' > nul');
   SwapVectors;
end;    {DoDOS}

Procedure GetParams(var w_dir,b_dir:stringtype);

{ gets directory parameters for the Windows Directory
  and for the background directory.  These are placed
  on the command line with no preceeding punctuation
  (eg. '-' or '/'). }

var
   StrLength     : Integer;

begin   {GetParams}
   if ParamCount > 2 then writeln('Illegal number of parameters, using default directories.')
   else begin
      w_dir := ParamStr(1);
      StrLength := Length(w_dir);
      if w_dir[StrLength] <> '\' then w_dir := w_dir + '\';
      if ParamCount = 1 then
         b_dir := (w_dir)
      else
         begin
            b_dir := ParamStr(2);
            StrLength := Length(b_dir);
            if b_dir[StrLength] <> '\' then b_dir := b_dir + '\';
         end;
   end;
end;    {GetParams}


begin   {main}
   clrscr;
   win_dir:=('C:\WINDOWS\');
   backdir:=(win_dir);
   if ParamCount > 0 then GetParams(win_dir,backdir);
   writeln('Pond Scum Productions Q&D Background Changer v1.0');
   if FileExists(win_dir+'WIN.COM') then
      begin
         counter:=0;
         FindFirst(backdir+'*.BMP', Archive, DirInfo);
         while DosError = 0 do
            begin {make file array}
               if DirInfo.name = 'CURRENT.BMP' then
                  FindNext(DirInfo) {skip this file}
               else
                  begin {register a file}
                     counter:=counter+1;
                     Filename[counter]:=DirInfo.Name;
                     FindNext(DirInfo);
                  end; {register a file}
            end;  {make file array}
         if counter > 0 then   {there ARE .BMP files in the graphic dir}
            begin  {swap in new background}
               randomize;
               rndnum:=(random(counter)+1);
               if (rndnum > counter) then rndnum := counter;
               newfile:=filename[rndnum];
               writeln('Now changing background to ',(newfile),' which is #',rndnum:0,' of ',counter:0,' possible graphics.');
               if FileExists(win_dir+'CURRENT.BMP') then
                  begin {erase current.bmp}
                     assign(current,win_dir+'CURRENT.BMP');
                     erase(current);
                  end; {erase current.bmp}
               DoDOS('COPY '+backdir+newfile+' '+win_dir+'CURRENT.BMP');
               delay(1000);
            end   {swap in new background}
         else    {there are NO .bmp files in the graphic dir}
            begin   {graphics error message}
              writeln('No .bmp files avaliable in the ',backdir,' directory');
              delay(2500);
            end;    {graphics error message}
      end  {Windows test succeeded}
   else  {Windows test failed}
      begin   {windows error message}
        writeln('The Windows directory is specified incorrectly: ',win_dir);
        delay(2500);
      end;     {windows error message}
   clrscr;
end.
