unit ticform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, wapcalls;

type
  TTicServe = class(TForm)
    Label2: TLabel;
    Label3: TLabel;
    teNumRequests: TEdit;
    teLastDocument: TEdit;
    Label14: TLabel;
    lb_poman: TListBox;
    lb_wapdoc: TListBox;
    lb_dynsite: TListBox;
    lb_MakeWeb: TListBox;
    lb_using: TListBox;
    lb_register: TListBox;
    lb_staticdyn: TListBox;
    lb_brownbear: TListBox;
    lb_wapdelphi: TListBox;
    lb_wappb: TListBox;
    lb_notfound: TListBox;
    lb_regform: TListBox;
    lb_startserving: TListBox;
    lb_stopserving: TListBox;
    lb_getdocname: TListBox;
    lb_senddocument: TListBox;
    lb_sendtext: TListBox;
    Label1: TLabel;
    teParameters: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
     procedure WebRequest(var msg: TMessage); message wm_User + 1;
  end;

type
   stringArray  = array[1..100] of string;
   winArray = array[1..8] of string;


 var
  TicServe                  :TTicServe;
  ii_numdocuments           :integer;
  is_wingrid                :winArray;

implementation
{$R *.DFM}


// Forward declarations
function TicInfo :string; forward;
function TicTacToe(as_Parm :string) :string; forward;
function TestForWin(as_board :string; as_player :string) :boolean; forward;
function CatsGame(as_parm :string) :string; forward;
function TicGrid(as_parm :string; ab_done :boolean) :string; forward;
function PlayerWon :string; forward;
function GetMove(as_board :string; as_player :string) :integer; forward;

// end forward declarations



procedure TTicServe.FormCreate(Sender: TObject);
var
  iRet, iValue   :integer;
  wWord          :word;
  pHost          :pchar;
begin
   // Make the Wapapi call: StartServing to start listening for Web requests
   //

   wWord := self.Handle;    {handle of the current form}
   iValue := wm_user + 1;   {the event number to trigger for web requests}
   iRet := StartServing(wWord, iValue, '0.0.0.0', 80);

   // Identify the winning combinations for the game
   //
   is_WinGrid[1] := '***------';
   is_WinGrid[2] := '---***---';
   is_WinGrid[3] := '------***';
   is_WinGrid[4] := '*--*--*--';
   is_WinGrid[5] := '-*--*--*-';
   is_WinGrid[6] := '--*--*--*';
   is_WinGrid[7] := '*---*---*';
   is_WinGrid[8] := '--*-*-*--';
end;

procedure TTicServe.FormDestroy(Sender: TObject);
var
 iRet  :integer;
begin
   //
   // Make the Wapapi call: StopServing to stop listening for web requests
   //
   iRet := StopServing();
end;



// WebRequest:  this is a user-defined event on the form that
//              has been hooked to a window's message.
//              the messag number: wm_User + 1 has been used
//              but any number above 1024 (wb_User) may be used, as long
//              as the same event number that is used to declare the
//              user event is passed to Wapapi inthe StartServing call.
//
procedure TTicServe.WebRequest(var msg :TMessage);
var
   lb_found, lb_parms                           :boolean;
   li_hits, li_parms, li_len, li_line, li_ret   :integer;
   li_position, li_chunk, li_parm               :integer;
   liChar, liLen  :integer;
   lp_doc, lp_text                              :pchar;
   ls_text, ls_doc, ls_change, ls_ext           :string;
   ls_parms, ls_temp                            :string;
   llb_text                                     :TListBox;
   lp_ParmNames, lp_ParmValues                  :array[0..1000] of pchar;
begin
   // Display the total number of hits on-screen
   //
   li_hits := StrToInt(teNumrequests.Text);
   Inc(li_hits);
   teNumrequests.Text := IntToStr(li_hits);


   // Use the Wapapi call: GetDocName to get the name of the requested document
   //
   lp_doc := StrAlloc(255);        // always make space for the doc's name first
   li_ret := GetDocName(lp_doc, li_parms);
   if (lp_doc = nil) then
     ls_doc := ''
   else
      ls_doc := StrPas(lp_doc);


   // Standardize the document name
   //
   ls_doc := lowercase(ls_doc);
   while Copy(ls_doc, 1, 1) = '\' do
      ls_doc := Copy(ls_doc, 2, Length(ls_doc) - 1);


   if ls_doc = 'parms' then
   begin
      lp_text := StrAlloc(1000);
      StrPCopy(lp_text, '<html><body><h2>Parms</h2>');
      BufferText(lp_text);
      StrPCopy(lp_text, IntToStr(li_Parms) + ' parms were found.<br><br>');
      BufferText(lp_text);
      for li_parm := 1 to li_parms do
      begin
         lp_ParmNames[1] := StrAlloc(500);
         lp_ParmValues[1] := StrAlloc(500);
         GetParm(li_parm, lp_ParmNames[1], lp_ParmValues[1]);

         StrPCopy(lp_text, IntToStr(li_Parm) + ') ' + lp_ParmNames[1] + '=');
         BufferText(lp_text);

         StrCopy(lp_text, lp_ParmValues[1]);
         BufferText(lp_text);
         StrPCopy(lp_text, '<br>');
         BufferText(lp_text);

         StrDispose(lp_ParmNames[1]);
         StrDispose(lp_ParmValues[1]);
      end;

      StrPCopy(lp_text, '</body></html>');
      BufferText(lp_text);

      SendText;
      StrDispose(lp_text);
      Exit;
  end;

   // Read any parameters
   //
   if (li_parms > 0) then
      begin
         // Dimension room for parameters & Get parms from Wapapi
         //
         for li_line := 1 to 2 do
         begin
            lp_ParmNames[li_line] := StrAlloc(50);
            lp_ParmValues[li_line] := StrAlloc(50);
         end;
         li_parm := GetParm(1, lp_ParmNames[1], lp_ParmValues[1]);
         li_parm := GetParm(2, lp_ParmNames[2], lp_ParmValues[2]);
         //
         // Display info on-screen
         //
         teLastDocument.Text := ls_doc + ' {w/parms}';
         teParameters.text := IntToStr(li_parms) + ' parms passed';
      end
   else
      begin
         //
         // No parameters; display info on-screen
         //
         teLastDocument.Text := ls_doc;
         teParameters.text := '';
      end;

//   if Lowercase(Copy(ls_doc, Length(ls_doc) - 3, 4 )) = '.htm' then
//   begin
//      lp_doc := StrAlloc(100);
//      StrPCopy(lp_doc, ls_doc);
//      SendDocument(lp_Doc);
//      StrDispose(lp_doc);
//      Exit
//   end;


   if ls_doc = 'test' then
   begin
      lp_text := StrAlloc(255);
      StrPCopy(lp_text, '<html><frameset rows="25%,*">');
      BufferText(lp_text);

      StrPCopy(lp_text, '<frame name="top" src="intro">');
      BufferText(lp_text);
      StrPCopy(lp_text, '<frame name="bottom" src="intro">');
      BufferText(lp_text);
      StrPCopy(lp_text, '</frameset></html>');
      BufferText(lp_text);

      StrDispose(lp_text);
      SendText;
      Exit;
   end;

   // If it's an unknown document, send an intro message,
   // otherwise, build the Tic-Tac-Toe Page
   //
   if ls_doc <> 'tictactoe' then
      ls_text := TicInfo
   else
      begin
         if (li_parms > 0) then
            ls_parms := StrPas(lp_parmvalues[2])
          else
             ls_parms := '';
         ls_text := TicTacToe(ls_parms);
      end;

   // Use Wapapi calls to build & send the document
   //
   li_len := Length(ls_text);
   li_position := 1;
   lp_text := StrAlloc(255);
   while li_position < li_len do
   begin
      li_chunk := 254;
      if (li_position + li_chunk)>li_len then
         li_chunk := li_len - li_position + 1;
      ls_temp := Copy(ls_text, li_position, li_chunk);
      StrPCopy(lp_text, ls_temp);
      BufferText(lp_text);
      li_position := li_position + li_chunk;
   end;
   StrDispose(lp_text);
   SendText;
end;

// TicInfo -- Used to build an intro screen;
//            Returns an HTML document as a string
//
function TicInfo :string;
var
  ls_text               :string;
begin
   ls_text := '<html><body>';
   ls_text := ls_text + '<h1>Welcome to ';
   ls_text := ls_text + '<font color="#0000FF">Tic-Tac-Toe</font></h1>';
   ls_text := ls_text + '(The game of ultimate strategy and cunning.)';
   ls_text := ls_text + '<br><br>To start a game, click here: ';
   ls_text := ls_text + '<a href="/tictactoe">Start a Game</a>';
   ls_text := ls_text + '<br><br>';
   ls_text := ls_text + '<font color="#0000FF" size=3>';
   ls_text := ls_text + 'This page was produced <i>dynamically</i>';
   ls_text := ls_text + ' using Wapapi.</font>';
   ls_text := ls_text + '</body></html>';
   TicInfo := ls_text;
end;

// TicTacToe -- Used to build a Tic-Tac-Toe board based on
//              the passed string.
//              Returns an HTML document as a string
//
function TicTacToe(as_Parm :string) :string;
var
  lb_won                           :boolean;
  ls_text, ls_cell, ls_before      :string;
  li_blanks, li_position, li_move  :integer;
  li_row, li_column                :integer;
begin
   // Build the heading
   //
   ls_text := '<html><body>';
   ls_text := ls_text + '<h1><font color="#0000FF">Tic-Tac-Toe</font></h1>';

   // See if X's latest move won the game
   //
   lb_won := TestForWin(as_parm, 'x');
   if lb_won = TRUE then
      begin
         ls_text := ls_text + TicGrid(as_parm, TRUE);
         ls_text := ls_text + PlayerWon;
         TicTacToe := ls_text;
         exit;
      end;

   if Pos('x', as_Parm) > 0 then
      //
      // The game is afoot, craftily determine the best strategy
      //
      begin
         li_blanks := 0;
         for li_position := 1 to 9 do
           if as_parm[li_position] = '-' then Inc(li_blanks);
         if li_blanks = 0 then
            begin
               ls_text := CatsGame(as_parm);
               TicTacToe := ls_text;
               Exit
            end;
         //
         // Determine the Program's best move
         //
         li_move := GetMove(as_parm, 'o');
         as_parm[li_move] := 'o';
      end;

   lb_won := TestForWin(as_parm, 'o');
   if lb_won = TRUE then
      begin
         ls_text := ls_text + TicGrid(as_parm, TRUE);
         ls_text := ls_text + '<font color="#FF0000">Ha!</font>';
         ls_text := ls_text + 'Looks like you need some practice...';
         ls_text := ls_text + '<br>How about a re-match?';
         ls_text := ls_text + '<br><br><a href="/tictactoe">Play Another Game</a>';
         ls_text := ls_text + '</body></html>';
         TicTacToe := ls_text;
         exit;
      end;


   // Build the tic-tac-toe grid
   //
   if as_parm = '' then as_parm := '---------';
      ls_text := ls_text + TicGrid(as_parm, FALSE);

   ls_text := ls_text + '<br><br>Make your move cowboy...';
   ls_text := ls_text + '</body></html>';
   TicTacToe := ls_text;
end;


// Makes the tic-tac-toe table
//
function TicGrid(as_parm :string; ab_done :boolean) :string;
var
  li_position, li_column, li_row      :integer;
  ls_text, ls_before, ls_cell         :string;
begin
   ls_text := '<table border=1>' + #13#10;
   for li_row := 1 to 3 do
   begin
      ls_text := ls_text + '<tr>';
      for li_column := 1 to 3 do
      begin
         ls_text := ls_text + '<td align="center" width=80 height=40>';
         ls_before := as_parm;
         li_position := ((li_row - 1) * 3) + li_column;
         ls_cell := as_parm[li_position];
         if (ls_cell='x') or (ls_cell='o') then
            ls_text := ls_text + UpperCase(ls_cell)
         else
            begin
               // Store the result of clicking in a hidden field that will then
               //  gets passed back through this procedure if the player clicks
               //  thebutton
               //
               if ab_done = FALSE then
                  begin
                     ls_text := ls_text + '<form action="\tictactoe" method="POST">';
                     ls_text := ls_text + '<input type="submit" name="submit" value="blank">';
                     ls_before[li_position] := 'x';
                     ls_text := ls_text + '<input type="hidden" name="state" ';
                     ls_text := ls_text + 'value="' + ls_before + '">';
                     ls_text := ls_text + '</form>';
                  end
               else
                  ls_text := ls_text + 'blank';
            end;
         ls_text := ls_text + '</td>';
      end;
      ls_text := ls_text + '</tr>' + #13#10;
   end;
   ls_text := ls_text + '</table>' + #13#10;

   TicGrid := ls_text;
end;


// Compares the current tic-tac-toe board with a winning board template
//
// as_board  -- current board state
// as_source -- a winning board
// as_search --  '*'
// as_replace -- 'o'
function StrReplace (as_board :string; var as_source :string; as_search, as_replace :string) :integer;
var
   li_position, li_hits  :integer;
   ls_temp               :string;
begin
   li_hits := 0;
   for li_position := 1 to 9 do
   begin
      if (as_source[li_position]= as_search) and (as_board[li_position]= as_replace) then
         begin
            ls_temp := Copy(as_source, 1, li_position - 1) + as_replace + Copy(as_source, li_position + 1, Length(as_source) - li_position);
            as_source := ls_temp;
            Inc(li_hits);
         end
      else
         //  If this position is on the winning board and is taken already (is not blank)
         //  then take the available position (*) out of the winning board
         //
         if (as_source[li_position]= as_search) and (as_board[li_position] <> '-') then
         begin
            ls_temp := Copy(as_source, 1, li_position - 1) + '-' + Copy(as_source, li_position + 1, Length(as_source) - li_position);
            as_source := ls_temp;
         end;
   end;

   if (li_hits = 2) and (pos('*', as_source) = 0) then
      li_hits := 0;
   StrReplace := li_hits;
end;


// See what the best move is for the passed player
//
function GetMove(as_board :string; as_player :string) :integer;
var
   li_board, li_pos, li_hits, li_move   :integer;
   ls_test, ls_other                    :string;
begin
   //
   // See if there is a winning move
   //
   li_Move := 0;
   for li_board := 1 to 8 do
   begin
      ls_test := is_winGrid[li_board];
      for li_pos := 1 to 9 do
      begin
         li_hits := StrReplace(as_board, ls_test, '*', as_player);
         if (li_hits = 2) and (li_move=0) then   // Player can win in 1 move
            li_move := Pos('*', ls_test);
      end;
   end;

   //
   // See if a blocking move is needed
   //
   if li_move = 0 then
   begin
     ls_other := 'x';
     if as_player = ls_other then ls_other := 'o';
      for li_board := 1 to 8 do
         begin
         ls_test := is_winGrid[li_board];
         for li_pos := 1 to 9 do
         begin
            li_hits := StrReplace(as_board, ls_test, '*', ls_other);
            if (li_hits = 2) and (li_move=0) then   // Player can win in 1 move
               li_move := Pos('*', ls_test);
         end;
      end;
   end;

  //
  // Randomly choose a move
  //
  if li_move = 0 then
  begin
     li_move := Random(9) + 1;
     while as_board[li_move] <> '-' do
        li_move := Random(9) + 1;
  end;

  GetMove := li_move;
end;

// Check the 8 possible winning positions
//
function TestForWin(as_board :string; as_player :string) :boolean;
var
  lb_won                     :boolean;
  li_board, li_pos, li_hits  :integer;
begin
   if as_board = '' then
      begin
         TestForWin := FALSE;
         Exit;
      end;
   //
   // Loop through the possible win boards & see if any match
   //
   lb_won := FALSE;
   for li_board := 1 to 8 do
      begin
         li_hits := 0;
         for li_pos := 1 to 9 do
            begin
               if (copy(is_WinGrid[li_board], li_pos, 1)='*')
                   and (copy(as_board, li_pos, 1)=as_player) then
                   Inc(li_hits);
            end;
         if li_hits = 3 then
            lb_won := TRUE;
      end;
   TestForWin := lb_won;
end;


// Show a page for the result of a Cat's game
//
function CatsGame(as_parm :string) :string;
var
   ls_text   :string;
begin
   ls_text := '<html><body>';
   ls_text := ls_text + '<h1><font color="#0000FF">Cat''s Game</font></h1>';
   ls_text := ls_text + TicGrid(as_parm, TRUE);
   ls_text := ls_text + 'You are a worthy opponent.';
   ls_text := ls_text + '<br>How about another go at the title champ?';
   ls_text := ls_text + '<br><br><a href="\tictactoe">Play Another Round</a>';
   ls_text := ls_text + '</body></html>';
   CatsGame := ls_text;
end;

function PlayerWon() :string;
var
   ls_text    :string;
begin
   ls_text := ls_text + '<font color="#FF0000">Congratulations!</font>';
   ls_text := ls_text + '<br>Have you considered the Olympics?';
   ls_text := ls_text + '<br><br><a href="/tictactoe">Play Another Game</a>';
   ls_text := ls_text + '</body></html>';
   PlayerWon := ls_text;
end;



end.
