//
//  Backpropagation Neural Learning Algorithm Demo
//
//  Cygron Ltd. 1997
//

unit test;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, nncomp;

type
  TForm1 = class(TForm)
    ButtonReset: TButton;
    ButtonLearn: TButton;
    Panel1: TPanel;
    PaintBoxGraph: TPaintBox;
    LabelIter: TLabel;
    LabelError: TLabel;
    ButtonSave: TButton;
    ButtonLoad: TButton;
    N: TNeuralNetwork;
    procedure ButtonResetClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PaintBoxGraphPaint(Sender: TObject);
    procedure ButtonLearnClick(Sender: TObject);
    procedure ButtonSaveClick(Sender: TObject);
    procedure ButtonLoadClick(Sender: TObject);
  private
    { Private declarations }
    lasterror: Double;
    procedure ShowStat;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  ButtonResetClick(nil);
end;

procedure TForm1.ShowStat;
begin
  LabelError.Caption := Format('Error: %.2f%%',[(lasterror*100)]);
  LabelIter.Caption := Format('Iteration: %d',[N.StepsNum]);
end;

procedure TForm1.ButtonResetClick(Sender: TObject);
begin
  Randomize;
  lasterror := 0.5;
  N.Structure.Clear;
  N.Structure.Add('2');
  N.Structure.Add('2');
  N.Structure.Add('1');
  N.Initialize;
  N.SetInputMin(1,0);
  N.SetInputMax(1,1);
  N.SetInputMin(2,0);
  N.SetInputMax(2,1);
  N.SetOutputMin(1,0);
  N.SetOutputMax(1,1);
  ShowStat;
  PaintBoxGraph.Invalidate;
end;

procedure TForm1.ButtonLearnClick(Sender: TObject);
var
   i: Integer;
   x,y: Byte;
begin
   Randomize;
   Screen.cursor := crHourglass;
   for i := 1 to 1000 do begin
      x := Random(2);
      y := Random(2);
      N.SetInput(1,x);
      N.SetInput(2,y);
      N.SetExpOutput(1,x xor y);
      lasterror := N.Learn( 0.3, 0.8 );
   end;
   ShowStat;
   Screen.cursor := crDefault;
   PaintBoxGraph.Invalidate;
end;

procedure TForm1.PaintBoxGraphPaint(Sender: TObject);
var
   i,j: Word;
   r: TRect;
begin
   for i := 0 to 20 do begin
      for j := 0 to 20 do begin
         try
            N.SetInput(1,i/20);
            N.SetInput(2,j/20);
            N.Calc;
            r.left := i * 10;
            r.right := (i+1) * 10;
            r.top := j * 10;
            r.bottom := (j+1) * 10;
            PaintBoxGraph.Canvas.Brush.Color := RGB(Round(N.GetOutput(1)*205 + 25),0,0);
            PaintBoxGraph.Canvas.FillRect(r);
         except
            on Exception do;
         end;
      end;
   end;
end;

procedure TForm1.ButtonSaveClick(Sender: TObject);
begin
   try
     N.Save;
   except
     on Exception do Application.MessageBox('Cannot save network!','Backprop demo',MB_ICONEXCLAMATION);
   end;
end;

procedure TForm1.ButtonLoadClick(Sender: TObject);
begin
   try
      N.Load;
   except
      on Exception do begin
         Application.MessageBox('Cannot load network','Backprop demo',MB_ICONEXCLAMATION);
         ButtonResetClick(self);
       end;
    end;
    ShowStat;
    PaintBoxGraph.Invalidate;
end;

end.
