unit Btest;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Ubackup, ExtCtrls, bigauge;

type
  TTestBackup = class(TForm)
    UBack: TUBackup;
    GroupBox1: TGroupBox;
    Prozent: TBiGauge;
    Label1: TLabel;
    FileInProgress: TLabel;
    RestZeit: TLabel;
    Status: TPanel;
    GroupBox2: TGroupBox;
    FilesToBackup: TMemo;
    GroupBox3: TGroupBox;
    BitBtn1: TBitBtn;
    Destination: TEdit;
    UseCompression: TCheckBox;
    Filecount: TLabel;
    Button1: TButton;
    RestoreDestination: TEdit;
    Label2: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure UBackPercent(Sender: TObject);
    procedure UBackNextFile(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure UBackStartFileScan(Sender: TObject);
    procedure UBackFileFound(Sender: TObject);
    procedure UBackNextDir(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure UBackEndFileScan(Sender: TObject);
    procedure UBackReady(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    FileCounter : Longint;
  end;

var
  TestBackup: TTestBackup;

implementation

{$R *.DFM}

procedure TTestBackup.BitBtn1Click(Sender: TObject);
var Ergebnis : Word;
    i        : Word;
begin
   Screen.Cursor := crHourGlass;
   Uback.Compression := UseCompression.Checked;
   uback.backupon    := Destination.Text;
   uback.FilesToBackup.Clear;
   for i:=0 to FilesToBackup.Lines.Count-1 do
   uback.FilesToBackup.Add(FilesToBackup.Lines[i]);
   uback.Backup;
end;

procedure TTestBackup.UBackPercent(Sender: TObject);
begin
   Application.ProcessMessages;
   Restzeit.Caption := FormatDateTime('hh:nn.ss',uback.remainingtime);
   Prozent.Value := uback.percent;
end;

procedure TTestBackup.UBackNextFile(Sender: TObject);
begin
   FileInProgress.Caption := UBack.FileAtWork;
   dec(FileCOunter);
   FileCount.Caption := inttostr(FileCOunter)+ ' Files';
   Application.ProcessMessages;
end;

procedure TTestBackup.BitBtn2Click(Sender: TObject);
var Ergebnis : Integer;
begin
end;

procedure TTestBackup.UBackStartFileScan(Sender: TObject);
begin
   FileCounter := 0;
   Status.Caption := 'Scan for files to be backed up';
end;

procedure TTestBackup.UBackFileFound(Sender: TObject);
begin
   inc(FileCounter);
   FileCount.Caption := inttostr(FileCounter)+' Files';
   Application.ProcessMessages;
end;

procedure TTestBackup.UBackNextDir(Sender: TObject);
begin
   FileInProgress.Caption := TUBackup(Sender).FileAtWork;
   Application.ProcessMessages;
end;

procedure TTestBackup.FormShow(Sender: TObject);
begin
   Status.Caption  := 'Specify what to backup and where to backup';
   Prozent.Value   := 0;
   Restzeit.Caption:= '00:00.00';
   FileCount.Caption := '0 File(s)';
   FileCounter       := 0;
end;

procedure TTestBackup.UBackEndFileScan(Sender: TObject);
begin
   Status.Caption := 'Selected files are being backed up';
end;

procedure TTestBackup.UBackReady(Sender: TObject);
begin
   Status.Caption := 'Backup is ready';
   uback.filestobackup.savetofile('c:\soll.tmp');
   uback.filesinarchive.savetofile('c:\ist.tmp');
   Screen.Cursor  := crDefault;
end;

procedure TTestBackup.Button1Click(Sender: TObject);
var d : TDateTime;
    e : String;
    ecd : Integer;
begin
   Screen.Cursor := crHourglass;
   Status.Caption  := 'Restore starts...';
   Prozent.Value   := 0;
   Restzeit.Caption:= '00:00.00';
   FileCount.Caption := '0 File(s)';
   FileCounter       := 0;
   Uback.Compression := UseCompression.Checked;
   uback.backupon    := Destination.Text;
   uback.redirectRestore := TRUE;
   uback.restoreTo   := RestoreDestination.Text;
   ecd := uback.restore;
   Screen.Cursor := crDefault;
   if ecd<>0 then MessageDlg('Restore completed with Errorcode '+inttostr(ecd),
   mtError,[mbok],-1);
end;

end.
