/***********************************************************************

                       CSA Library, Free Evaluation Version 2.1.1 
                                           Release: May 14th 1997 

         Inline versions of 'max' and 'min' which return an
         'appropriate' variable type.
         Useful for calling polymorphic functions.

                                           Copyright(c) 1994-1997 
                                                          ComBits 
                                                  The Netherlands 
***********************************************************************/

#ifndef __CSMAXMIN_H
#define __CSMAXMIN_H


#include "cstypes.h"


#ifdef _CP_001
#pragma warn -sig
#endif

#ifdef _CP_002
#pragma warning(disable : 4051 4135)
#endif

#ifdef _CP_004
#pragma warning  389  9
#endif


inline U16    csmin(U16  x,U16    y)          { return (x<y) ? x: y; }
inline S16    csmin(S16  x,U16    y)          { return ((S32)x<(S32)y) ? x: y; }
inline S32    csmin(S32  x,U16    y)          { return ((S32)x<(S32)y) ? x: y; }
inline U16    csmin(U32  x,U16    y)          { return (x<y) ? x: y; }
inline S16    csmin(U16  x,S16    y)          { return ((S32)x<(S32)y) ? x: y; }
inline S16    csmin(S16  x,S16    y)          { return (x<y) ? x: y; }
inline S32    csmin(S32  x,S16    y)          { return (x<y) ? x: y; }
inline S16    csmin(U32  x,S16    y)          { return ((S32)x<(S32)y) ? x: y; }
inline S32    csmin(U16  x,S32    y)          { return ((S32)x<(S32)y) ? x: y; }
inline S32    csmin(S16  x,S32    y)          { return (x<y) ? x: y; }
inline S32    csmin(S32  x,S32    y)          { return (x<y) ? x: y; }
inline S32    csmin(U32  x,S32    y)          { return ((S32)x<(S32)y) ? x: y; }
inline U16    csmin(U16  x,U32    y)          { return (x<y) ? x: y; }
inline S16    csmin(S16  x,U32    y)          { return ((S32)x<(S32)y) ? x: y; }
inline S32    csmin(S32  x,U32    y)          { return ((S32)x<(S32)y) ? x: y; }
inline U32    csmin(U32  x,U32    y)          { return (x<y) ? x: y; }
//inline S32    csmin(U16    x,long   y)                { return ((S32)x<(S32)y) ? x: y; }
//inline S32    csmin(S16    x,long   y)                { return (x<y) ? x: y; }
//inline S32    csmin(S32    x,long   y)                { return (x<y) ? x: y; }
//inline S32    csmin(U32    x,long   y)                { return ((S32)x<(S32)y) ? x: y; }
//inline S32    csmin(long   x,long   y)                { return ((S32)x<(S32)y) ? x: y; }
inline float  csmin(float  x,float  y)        { return (x<y) ? x: y; }




inline U16    csmax(U16  x,U16    y)          { return (x>y) ? x: y; }
inline U16    csmax(S16  x,U16    y)          { return ((S32)x>(S32)y) ? x: y; }
inline S32    csmax(S32  x,U16    y)          { return ((S32)x>(S32)y) ? x: y; }
inline U32    csmax(U32  x,U16    y)          { return (x>y) ? x: y; }
inline U16    csmax(U16  x,S16    y)          { return ((S32)x>(S32)y) ? x: y; }
inline S16    csmax(S16  x,S16    y)          { return (x>y) ? x: y; }
inline S32    csmax(S32  x,S16    y)          { return (x>y) ? x: y; }
inline U32    csmax(U32  x,S16    y)          { return ((S32)x>(S32)y) ? x: y; }
inline S32    csmax(U16  x,S32    y)          { return ((S32)x>(S32)y) ? x: y; }
inline S32    csmax(S16  x,S32    y)          { return (x>y) ? x: y; }
inline S32    csmax(S32  x,S32    y)          { return (x>y) ? x: y; }
inline U32    csmax(U32  x,S32    y)          { return ((S32)x>(S32)y) ? x: y; }
inline U32    csmax(U16  x,U32    y)          { return (x>y) ? x: y; }
inline U32    csmax(S16  x,U32    y)          { return ((S32)x>(S32)y) ? x: y; }
inline U32    csmax(S32  x,U32    y)          { return ((S32)x>(S32)y) ? x: y; }
inline U32    csmax(U32  x,U32    y)          { return (x>y) ? x: y; }
inline float  csmax(float  x,float  y)        { return (x>y) ? x: y; }



#ifdef _CP_001
#pragma warn .sig
#endif


#ifdef _CP_002
#pragma warning(default : 4051 4135)
#endif


#endif
