
/***************************************************************/
/*Copyright (c) by Continocean Tech Inc. 	       	       */
/*12 Mountain Ave., Montville, New Jersey, USA 07045           */
/*All rights reserved. No part of this work covered by the     */
/*copyright hereon may be reproduced or used in any form or by */
/*any means----graphic, electronic, or mechanical, including   */
/*photocopying, recording, taping, or information storage and  */
/*retrieval systems----without written permission of 	       */
/*Continocean Tech inc.					       */
/***************************************************************/


#ifndef _IMATRIX_H
#define _IMATRIX_H 1




class matrix;

class imatrix{
	friend class matrix;
protected:
	 int		M;			// number of rows
	 int		N;			// number of columns
	 int		*X;


public:

	 imatrix ();
	 imatrix (int m, int n=1);
	 imatrix (const imatrix &a);
//	 imatrix (const matrix &a);
	~imatrix ();


	 imatrix&	operator  = (const imatrix& a);
	 imatrix&	operator  = (const matrix& a);
	 int&        operator () (int i,int j) const;
	 int&        operator () (int i) const;


	friend imatrix operator +(const imatrix&, const imatrix&);
	friend imatrix operator -(const imatrix&, const imatrix&);
	friend imatrix operator -(const imatrix&);
	friend imatrix operator *(int, const imatrix&);
	friend imatrix operator *(const imatrix&, int);
	friend imatrix operator *(const imatrix&, const imatrix&);

	friend imatrix operator |(const imatrix&, const imatrix&);  //or
	friend imatrix operator &(const imatrix&, const imatrix&);  //and
	friend imatrix operator ^(const imatrix&, const imatrix&);  //X-or

	friend int operator ==(const imatrix&, const imatrix&);  
	friend int operator !=(const imatrix&, const imatrix&);  

	friend imatrix abs(const imatrix &a);
	friend int normsq(const imatrix &a); //sum a(i,j)*a(i,j) 
	friend imatrix diag(const imatrix &a); 
        friend imatrix init(imatrix& a, int x ...);
	friend imatrix joinr(const imatrix &a, const imatrix &b); //right join matrices a,b as (a b)
	friend imatrix joinr(const imatrix &a, int b); //right join row-vector a 
						  //with int b as (a b)
	friend imatrix joinr(int a, const imatrix & b); //right join int a 
						  //with row-vector b as (a b)
	friend imatrix joind(const imatrix &a, const imatrix &b);
	friend imatrix joinl(const imatrix &a, const imatrix &b); //lower join matrices a,b as |a|
						   //				|b|	
	friend imatrix joind(const imatrix &a, int b);  //lower join column-vector a   |a|
						   //with int b as	 	  |b|
	friend imatrix joind(int a, const imatrix& b);  //lower join int a with    |a|
						   //column-vector b as		 |b|
	friend imatrix shiftl(const imatrix&);//shift left
	friend imatrix shiftr(const imatrix&);//shift right
	friend imatrix shiftu(const imatrix&);//shift up
	friend imatrix shiftd(const imatrix&);//shift down
	friend imatrix sub(const imatrix& a, int m1, int n1, int m2, int n2);//Take submatrix	
				//beginning at a(m1,n1) and ending at a(m2,n2)
	friend imatrix TT(const imatrix&);  //transpose
	friend void printf(const imatrix &a);  //Usage:printf(a)
	friend void printw(const imatrix &a);  //Usage:printf(a)
	friend void fprintf(FILE *fp,const imatrix &a);  //Usage:fprintf(fp,a)
	friend void fscanf(FILE *fp, imatrix &a);  //Usage:fscanf(fp,a)

	friend void fprintf(char *file, const imatrix& a);


	friend matrix operator /(const imatrix&, const imatrix&);  
	friend matrix operator /(int, const imatrix&);  
	friend matrix operator /(const imatrix&, int);  


};/*end of class*/


#endif


