
#ifndef _MATRIXN_H
#define _MATRIXN_H 1




#define In	identityn
#define Un	unitaryn

class cmatrixn;
class imatrixn;
class matrix;

class matrixn{
	friend class cmatrixn;
	friend class imatrixn;
protected:
	 int		M;			// number of rows
	 int		N;			// number of columns
	 double		*X;


public:

	 matrixn ();
	 matrixn (int m, int n=0);
	 matrixn (const matrixn &a);
	 matrixn (const imatrixn &a);
	~matrixn ();


	 matrixn&	operator  = (const matrixn& a);
	 double&        operator () (int i,int j) const;
	 double&        operator () (int i) const;


	friend matrixn operator +(const matrixn&, const matrixn&);
	friend matrixn operator -(const matrixn&, const matrixn&);
	friend matrixn operator -(const matrixn&);
	friend matrixn operator *(double, const matrixn&);
	friend matrixn operator *(const matrixn&, double);
	friend matrixn operator *(const matrixn&, const matrixn&);
	friend matrixn operator /(const matrixn&, const matrixn&);  
	friend matrixn operator /(double,const matrixn&);  
	friend matrixn operator /(const matrixn&, double);  

	friend matrixn operator |(const matrixn&, const matrixn&);  //or
	friend matrixn operator &(const matrixn&, const matrixn&);  //and
	friend matrixn operator ^(const matrixn&, const matrixn&);  //X-or
        
	friend int operator ==(const matrixn&, const matrixn&);  
	friend int operator !=(const matrixn&, const matrixn&);  


	friend matrixn  abs(const matrixn &a); //sqrt(sum a(i,j)*a(i,j)) 
	friend double norm(const matrixn &a); //sqrt(sum a(i,j)*a(i,j)) 
	friend double normsq(const matrixn &a); //sum a(i,j)*a(i,j) 
	friend double det(const matrixn &a); 
	friend matrixn identityn(int); 
        friend matrixn init(matrixn& a, double x ...);
	friend matrixn TT(const matrixn&);  //transpose
	friend matrixn unitaryn(int n);
	friend matrixn unitaryn(int m,int n);

	friend void printf(const matrixn &a);  //Usage:printf(a)
	friend void printw(const matrixn& a);
	friend void fprintf(FILE *fp,const matrixn &a);  //Usage:fprintf(fp,a)
	friend void fscanf(FILE *fp, matrixn &a);  //Usage:fscanf(fp,a)

	friend matrixn shiftl(const matrixn&);//shift left
	friend matrixn shiftr(const matrixn&);//shift right
	friend matrixn shiftu(const matrixn&);//shift up
	friend matrixn shiftd(const matrixn&);//shift down

	friend matrixn sub(const matrixn& a, int m1, int n1, int m2, int n2);

	friend matrixn convol(const matrixn &x, const matrixn &y);

	friend void plot(const matrixn &a);
	friend void plot(const matrixn &a, const matrixn &b);
	friend void plot(const matrixn &a, const matrixn &b1, const matrixn &b2);
	friend void plot(const matrixn &a, const matrixn &b1, const matrixn &b2, const matrixn &b3);
	friend void plot(const matrixn &a, const matrixn &b1, const matrixn &b2, const matrixn &b3, const matrixn &b4);
	friend void plot(const matrixn &a, const matrixn &b1, const matrixn &b2, const matrixn &b3, const matrixn &b4, const matrixn &b5);


	friend void	plot(const matrixn &x, const matrixn &y, char *legend);
	friend void	plot(const matrixn &y, char *legend);
	friend void	plot(const matrixn &x, const matrixn &y1, char *legend1, const matrixn &y2, char *legend2);
	friend void	plot(const matrixn &x, const matrixn &y1, char *legend1, const matrixn &y2, char *legend2, 
	 const matrixn &y3, char *legend3);
	friend void	plot(const matrixn &x, const matrixn &y1, char *legend1, const matrixn &y2, char *legend2, 
	 const matrixn &y3, char *legend3,const matrixn &y4, char *legend4);
	friend void	plot(const matrixn &x, const matrixn &y1, char *legend1, const matrixn &y2, char *legend2, 
       const matrixn &y3, char *legend3,const matrixn &y4, char *legend4,const matrixn &y5, char *legend5);


	friend matrix mn2m(const matrixn &a);

	friend void fprintf(char *file, const matrixn& a);
	friend void fscanf(char *file, matrixn& a);

	friend double Max(const matrixn &a);
	friend double Min(const matrixn &a);
	friend double Max(const matrixn &a, double &y_max, int &i_max, int &j_max);
	friend double Min(const matrixn &a, double &y_min, int &i_min, int &j_min);

};/*end of class*/




#endif


