
/***************************************************************/
/*Copyright (c) by Continocean Tech Inc. 	       	       */
/*12 Mountain Ave., Montville, New Jersey, USA 07045           */
/*All rights reserved. No part of this work covered by the     */
/*copyright hereon may be reproduced or used in any form or by */
/*any means----graphic, electronic, or mechanical, including   */
/*photocopying, recording, taping, or information storage and  */
/*retrieval systems----without written permission of 	       */
/*Continocean Tech inc.					       */
/***************************************************************/

#ifndef _SBINARY_H
#define _SBINARY_H 1

//signed binary

class binary;

class sbinary{
	friend class binary;
protected:
	 int		M;			// number of rows
	 int		*X;


public:

	 sbinary ();
	 sbinary (int m);
	 sbinary (const sbinary &a);
	 sbinary (const binary &a);
	~sbinary ();


	 sbinary&	operator  = (const sbinary& a);
	 int&        operator () (int i) const;


	friend int sbin2int(const sbinary& a);  
	friend sbinary int2sbin(int a, int m=16);  //convert a to m-sbinary  

	friend sbinary operator +(const sbinary&, const sbinary&);
	friend sbinary operator -(const sbinary&, const sbinary&);
	friend sbinary operator -(const sbinary&);
	friend sbinary operator *(int, const sbinary&);
	friend sbinary operator *(const sbinary&, int);

	friend sbinary operator *(const sbinary&, const sbinary&); 
	       //Float multiplication a(M-1)=sign-bit, a(M-2)=integer-bit, a(M-3)...a(0)=decimal-bits
	friend sbinary operator *(const sbinary&, float); //Float multiplication
	friend sbinary operator *(float, const sbinary&); //Float multiplication

	friend sbinary operator /(const sbinary&, const sbinary&);  
	friend sbinary operator /(int,const sbinary&);  
	friend sbinary operator /(const sbinary&, int);  

	friend sbinary operator |(const sbinary&, const sbinary&);  //or
	friend sbinary operator &(const sbinary&, const sbinary&);  //and
	friend sbinary operator ^(const sbinary&, const sbinary&);  //X-or

	friend sbinary operator >>(const sbinary& a, int n); //shift right
	friend sbinary operator <<(const sbinary& a, int n); //shift left

	friend int operator ==(const sbinary&, const sbinary&);  
	friend int operator !=(const sbinary&, const sbinary&);  

	friend int operator >(const sbinary&, const sbinary&);  
	friend int operator >=(const sbinary&, const sbinary&);  
	friend int operator <(const sbinary&, const sbinary&);  
	friend int operator <=(const sbinary&, const sbinary&);  
        
	friend float sbin2float(const sbinary &a);  
	friend sbinary float2sbin(float a, int m=16);  

	friend void printf(const sbinary &a);  //Usage:printf(a)
	friend void printw(const sbinary &a);  //Usage:printf(a)
	friend void fprintf(FILE *fp,const sbinary &a);  //Usage:fprintf(fp,a)
	friend void fscanf(FILE *fp, sbinary &a);  //Usage:fscanf(fp,a)

	friend void fprintf(char *file, const sbinary& a);
};/*end of class*/




#endif
