VERSION 2.00
Begin Form CommSettings 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Async Communications Settings"
   ClientHeight    =   3615
   ClientLeft      =   825
   ClientTop       =   1545
   ClientWidth     =   8085
   ClipControls    =   0   'False
   ControlBox      =   0   'False
   Height          =   4080
   Left            =   735
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3615
   ScaleWidth      =   8085
   Top             =   1170
   Visible         =   0   'False
   Width           =   8265
   Begin SSPanel Panel3D2 
      BevelOuter      =   1  'Inset
      BevelWidth      =   5
      BorderWidth     =   2
      ForeColor       =   &H00FFFFFF&
      Height          =   2895
      Left            =   4365
      TabIndex        =   18
      Top             =   90
      Width           =   3615
      Begin SSFrame CSDataBits 
         Caption         =   "Data Bits"
         Height          =   690
         Left            =   1755
         TabIndex        =   29
         Top             =   315
         Width           =   1545
         Begin SSOption LData7 
            Caption         =   "7"
            Height          =   330
            Left            =   900
            TabIndex        =   31
            TabStop         =   0   'False
            Top             =   270
            Width           =   555
         End
         Begin SSOption LData8 
            Caption         =   "8"
            Height          =   240
            Left            =   270
            TabIndex        =   30
            Top             =   315
            Value           =   -1  'True
            Width           =   510
         End
      End
      Begin SSFrame CSStopBits 
         Caption         =   "Stop Bits"
         Height          =   1365
         Left            =   2070
         TabIndex        =   25
         Top             =   1170
         Width           =   960
         Begin SSOption LStop2 
            Caption         =   "2"
            Height          =   285
            Left            =   225
            TabIndex        =   28
            TabStop         =   0   'False
            Top             =   990
            Width           =   555
         End
         Begin SSOption LStop15 
            Caption         =   "1.5"
            Height          =   240
            Left            =   225
            TabIndex        =   27
            TabStop         =   0   'False
            Top             =   675
            Width           =   555
         End
         Begin SSOption LStop1 
            Caption         =   "1"
            Height          =   240
            Left            =   225
            TabIndex        =   26
            Top             =   360
            Value           =   -1  'True
            Width           =   555
         End
      End
      Begin SSFrame CSParity 
         Caption         =   "Parity"
         Height          =   2220
         Left            =   315
         TabIndex        =   19
         Top             =   315
         Width           =   1230
         Begin SSOption LParityS 
            Caption         =   "Space"
            Height          =   285
            Left            =   180
            TabIndex        =   24
            TabStop         =   0   'False
            Top             =   1755
            Width           =   915
         End
         Begin SSOption LParityM 
            Caption         =   "Mark"
            Height          =   285
            Left            =   180
            TabIndex        =   23
            TabStop         =   0   'False
            Top             =   1395
            Width           =   960
         End
         Begin SSOption LParityO 
            Caption         =   "Odd"
            Height          =   240
            Left            =   180
            TabIndex        =   22
            TabStop         =   0   'False
            Top             =   1035
            Width           =   915
         End
         Begin SSOption LParityE 
            Caption         =   "Even"
            Height          =   240
            Left            =   180
            TabIndex        =   21
            TabStop         =   0   'False
            Top             =   675
            Width           =   960
         End
         Begin SSOption LParityN 
            Caption         =   "None"
            Height          =   240
            Left            =   180
            TabIndex        =   20
            Top             =   315
            Value           =   -1  'True
            Width           =   1005
         End
      End
   End
   Begin SSPanel Panel3D1 
      BevelOuter      =   1  'Inset
      BevelWidth      =   5
      BorderWidth     =   1
      ForeColor       =   &H00FFFFFF&
      Height          =   2895
      Left            =   90
      TabIndex        =   2
      Top             =   90
      Width           =   4065
      Begin SSFrame CSFlowControl 
         Caption         =   "Flow Control"
         Height          =   1230
         Left            =   1800
         TabIndex        =   5
         Top             =   1395
         Width           =   1950
         Begin SSOption LFlowXonXoff 
            Caption         =   "XON/XOFF"
            Height          =   195
            Left            =   180
            TabIndex        =   17
            TabStop         =   0   'False
            Top             =   900
            Width           =   1320
         End
         Begin SSOption LFlowRtsCts 
            Caption         =   "RTS/CTS"
            Height          =   195
            Left            =   180
            TabIndex        =   16
            Top             =   630
            Value           =   -1  'True
            Width           =   1455
         End
         Begin SSOption LFlowNone 
            Caption         =   "None"
            Height          =   240
            Left            =   180
            TabIndex        =   15
            TabStop         =   0   'False
            Top             =   315
            Width           =   1455
         End
      End
      Begin SSFrame CSCommPort 
         Caption         =   "Comm Port"
         Height          =   1095
         Left            =   1665
         TabIndex        =   4
         Top             =   180
         Width           =   2175
         Begin SSOption LCom4 
            Caption         =   "COM4"
            Height          =   195
            Left            =   1170
            TabIndex        =   14
            TabStop         =   0   'False
            Top             =   720
            Width           =   825
         End
         Begin SSOption LCom2 
            Caption         =   "COM2"
            Height          =   195
            Left            =   180
            TabIndex        =   13
            Top             =   720
            Value           =   -1  'True
            Width           =   870
         End
         Begin SSOption LCom3 
            Caption         =   "COM3"
            Height          =   240
            Left            =   1170
            TabIndex        =   12
            TabStop         =   0   'False
            Top             =   360
            Width           =   825
         End
         Begin SSOption LCom1 
            Caption         =   "COM1"
            Height          =   240
            Left            =   180
            TabIndex        =   11
            TabStop         =   0   'False
            Top             =   360
            Width           =   825
         End
      End
      Begin SSFrame CSBaudRate 
         Caption         =   "Baud Rate"
         Height          =   2355
         Left            =   225
         TabIndex        =   3
         Top             =   225
         Width           =   1230
         Begin SSOption LBaud12 
            Caption         =   "1200"
            Height          =   240
            Left            =   180
            TabIndex        =   10
            TabStop         =   0   'False
            Top             =   1935
            Width           =   915
         End
         Begin SSOption LBaud24 
            Caption         =   "2400"
            Height          =   195
            Left            =   180
            TabIndex        =   9
            TabStop         =   0   'False
            Top             =   1575
            Width           =   870
         End
         Begin SSOption LBaud48 
            Caption         =   "4800"
            Height          =   195
            Left            =   180
            TabIndex        =   8
            TabStop         =   0   'False
            Top             =   1170
            Width           =   960
         End
         Begin SSOption LBaud96 
            Caption         =   "9600"
            Height          =   195
            Left            =   180
            TabIndex        =   7
            Top             =   765
            Value           =   -1  'True
            Width           =   960
         End
         Begin SSOption LBaud192 
            Caption         =   "19200"
            Height          =   240
            Left            =   180
            TabIndex        =   6
            TabStop         =   0   'False
            Top             =   315
            Width           =   915
         End
      End
   End
   Begin CommandButton CommSetOk 
      Caption         =   "&Ok"
      Default         =   -1  'True
      Height          =   375
      Left            =   3150
      TabIndex        =   0
      Top             =   3105
      Width           =   1095
   End
   Begin CommandButton CommSetCancel 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   375
      Left            =   4320
      TabIndex        =   1
      Top             =   3105
      Width           =   1095
   End
End
Dim newParity As String
Dim newDataBits As String
Dim newstopBits As String

Dim newCommPort As Integer
Dim newBaudRate As String
Dim newHandShake As Integer

Sub CommSetCancel_Click ()

    'FMain.Enabled = True
    'FMain.SetFocus
    Unload commSettings

End Sub

Sub CommSetOk_Click ()
    Dim curPortState%, rv%

    curConnectType = CT_Async

    curBaudRate = newBaudRate
    curCommPort = newCommPort
    curHandShake = newHandShake

    curParity = newParity
    curDataBits = newDataBits
    curStopBits = newstopBits

    rv = WritePrivateProfileString(Key_Notes, Appl_ConnectType, Str$(curConnectType), DefaultINI)
    rv = WritePrivateProfileString(Key_Async, Appl_CommPort, Str$(curCommPort), DefaultINI)
    rv = WritePrivateProfileString(Key_Async, Appl_HandShake, Str$(curHandShake), DefaultINI)
    rv = WritePrivateProfileString(Key_Async, Appl_BaudRate, curBaudRate, DefaultINI)
    rv = WritePrivateProfileString(Key_Async, Appl_Parity, curParity, DefaultINI)
    rv = WritePrivateProfileString(Key_Async, Appl_Databits, curDataBits, DefaultINI)
    rv = WritePrivateProfileString(Key_Async, Appl_Stopbits, curStopBits, DefaultINI)
    rv = WritePrivateProfileString(Key_Async, Appl_OutBufSize, Str$(asyncOutBufSize), DefaultINI)
    rv = WritePrivateProfileString(Key_Async, Appl_InBufSize, Str$(asyncInBufSize), DefaultINI)
    rv = WritePrivateProfileString(Key_Async, Appl_Interval, Str$(asyncPollInterval), DefaultINI)

    curPortState = FMain.CommPort.PortOpen
    'Cannot set PortOpen property to FALSE unless it's TRUE
    If FMain.CommPort.PortOpen Then
        FMain.CommPort.PortOpen = False
    End If

    FMain.CommPort.Settings = curBaudRate & "," & curParity & "," & curDataBits & "," & curStopBits
    FMain.CommPort.CommPort = curCommPort
    FMain.CommPort.Handshaking = curHandShake
    FMain.StatusPanel.Caption = "COM" & FMain.CommPort.CommPort & ":" & FMain.CommPort.Settings

    'As above, cannot set PortOpen property to FALSE unless it's TRUE
    If curPortState = True Then
        FMain.CommPort.PortOpen = curPortState
    End If

    'FMain.Enabled = True
    'FMain.SetFocus
    Unload commSettings

End Sub

Sub Form_Load ()

    CenterForm commSettings

    Select Case curBaudRate
        Case "19200"
            LBaud192.Value = True
        Case "9600"
            LBaud96.Value = True
        Case "4800"
            LBaud48.Value = True
        Case "2400"
            LBaud24.Value = True
        Case "1200"
            LBaud12.Value = True
        Case Else
            LBaud96.Value = True
            curBaudRate = "9600"
    End Select
    newBaudRate = curBaudRate

    Select Case curCommPort
        Case 1
            LCom1.Value = True
        Case 2
            LCom2.Value = True
        Case 3
            LCom3.Value = True
        Case 4
            LCom4.Value = True
        Case Else
            LCom2.Value = True
            curCommPort = 2
    End Select
    newCommPort = curCommPort
    
    Select Case curHandShake
        Case 1
            LFlowXonXoff.Value = True
        Case 2
            LFlowRtsCts.Value = True
        Case Else
            LFlowNone.Value = True
            curHandShake = 0
    End Select
    newHandShake = curHandShake

    Select Case curParity
        Case "N", "n"
            LParityN.Value = True
        Case "E", "e"
            LParityE.Value = True
        Case "O", "o"
            LParityO.Value = True
        Case "M", "m"
            LParityM.Value = True
        Case "S", "s"
            LParityS.Value = True
        Case Else
            LParityN.Value = True
            curParity = "N"
    End Select
    newParity = curParity

    If curDataBits = "7" Then
        LData7.Value = True
    Else
        LData8.Value = True
        curDataBits = "8"
    End If
    newDataBits = curDataBits

    Select Case curStopBits
        Case "1"
            LStop1.Value = True
        Case "1.5"
            LStop15.Value = True
        Case "2"
            LStop2.Value = True
        Case Else
            LStop1.Value = True
            curStopBits = "1"
    End Select
    newstopBits = curStopBits

End Sub

Sub LBaud12_Click (Value As Integer)

    'If Value Then
    newBaudRate = "1200"

End Sub

Sub LBaud192_Click (Value As Integer)

    'If Value Then
    newBaudRate = "19200"

End Sub

Sub LBaud24_Click (Value As Integer)

    'If Value Then
    newBaudRate = "2400"

End Sub

Sub LBaud48_Click (Value As Integer)

    'If Value Then
    newBaudRate = "4800"

End Sub

Sub LBaud96_Click (Value As Integer)

    'If Value Then
    newBaudRate = "9600"

End Sub

Sub LCom1_Click (Value As Integer)

    'If Value Then
    newCommPort = 1

End Sub

Sub LCom2_Click (Value As Integer)

    'If Value Then
    newCommPort = 2

End Sub

Sub LCom3_Click (Value As Integer)

    'If Value Then
    newCommPort = 3

End Sub

Sub LCom4_Click (Value As Integer)

    'If Value Then
    newCommPort = 4

End Sub

Sub LData7_Click (Value As Integer)

    newDataBits = "7"

End Sub

Sub LData8_Click (Value As Integer)

    newDataBits = "8"

End Sub

Sub LFlowNone_Click (Value As Integer)

    'If Value Then
    newHandShake = 0

End Sub

Sub LFlowRtsCts_Click (Value As Integer)

    'If Value Then
    newHandShake = 2

End Sub

Sub LFlowXonXoff_Click (Value As Integer)

    'If Value Then
    newHandShake = 1

End Sub

Sub LParityE_Click (Value As Integer)

    newParity = "E"
    LData7.Value = True
    newDataBits = "7"

End Sub

Sub LParityM_Click (Value As Integer)

    newParity = "M"
    LData7.Value = True
    newDataBits = "7"

End Sub

Sub LParityN_Click (Value As Integer)

    newParity = "N"
    LData8.Value = True
    newDataBits = "8"

End Sub

Sub LParityO_Click (Value As Integer)

    newParity = "O"
    LData7.Value = True
    newDataBits = "7"

End Sub

Sub LParityS_Click (Value As Integer)

    newParity = "S"
    LData7.Value = True
    newDataBits = "7"

End Sub

Sub LStop1_Click (Value As Integer)

    newstopBits = "1"

End Sub

Sub LStop15_Click (Value As Integer)

    newstopBits = "1.5"

End Sub

Sub LStop2_Click (Value As Integer)

    newstopBits = "2"

End Sub

