VERSION 2.00
Begin Form FCursorBlink 
   Caption         =   "Cursor Blink Setup"
   ClientHeight    =   1920
   ClientLeft      =   3285
   ClientTop       =   2115
   ClientWidth     =   2865
   ClipControls    =   0   'False
   ControlBox      =   0   'False
   Height          =   2385
   Left            =   3195
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   1920
   ScaleWidth      =   2865
   Top             =   1740
   Width           =   3045
   Begin Timer Timer1 
      Enabled         =   0   'False
      Left            =   90
      Top             =   855
   End
   Begin CommandButton CmdCancel 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   330
      Left            =   1845
      TabIndex        =   1
      Top             =   720
      Width           =   780
   End
   Begin CommandButton CmdOK 
      Caption         =   "&Ok"
      Default         =   -1  'True
      Height          =   330
      Left            =   1845
      TabIndex        =   0
      Top             =   225
      Width           =   780
   End
   Begin VScrollBar VScroll1 
      Height          =   1050
      LargeChange     =   200
      Left            =   1170
      Max             =   1100
      Min             =   100
      SmallChange     =   100
      TabIndex        =   2
      Top             =   135
      Value           =   500
      Width           =   240
   End
   Begin PictureBox CursorBox 
      FontTransparent =   0   'False
      Height          =   285
      Left            =   450
      ScaleHeight     =   255
      ScaleWidth      =   120
      TabIndex        =   3
      TabStop         =   0   'False
      Top             =   495
      Width           =   150
   End
   Begin Label BlinksPerSecond 
      BackStyle       =   0  'Transparent
      Caption         =   "0"
      Height          =   240
      Left            =   1845
      TabIndex        =   6
      Top             =   1440
      Width           =   780
   End
   Begin Label LBlinkAmount 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Blinks per second:"
      Height          =   195
      Left            =   135
      TabIndex        =   5
      Top             =   1440
      Width           =   1590
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Sample:"
      Height          =   195
      Left            =   180
      TabIndex        =   4
      Top             =   225
      Width           =   690
   End
End
Option Explicit

Sub CmdCancel_Click ()

    Unload FCursorBlink

End Sub

Sub CmdOK_Click ()
    Dim rv%

    FMain.cursorBlinkTimer.Interval = Timer1.Interval
    rv = WritePrivateProfileString(Key_Pref, Appl_CursorBlink, Str$(FMain.cursorBlinkTimer.Interval \ 100), DefaultINI)
    
    Unload FCursorBlink

End Sub

Sub displaySample ()
    Static blinkOn As Integer

    CursorBox.CurrentX = CursorBox.Width / 2
    CursorBox.CurrentY = CursorBox.Height / 2

    If blinkOn Then
        CursorBox.BackColor = WHITE
        CursorBox.ForeColor = BLACK
        CursorBox.Print " ";
    Else
        CursorBox.BackColor = BLACK
        CursorBox.ForeColor = WHITE
        CursorBox.Print " ";
    End If
    blinkOn = Not blinkOn

End Sub

Sub Form_Activate ()

    Timer1.Interval = FMain.cursorBlinkTimer.Interval
    Timer1.Enabled = True
    If Timer1.Interval = 0 Then
        BlinksPerSecond.Caption = "0.000"
        VScroll1.Value = VScroll1.Max
    Else
        If Timer1.Interval < VScroll1.Min Then
            VScroll1.Value = VScroll1.Min
        Else
            VScroll1.Value = Timer1.Interval
        End If
        BlinksPerSecond.Caption = Format((VScroll1.Max - VScroll1.SmallChange) / VScroll1.Value, "##.000")
    End If

End Sub

Sub Form_Load ()

    CenterForm FCursorBlink
    
End Sub

Sub Timer1_Timer ()

    displaySample

End Sub

Sub VScroll1_Change ()

    If VScroll1.Value = VScroll1.Max Then
        Timer1.Interval = 0
        BlinksPerSecond.Caption = "0.000"
    Else
        Timer1.Interval = VScroll1.Value
        BlinksPerSecond.Caption = Format((VScroll1.Max - VScroll1.SmallChange) / VScroll1.Value, "##.000")
    End If

End Sub

Sub VScroll1_GotFocus ()

    CmdOk.SetFocus

End Sub

