//   AbasicA    1.00.00     9/12/93

#include "windows.h"                                                                    // All Windows programs must include this
#include "AbasicA.h"                                                                     //  This is our private header file

HANDLE hKeyTranslatorTable;                                                     // This is the handle for what Windows calls ACCELERATORS
HANDLE hInst;                                                                              // This handle is to make a copy of hInstance for our use

int PASCAL WinMain(hInstance,hPrevInstance,lpCmdLine,nCmdShow)      // Every program must have one of these
HANDLE hInstance;                                                                     //  This is the handle of the CURRENT instance of the program
HANDLE hPrevInstance;                                                             //  This is the handle of the LAST instance of the program
LPSTR lpCmdLine;                                                                       //  This is a pointer to the command line string
int nCmdShow;                                                                             //  This tells how the user wanted the program to start the window

{   MSG msg;                                                                                //  This is the variable that will hold the window's message
    HWND hwnd;                                                                          //  This is the variable that will hold the window's handle

    if ( !hPrevInstance ) {                                                               //  If there is NOT a previous instance, register the window's class
        WNDCLASS    wc;                                                              //  Variable to hold the window's class info
        wc.style = 0;                                                                        //  Set initial window style
        wc.lpfnWndProc = MainWndProc;                                      //  Set where WinMain's messages get dispatched to
        wc.cbClsExtra = 0;                                                              //  Class extra storage if you need it
        wc.cbWndExtra = 0;                                                           //  window extra if you need it
        wc.hInstance = hInstance;                                                 //  Tells Windows what Instance is registering this window's class
        wc.hIcon = LoadIcon ( hInstance,"MYICON" );                 //  Load an icon to use
        wc.hCursor = LoadCursor ( NULL, IDC_ARROW );            //  Load a cursor to use
        wc.hbrBackground = GetStockObject(WHITE_BRUSH);  //  Load a brush to paint the background
        wc.lpszMenuName = "AbasicAMenu";                               //  Load a menu to use
        wc.lpszClassName = "AbasicAWClass";                            //  What we will call our window's class
        if(!RegisterClass(&wc))                                                        //  If the class doesn't register right for ant reason
            return(FALSE);}                                                              //  Exit and tell Windows to blow it all away

    hInst = hInstance;                                                                          //  Make a copy of hInstance
    hKeyTranslatorTable = LoadAccelerators(hInst,"AbasicAAcc");    //  Load our key translator table
                                                                                                          //  Then create our main window
    hwnd = CreateWindow("AbasicAWClass", "AbasicA", WS_OVERLAPPEDWINDOW, 0, 0, 300, 300, NULL, NULL, hInstance, NULL);
    if(!hwnd)                                                                                         //  If creating the window fails
        return(FALSE);                                                                           //  Exit and tell Windows to blow it all away

    ShowWindow(hwnd,nCmdShow);                                                 //  Now show the window
    UpdateWindow(hwnd);                                                                 //  Update it in case something changed

    while(GetMessage(&msg, NULL, 0, 0)){                                        //  Go get a message from Windows
        if(!TranslateAccelerator(hwnd, hKeyTranslatorTable, &msg)){   //  If NOT a translated message
            TranslateMessage(&msg);                                                     //  Do local translation if any
            DispatchMessage(&msg);}}                                                   //  Then dispatch it to WinMainProc
    return(msg.wParam);}                                                                    //  And send the wParam back to Windows


long FAR PASCAL MainWndProc ( hWnd, message, wParam, lParam )    //  This is where your program does it's work
                                                                                                                   //  By acting on Windows events
HWND hWnd;                                                                                   //  Variable to hold the window's handle (can be one or many)
UINT message;                                                                                  //  Variable to hold the message
WPARAM wParam;                                                                           //  Variable to hold the word paramerter (32 bits in NT)
LPARAM lParam;                                                                               //  Variable to hold the long paramerter

{   FARPROC lpProcAbout;                                                               //  Variable to hold the pointer to the about routine
    switch ( message ) {                                                                      //  Switch the message to check it against our choices
        case WM_COMMAND :                                                           //  If it is a COMMAND message
            switch (LOWORD(wParam)){                                                //  Switch it to check it against our commands

                case IDM_ABOUT :                                                         //  If the user clicked ABOUT
                    lpProcAbout = MakeProcInstance (About, hInst);        //  Have Windows load code and give us a pointer
                    DialogBox (hInst, "AboutBox", hWnd, lpProcAbout);   //  Have Windows display the dialog box
                    FreeProcInstance (lpProcAbout);                                 //  When done have Windows discard it
                    break;                                                                          //  break stop code execution here

                case IDM_EXIT :                                                             //  If the user clicked EXIT
                    DestroyWindow ( hWnd ) ;                                          //  Tell Windows to destroy the window
                    break ;                                                                        //   break ...

                default :                                                                          //  If what the user did a command we don't handle
                    return ( DefWindowProc ( hWnd, message, wParam, lParam ) ) ; }     //  Send it back to Windows
            return (0);                                                                            //  If the program gets here something bad happened
                                                                                         
        case WM_CLOSE :                                                                //  User clicked on the CLOSE in the COMMAND MENU
            DestroyWindow ( hWnd ) ;                                                 //  Tell Windows to destroy the window
            break ;

        case WM_DESTROY :                                                          //  After destroting the window Windows send this
            PostQuitMessage ( 0 ) ;                                                      //  before it destroys our code here
            break ;                                                                                //  If that is what we want, we return a 0

        default :                                                                                               //  If the user did something we don't handle
            return ( DefWindowProc ( hWnd, message, wParam, lParam ) ) ; } //  Send the message back to Windows
    return ( 0 ) ;}                                                                                            //  If it gets here we destroy the thing


BOOL FAR PASCAL About ( hDlg, message, wParam, lParam )     //  The about box code
HWND hDlg ;                                                                                  //  This doesn't do much
unsigned message ;                                                                         //  A message box would do just as well
WORD wParam ;                                                                             //  But the about box is always added to samples
LONG lParam ;                                                                                 //  As an example of how your program should
{   switch ( message ) {                                                                     //  Handle dialog boxes in general

        case WM_INITDIALOG :                                                         //  When Windows fires up a dialog box
            return ( TRUE ) ;                                                                   //  It sends a INIT message so you do special setup
                                                                                                         
        case WM_COMMAND :                                                           //  This works the same as commands
            if ( wParam == IDOK || wParam == IDCANCEL ) {                 //  In your main window
                EndDialog( hDlg, TRUE ) ;                                               //  You handle the responses 
                return ( TRUE ) ; }                                                            //  That you want to here
            return ( TRUE ) ; }                                                                //  OK and CANCEL are it for this one
    return ( FALSE ) ;}

