#ifndef __FILEIO_P_H__
#define __FILEIO_P_H__

extern _VOID_ report_file_error _P_((char *string, Lisp_Object data));
extern Lisp_Object close_file_unwind _P_((Lisp_Object fd));
extern char * file_name_as_directory _P_((char *out, char *in));
extern int directory_file_name _P_((char *src, char *dst));
extern Lisp_Object expand_and_dir_to_file _P_((Lisp_Object filename,
                                               Lisp_Object defdir));
extern _VOID_ barf_or_query_if_file_exists _P_((Lisp_Object absname,
                                                unsigned char *querystring,
                                                int interactive));
extern int e_write _P_((int desc, register char *addr, register int len));
extern Lisp_Object auto_save_error _P_((Lisp_Object dummy));
extern Lisp_Object auto_save_1 _P_((void));
extern _VOID_ syms_of_fileio _P_((void));
    
DEFUN_P(Ffind_file_name_handler, (Lisp_Object filename));
DEFUN_P(Ffile_name_directory, (Lisp_Object file));
DEFUN_P(Ffile_name_nondirectory, (Lisp_Object file));
DEFUN_P(Funhandled_file_name_directory, (Lisp_Object filename));
DEFUN_P(Ffile_name_as_directory, (Lisp_Object file));
DEFUN_P(Fdirectory_file_name, (Lisp_Object directory));
DEFUN_P(Fmake_temp_name, (Lisp_Object prefix));
DEFUN_P(Fexpand_file_name, (Lisp_Object name, Lisp_Object defalt));
DEFUN_P(Fsubstitute_in_file_name, (Lisp_Object string));
DEFUN_P(Fcopy_file, (Lisp_Object filename, Lisp_Object newname,
                     Lisp_Object ok_if_already_exists, Lisp_Object keep_date));
DEFUN_P(Fmake_directory_internal, (Lisp_Object dirname));
DEFUN_P(Fdelete_directory, (Lisp_Object dirname));
DEFUN_P(Fdelete_file, (Lisp_Object filename));
DEFUN_P(Frename_file, (Lisp_Object filename, Lisp_Object newname,
                       Lisp_Object ok_if_already_exists));
DEFUN_P(Fadd_name_to_file, (Lisp_Object filename, Lisp_Object newname,
                            Lisp_Object ok_if_already_exists));
DEFUN_P(Fmake_symbolic_link, (Lisp_Object filename, Lisp_Object linkname,
                              Lisp_Object ok_if_already_exists));
DEFUN_P(Fdefine_logical_name, (Lisp_Object varname, Lisp_Object string));
DEFUN_P(Fsysnetunam, (Lisp_Object path, Lisp_Object name));
DEFUN_P(Ffile_name_absolute_p, (Lisp_Object filename));
DEFUN_P(Ffile_exists_p, (Lisp_Object filename));
DEFUN_P(Ffile_executable_p, (Lisp_Object filename));
DEFUN_P(Ffile_readable_p, (Lisp_Object filename));
DEFUN_P(Ffile_symlink_p, (Lisp_Object filename));
DEFUN_P(Ffile_writable_p, (Lisp_Object filename));
DEFUN_P(Ffile_directory_p, (Lisp_Object filename));
DEFUN_P(Ffile_accessible_directory_p, (Lisp_Object filename));
DEFUN_P(Ffile_modes, (Lisp_Object filename));
DEFUN_P(Fset_file_modes, (Lisp_Object filename, Lisp_Object mode));
DEFUN_P(Fset_default_file_modes, (Lisp_Object mode));
DEFUN_P(Fdefault_file_modes, (void));
DEFUN_P(Funix_sync, (void));
DEFUN_P(Ffile_newer_than_file_p, (Lisp_Object file1, Lisp_Object file2));
DEFUN_P(Finsert_file_contents, (Lisp_Object filename, Lisp_Object visit,
                                Lisp_Object beg, Lisp_Object end));
DEFUN_P(Fwrite_region, (Lisp_Object start, Lisp_Object end,
                        Lisp_Object filename, Lisp_Object append,
                        Lisp_Object visit));
DEFUN_P(Fverify_visited_file_modtime, (Lisp_Object buf));
DEFUN_P(Fclear_visited_file_modtime, (void));
DEFUN_P(Fvisited_file_modtime, (void));
DEFUN_P(Fset_visited_file_modtime, (Lisp_Object time_list));
DEFUN_P(Fdo_auto_save, (Lisp_Object no_message, Lisp_Object current_only));
DEFUN_P(Fset_buffer_auto_saved, (void));
DEFUN_P(Frecent_auto_save_p, (void));
DEFUN_P(Fread_file_name_internal, (Lisp_Object string, Lisp_Object dir,
                                   Lisp_Object action));
DEFUN_P(Fread_file_name, (Lisp_Object prompt, Lisp_Object dir,
                          Lisp_Object defalt, Lisp_Object mustmatch,
                          Lisp_Object initial));
    
#endif
