!include <ntwin32.mak>
#    Copyright (C) 1991, 1992 Aladdin Enterprises.  All rights reserved.
#
# This file is part of Ghostscript.
#
# Ghostscript is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
# to anyone for the consequences of using it or for whether it serves any
# particular purpose or works at all, unless he says so in writing.  Refer
# to the Ghostscript General Public License for full details.
#
# Everyone is granted permission to copy, modify and redistribute
# Ghostscript, but only under the conditions described in the Ghostscript
# General Public License.  A copy of this license is supposed to have been
# given to you along with Ghostscript so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.

# makefile for Ghostscript, MS-DOS MSC 7.0 platform.
# Thanks to Phil Conrad and Thomas Hiller for earlier versions of this file.

# NOTE: Do NOT compile iscan.c or gdevpcfb.c with optimization.

# ------------------------------- Options ------------------------------- #

###### This section is the only part of the file you should need to edit.

# ------ Generic options ------ #

# Define the default directory/ies for the runtime
# initialization and font files.  Separate multiple directories with \;.
# Use / to indicate directories, not a single \.

GS_LIB_DEFAULT=e:/gs\;e:/gs/fonts

# Define the name of the Ghostscript initialization file.
# (There is no reason to change this.)

GS_INIT=gs_init.ps

# Choose generic configuration options.

# Setting DEBUG=1 includes debugging features (-Z switch) in the code.
# Code runs substantially slower even if no debugging switches are set,
# and also takes about another 25K of memory.

#DEBUG=0

# Setting TDEBUG=1 includes symbol table information for the debugger,
# and also enables stack checking.  Code is substantially slower and larger.

TDEBUG=0

# Setting NOPRIVATE=1 makes private (static) procedures and variables public,
# so they are visible to the debugger and profiler.
# No execution time or space penalty, just larger .OBJ and .EXE files.

NOPRIVATE=0

# Define the name of the executable file.

GS=gsnt


# ------ Platform-specific options ------ #

# Define the drive, directory, and compiler name for the Microsoft C files.
# COMP is the full compiler path name (normally \msc\bin\wcc386p).
# LINK is the full linker path name (normally \msc\bin\link).
# CLINK is the compile-and-link utility full path name (normally
#   \msc\bin\link).
# INCDIR contains the include files (normally \msc\include).
# LIBDIR contains the library files (normally \msc\lib).
# Note that INCDIR and LIBDIR are always followed by a \,
#   so if you want to use the current directory, use an explicit '.'.

COMP=e:\mstools\bin\cl386
LINK=e:\mstools\bin\link32
CLINK=e:\mstools\bin\cl386
INCDIR=e:\mstools\h
LIBDIR=e:\mstools\lib

# Define the processor (CPU) type.  Currently the only acceptable value
# is 286.  (386 and 486 should be supported, but MSC apparently doesn't
# provide any way to generate 16-bit code if you tell it you have a
# 32-bit processor.)

CPU_TYPE=486

# Define the math coprocessor (FPU) type.
# Options are -1 (optimize for no FPU), 0 (optimize for FPU present,
# but do not require a FPU), 87, 287, or 387.
# If the CPU type is 486, the FPU type is irrelevant, since the 80486
# CPU includes the equivalent of an 80387 on-chip.
# An xx87 option means that the executable will run only if a FPU
# of that type (or higher) is available: this is NOT currently checked
# at runtime.

FPU_TYPE=0

# ---------------------------- End of options ---------------------------- #

# Define the platform name.

PLATFORM=nt_

# Define the name of the makefile -- used in dependencies.

MAKEFILE=makefile

# Define the ANSI-to-K&R dependency.  Microsoft C accepts ANSI syntax,
# but we need to preconstruct ccf.tr to get around the limit on
# the maximum length of a command line.

AK=ccf.tr

# Define the extensions for the object and executable files.

OBJ=obj
XE=.exe

# Define the current directory prefix, shell quote string, and shell name.

EXPP=
QQ="\"
SH=
SHP=

# Define the generic compilation flags.

PLATOPT=

INTASM=
PCFBASM=

# Define the generic compilation rules.

.asm.obj:
	$(ASM) $(ASMFLAGS) $<;

# Make sure we get the right default target for make.

all: $(AK) echogs$(XE) genarch$(XE) genconf$(XE) $(GS)$(XE)

# Define the compilation flags.

!if $(CPU_TYPE)>400
CPFLAGS=/G4
!else
!if $(CPU_TYPE)>300
CPFLAGS=/G3
!else
!if $(CPU_TYPE)>200
CPFLAGS=/G2
!else
!if $(CPU_TYPE)>100
CPFLAGS=/G1
!else
CPFLAGS=/G0
!endif
!endif
!endif
!endif

DEFS = -D_X86_=1 -D_CRTAPI1=__cdecl -D_CRTAPI2=__cdecl -Dtry=__try \
       -Dleave=__leave -Dexcept=__except -Dfinally=__finally -DWIN32 \
       -DCHECK_INTERRUPTS -DNOSYSTIME

FPFLAGS=/Gdfy $(DEFS)

!if $(NOPRIVATE)!=0
CP=/DNOPRIVATE
!else
CP=
!endif

!if $(TDEBUG)!=0
CD=/DDEBUG
!else
CD=
!endif

!if $(TDEBUG)!=0
CT=/Zi /Od
LCT=
!else
CT=
LCT=
!endif

GENOPT=$(CP) $(CD) $(CT) $(CS) /W2 /nologo

CCFLAGS=$(PLATOPT) $(FPFLAGS) $(CPFLAGS)
CC=$(COMP) /c $(cdebug) $(CCFLAGS) @ccf.tr
CCL=$(CLINK)
CCC=$(CC) /Za
CCCE=$(CC)
CCD=$(CC) /Za
CCINT=$(CC) /Za

.c.obj:
	$(CCC) $<

# Define the files to be removed by `make clean'.
# nmake expands macros when encountered, not when used,
# so this must precede the !include statements.


# -------------------------- Auxiliary programs --------------------------- #

ccf.tr: $(MAKEFILE)
        touch ccf.tr

echogs$(XE): echogs.c
	$(CCL) $(CCFLAGS) echogs.c setargv.obj binmode.obj $(conlibs)

genarch$(XE): genarch.c
	$(CCL) $(CCFLAGS) genarch.c setargv.obj binmode.obj $(conlibs)

genconf$(XE): genconf.c
	$(CCL) $(CCFLAGS) genconf.c setargv.obj binmode.obj $(conlibs)

# ------ Devices and features ------ #

# Choose the language feature(s) to include.  See gs.mak for details.
# Since we have a large address space, we include the optional features.

FEATURE_DEVS=filter.dev dps.dev level2.dev

# Choose the device(s) to include.  See devs.mak for details.
DEVICE_DEVS=mswin.dev mswinprn.dev
DEVICE_DEVS3=deskjet.dev djet500.dev laserjet.dev ljetplus.dev ljet2p.dev ljet3.dev
DEVICE_DEVS4=cdeskjet.dev cdjcolor.dev cdjmono.dev cdj550.dev paintjet.dev pjetxl.dev
DEVICE_DEVS5=epson.dev eps9high.dev ibmpro.dev bj10e.dev
DEVICE_DEVS7=bmpmono.dev bmp16.dev bmp256.dev bmp16m.dev
DEVICE_DEVS8=gifmono.dev gif8.dev bit.dev

!include gs.mak
!include devs.mak

# -------------------------------- Library -------------------------------- #

# The Microsoft C platform

# Eventually we need a gp_imsc.$(OBJ)....
nt__= gp_mswin.$(OBJ) gp_mswtx.$(OBJ) gp_nofb.$(OBJ) gp_nt.$(OBJ)
nt_.dev: $(nt__)
	$(SHP)gssetmod nt_ $(nt__)

gp_nt.$(OBJ): gp_nt.c $(string__h) $(gx_h) $(gp_h)

gp_mswtx.$(OBJ): gp_mswtx.c $(AK) gp_mswtx.h
	$(CCCE) $*.c

gp_dosfb.$(OBJ): gp_dosfb.c $(memory__h) $(gx_h) $(gp_h) $(gserrors_h) $(gxdevice_h)

gp_mswin.$(OBJ): gp_mswin.c $(dos__h) $(string__h) $(gx_h) $(gp_h)
	$(CCCE) $*.c

gdevmswn.$(OBJ): gdevmswn.c
	$(CCCE) $*.c

gdevmsxf.$(OBJ): gdevmsxf.c
	$(CCCE) $*.c

gdevwdib.$(OBJ): gdevwdib.c
	$(CCCE) $*.c

gdevwddb.$(OBJ): gdevwddb.c
	$(CCCE) $*.c

gdevwprn.$(OBJ): gdevwprn.c
	$(CCCE) $*.c



# ----------------------------- Main program ------------------------------ #

BEGINFILES=gs*.res gs*.ico
CCBEGIN=$(CCC) *.c

LIBDOS=$(LIBGS) obj.tr

# Interpreter main program

ICONS=gsgraph.ico gstext.ico

GS_ALL=$(ICONS) $(GS).rbj gs.$(OBJ) $(INT) $(INTASM) gsmain.$(OBJ) \
  $(LIBDOS) $(LIBCTR) obj.tr lib.tr $(GS).res $(GS).def

# Make the icons from their text form.

gsgraph.ico: gsgraph.icx echogs$(XE)
        echogs -wb gsgraph.ico -n -X -r gsgraph.icx

gstext.ico: gstext.icx echogs$(XE)
        echogs -wb gstext.ico -n -X -r gstext.icx

$(GS).res: $(GS).rc gp_mswin.h $(ICONS)
        $(rc) $(rcvars) -r $(GS).rc

$(GS).rbj: $(GS).res
    cvtres -$(CPU) $(GS).res -o $(GS).rbj

$(GS)$(XE): $(GS_ALL) $(ALL_DEVS)
        -copy obj.tr+gsnt.tr ln.tr
        $(link) $(ldebug) $(guiflags) -out:$@ -machine:$(CPU) @ln.tr \
        $(GS).rbj binmode.obj $(guilibs) shell32.lib
