#include <stdio.h>
#include <stdlib.h>
#include <winsock.h>


 void disp_help()

  {

   printf("\nGet host name program V 1.0 by L. Kahn (C) 1994\n");
   printf("_______________________________________________\n\n");
   printf("Syntax: ghostname hostname \n");
   printf("WHERE: hostname is the name or ip address of a host.\n\n");
  }


  void main(argc,argv)
  
  int argc;
  char **argv;
   
  {


  WORD wVersionrequired;
  WSADATA WSData;
  char remotename[80];
  static struct sockaddr_in destination;
  static struct hostent *ptrhostentry;
  LPSTR plpstr;
  struct in_addr *pin_addr;
  int rval = 0;
   
   wVersionrequired = MAKEWORD(1,1);
   if (argc != 2)
     disp_help();

   else
   {
     /* ok assume second arg is host name */
  
  rval = WSAStartup(wVersionrequired, &WSData);
  if (rval != 0)
     {
      printf("Startup ERROR: could not find a usable a winsock DLL.\n");
      fflush(stdout);
      exit(1);
	 }

   if (LOBYTE(WSData.wVersion) != 1 || HIBYTE(WSData.wVersion) != 1)
      {
	   printf("Startup ERROR: could not find a winsock DLL version 1.1 or newer.\n");
	   fflush(stdout);
	   exit(1);
	  }

  else
   {
		  strcpy(remotename,argv[1]);
          memset(&destination,0,sizeof(struct sockaddr));
          destination.sin_family=AF_INET;

          destination.sin_addr.s_addr = inet_addr(remotename);
          if(destination.sin_addr.s_addr ==INADDR_NONE)
             {
              ptrhostentry = gethostbyname(remotename);
              if (ptrhostentry == NULL)
                {
                  printf("can't get entry for host name: %s\n",remotename);
	              fflush(stdout);
				  WSACleanup();
                  exit(1);
                }
              }
          else
             {
               ptrhostentry = gethostbyaddr((LPSTR)&destination.sin_addr.s_addr,4,PF_INET);
               if (ptrhostentry == NULL)
                 {
                   printf("can't get ip entry for host name: %s\n",remotename);
				   fflush(stdout);
				   WSACleanup();
                   exit(1);
                 }
             }
             
            /* if we get here we have valid entry so do it */

              memcpy(&destination.sin_addr,ptrhostentry->h_addr,ptrhostentry->h_length);
              printf("Translated Name is: %s\n",ptrhostentry->h_name);

              while((pin_addr=(struct in_addr *)*(ptrhostentry->h_addr_list))!=NULL)
                 {
                  printf("IP Address is     : %s",inet_ntoa(*pin_addr));
                  ptrhostentry->h_addr_list++;
                }
              
              while((plpstr=(LPSTR)*(ptrhostentry->h_aliases))!=NULL)
                {
                 printf("Alias: %s",plpstr);
                 ptrhostentry->h_aliases++;
                }
          } /* end of ok startup */
	   } /* end of ok parameters */

	 printf("\n");
	 fflush(stdout);
	 WSACleanup();

  } /* end of main */          


