@echo off

REM Give help if needed
if "%1" == "/?" goto LHelp
if "%1" == "-?" goto LHelp
if "%1" == "-help" goto LHelp
if "%1" == "-HELP" goto LHelp
if "%1" == "/help" goto LHelp
if "%1" == "/HELP" goto LHelp

REM Check that we are running under NT
if "%WinDir%" == "" goto ENotNT
if "%username%" == "" goto ENotNT

REM Hello mesage
echo Logitech mouse drivers installation.
echo This batch file installs a Windows NT BUS and Serial mouse drivers.
echo To get help, type: INSTALL /help
echo Press Ctrl-C to stop or ...
pause

REM Start the installation
echo Start installation

set _DRVINI=install.ini
if not exist regmod.exe goto ENoReg
if not exist %_DRVINI% goto ENoINI

REM Check and set the environment
set _DRIVER=BusMouse.sys
set _DRVBAK=BusMouse.bak
set _DRVDIR=%WinDir%\system\drivers
if not %_DRVDIR% == %WinDir%\system\drivers goto ENoEnv
if not exist copydrv.bat goto ENoCopy
call copydrv.bat

REM Check and set the environment
set _DRIVER=SerMouse.sys
set _DRVBAK=SerMouse.bak
set _DRVDIR=%WinDir%\system\drivers
if not %_DRVDIR% == %WinDir%\system\drivers goto ENoEnv
if not exist copydrv.bat goto ENoCopy
call copydrv.bat

REM Update the registry
echo Updating the registry
regmod %_DRVINI% > NUL
echo Registry updated

REM Cleanup
set _DRIVER=
set _DRVINI=
set _DRVBAK=
set _DRVDIR=

REM Goodbye
echo Installation completed.
goto End

:ENoCopy
echo ERROR: Cannot find CopyDrv.bat file.
goto End

:ENoEnv
echo ERROR: Not enough environment space.
goto End

:ENotNT
echo ERROR: This batch file must be run under Windows NT
goto End

:ENoReg
echo ERROR: Cannot access the RegMod.exe file.
goto End

:ENoINI
echo ERROR: Cannot find the %_DRVINI% file.
goto End

:LHelp
type readme.txt | more

:End
