/* processor benchmark using multiple threads */



#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <time.h>
#include <process.h>
#include <string.h>
#include <direct.h>
#include <errno.h>

#include <fcntl.h>
#include <stdarg.h>
#include <malloc.h>

#define maxthreads 8

DWORD threadid[maxthreads];
HANDLE threadhandle[maxthreads];
DWORD ProcAff;
DWORD SysAff;
DWORD ThdAff;

double float_counters[maxthreads];
double int_counters[maxthreads];
DWORD float_thread_start_time[maxthreads];
DWORD int_thread_start_time[maxthreads];
DWORD float_thread_stop_time[maxthreads];
DWORD int_thread_stop_time[maxthreads];
BOOLEAN setprocessoraffinity = FALSE;
BOOLEAN assignedpaffin[maxthreads] = {FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE };
DWORD paffinarray[maxthreads] = { 0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 };

DWORD intstarttime, intstoptime, floatstarttime, floatstoptime;
int totaltime;


int noprocessors = 0;
int availprocessors = 0;

int number_of_processors(affin)
DWORD affin;

{
   
  int numprocessors = 0;

  // return the number of processors based on the system affinity dword
  // each bit represents a processor
  // ie 00000011 = 3 = 2 processors 
  if (affin == 0x0001)
    numprocessors = 1;
  else if (affin == 0x0003)
	 numprocessors = 2;
  else if (affin == 0x0007)
     numprocessors = 3;
  else if (affin == 0x000F)
     numprocessors = 4;
  else if (affin == 0x001F)
     numprocessors = 5;
  else if (affin == 0x003F)
     numprocessors = 6;
  else if (affin == 0x007F)
     numprocessors = 7;
  else if (affin == 0x00FF)
     numprocessors = 8;
  else if (affin == 0x01FF)
     numprocessors = 9;
  else if (affin = 0x03FF)
     numprocessors == 10;
  else if (affin = 0x07FF)
     numprocessors = 11;
  else if (affin == 0x0FFF)
     numprocessors = 12;
  else if (affin == 0x1FFF)
     numprocessors = 13;
  else if (affin == 0x3FFF)
     numprocessors = 14;
  else if (affin == 0x7FFF)
     numprocessors = 15;
   else if (affin == 0xFFFF)
     numprocessors = 16;

else 

  {
    printf("ERROR: Illegal processor affinity mask = %x defaulting to 1 processor. \n",affin);
 	fflush(stdout);
	numprocessors = 1;
  }

  
return numprocessors;

}

void set_thread_to_processor(thnd,processorno,threadno)
HANDLE thnd;
int processorno;
int threadno;

{

  DWORD affinmask = 0;
 DWORD ThdAff = 0;


  // override if set thread individually
  if (assignedpaffin[threadno])
    {
	 printf("Setting thread number %d with Affinity mask %ld \n",threadno,paffinarray[threadno]);
	 fflush(stdout);
	 
     ThdAff = SetThreadAffinityMask( thnd,paffinarray[threadno]);
     if ( !ThdAff )
      printf( "SetThreadAffinityMask(%ld) failed\n\n",paffinarray[threadno] );
     else printf( "Previous thread affinity %x\n\n", ThdAff );
     fflush(stdout);
	}

   else

    {

  printf("Setting thread number %d to only run on processor %d \n",threadno,processorno);
  fflush(stdout);

  switch (processorno)
   	   {
	     case 1:
		  affinmask = (DWORD)1;
		  break;
		 
		 case 2:
		  affinmask = (DWORD)1 << 1;
		  break;
         
         case 3:
		  affinmask = (DWORD)1 << 2;
		  break;

         case 4:
		  affinmask = (DWORD)1 << 3;
		  break;

         case 5:
		  affinmask = (DWORD)1 << 4;
		  break;

	     case 6:
		  affinmask = (DWORD)1 << 5;
		  break;
		 
		 case 7:
		  affinmask = (DWORD)1 << 6;
		  break;
         
         case 8:
		  affinmask = (DWORD)1 << 7;
		  break;

  

		 default: printf("Illegal processor number %d in set thread to processor\n",processorno);
		          printf("Defaulting to processor 1 \n");
				  fflush(stdout);
				  affinmask = 1 << 1;


		}

	 // now set the thing

   ThdAff = SetThreadAffinityMask( thnd,affinmask);
if ( !ThdAff )
      printf( "SetThreadAffinityMask(%ld) failed\n\n",affinmask );
   else printf( "Previous thread affinity %x\n\n", ThdAff );
   fflush(stdout);
  }
 }	

 
float flops(threadid)
  float threadid;

  {

    return ((float)threadid * (float)2.234556);

   }
 
int iops(threadid)
  int threadid;

  {

    return (threadid * 25);

   }

 
DWORD thread1_float()

{
  float a;
  float_counters[1] = 0;
  float_thread_start_time[1] = GetTickCount();
  while (1)
    {
	  a = flops(1.1);
	  ++float_counters[1];
	}
 return 0;

}

DWORD thread1_int()

{
  int a;
  int_counters[1] = 0;
  int_thread_start_time[1] = GetTickCount();
  while (1)
    {
	  a = iops(1);
	  ++int_counters[1];
	}
 return 0;

}


DWORD thread2_float()

{
  float a;
  float_counters[2] = 0;
  float_thread_start_time[2] = GetTickCount();
  while (1)
    {
	  a = flops(1.2);
	  ++float_counters[2];
	}
 return 0;

}

DWORD thread2_int()

{
  int a;
  int_counters[2] = 0;
  int_thread_start_time[2] = GetTickCount();
  while (1)
    {
	  a = iops(2);
	  ++int_counters[2];
	}
 return 0;

}

DWORD thread3_float()

{
  float a;
  float_counters[3] = 0;
  float_thread_start_time[3] = GetTickCount();
  while (1)
    {
	  a = flops(1,3);
	  ++float_counters[3];
	}
 return 0;

}

DWORD thread3_int()

{
  int a;
  int_counters[3] = 0;
  int_thread_start_time[3] = GetTickCount();
  while (1)
    {
	  a = iops(1);
	  ++int_counters[3];
	}
 return 0;

}

DWORD thread4_float()

{
  float a;
  float_counters[4] = 0;
  float_thread_start_time[4] = GetTickCount();
  while (1)
    {
	  a = flops(1.4);
	  ++float_counters[4];
	}
 return 0;

}

DWORD thread4_int()

{
  int a;
  int_counters[4] = 0;
  int_thread_start_time[4] = GetTickCount();
  while (1)
    {
	  a = iops(4);
	  ++int_counters[4];
	}
 return 0;

}

DWORD thread5_float()

{
  float a;
  float_counters[5] = 0;
  float_thread_start_time[5] = GetTickCount();
  while (1)
    {
	  a = flops(1.5);
	  ++float_counters[5];
	}
 return 0;

}

DWORD thread5_int()

{
  int a;
  int_counters[5] = 0;
  int_thread_start_time[5] = GetTickCount();
  while (1)
    {
	  a = iops(5);
	  ++int_counters[5];
	}
 return 0;

}

DWORD thread6_float()

{
  float a;
  float_counters[6] = 0;
  float_thread_start_time[6] = GetTickCount();
  while (1)
    {
	  a = flops(1.6);
	  ++float_counters[6];
	}
 return 0;

}

DWORD thread6_int()

{
  int a;
  int_counters[6] = 0;
  int_thread_start_time[6] = GetTickCount();
  while (1)
    {
	  a = iops(6);
	  ++int_counters[6];
	}
 return 0;

}

DWORD thread7_float()

{
  float a;
  float_counters[7] = 0;
  float_thread_start_time[7] = GetTickCount();
  while (1)
    {
	  a = flops(1.7);
	  ++float_counters[7];
	}
 return 0;
}

DWORD thread7_int()

{
  int a;
  int_counters[7] = 0;
  int_thread_start_time[7] = GetTickCount();
  while (1)
    {
	  a = iops(7);
	  ++int_counters[7];
	}
 return 0;

}

DWORD thread0_float()

{
  float a;
  float_counters[0] = 0;
  float_thread_start_time[0] = GetTickCount();
  while (1)
    {
	  a = flops(1.0);
	  ++float_counters[0];
	}
 return 0;

}

DWORD thread0_int()

{
  int a;
  int_counters[0] = 0;
  int_thread_start_time[0] = GetTickCount();
  while (1)
    {
	  a = iops(1);
	  ++int_counters[0];
	}
 return 0;

}

/* ----------------------------------------------------------- */

void report_results(timespan,threadcount)
  int timespan;
  int threadcount;
  {

  DWORD totaltime = 0;
  DWORD localtime = 0;
  double totalcount = 0;
  double localcount = 0;
  int i;

   
     printf("Floating point results for %d milliseconds with %d thread(s).\n",timespan,threadcount);
	 printf("______________________________________________________________\n\n");

	 for (i=0; i<threadcount; i++)
	   {
	    printf("Thread %d ---->\n",i);
		printf("                Start time = %u End time = %u \n",float_thread_start_time[i],
		        float_thread_stop_time[i]);
		
		localtime = float_thread_stop_time[i] - float_thread_start_time[i];
		localcount = float_counters[i];

		printf("                Total time = %u Milliseconds, Operations = %.0lf \n",localtime,localcount);
		printf("                Float Ops/Second = %10.4lf \n",(double)(localcount / (double)localtime) * (double)1000);
		fflush(stdout);

		totaltime = floatstoptime - floatstarttime;
		totalcount = totalcount + localcount;

	    }

	  // now do overall totals


	  printf("Overall Total time = %u Operations = %.0lf \n",totaltime,totalcount);
	  printf("Overall Float Ops Second = %10.4lf \n",(double)(totalcount / (double)totaltime) * (double)1000);
		 

	   // reset totals and do integer ops
	   totaltime = 0;
	   totalcount = 0;

	 printf("\n\nInteger results for %d milliseconds with %d thread(s).\n",timespan,threadcount);
	 printf("______________________________________________________________\n\n");

	 for (i=0; i<threadcount; i++)
	   {
	    printf("Thread %d ---->\n",i);
		printf("                Start time = %u End time = %u \n",int_thread_start_time[i],
		        int_thread_stop_time[i]);
		
		localtime = int_thread_stop_time[i] - int_thread_start_time[i];
		localcount = int_counters[i];

		printf("                Total time = %u Operations = %.0lf \n",localtime,localcount);
		printf("                Integer Ops/Second = %10.4lf \n",(double)(localcount / (double)localtime) * (double)1000);
		fflush(stdout);

		totaltime = intstoptime - intstarttime;
		totalcount = totalcount + localcount;

	    }

	  // now do overall totals

 	  printf("Overall total time = %u Operations = %.0lf \n",totaltime,totalcount);
	  printf("Overall Integer Ops Second = %10.4lf \n",(double)(totalcount / (double)totaltime) * (double)1000);

      fflush(stdout);		
  }

/* --------------------------------------------------------------------- */


void main(argc,argv)
int argc;
char **argv;

{
   int current_arg = 1;
   BOOLEAN more_args = TRUE;
   BOOLEAN done = FALSE;
   int i;
   int threadcount = 1;

   // default time is ten seconds
   totaltime = 5000;
   if (argc > 1)
     {
   /* process arguments */
   if (argv[current_arg][0] != '-')
     {
      printf("Illegal parms \n");
      fflush(stdout);
      exit(1);
	 }
   else
		
    do 
     {
      /* get the first one and if it doesn't start with a - we have a problem */
		
       switch (argv[current_arg][1])
           {

				 // assign paffin value 
				  case 'v':
				  if (argc < (current_arg + 3))
				    {
				      printf("ERROR: Two Parameters needed for Affinity assignment Thread followed by value \n");
					  fflush(stdout);
					  exit(1);
				    }
				   else
				     {
					
						int tid = atoi(argv[current_arg + 1]);
				        DWORD affin = (DWORD)atol(argv[current_arg + 2]);
						int i = 0;

					    if ((affin < 0x0001) || (affin > 0x01FF))
						  {
						   printf("ERROR: Affinity value must be between 0x0001 and 0x01FF. \n");
						   fflush(stdout);
						   exit(1);
						  }

					    
						if (strncmp(argv[current_arg + 1],"*",1) == 0)
						   {
					  		  for (i=0; i<maxthreads; i++)
					  		    {
					  		     paffinarray[i] = affin;
								 assignedpaffin[i] = TRUE;
								}
						   }

						else if ((tid <1) || (tid > 8))
					     {
						   printf("ERROR: Thread value must be between 1 and 8. \n");
						   fflush(stdout);
						   exit(1);
						  }
						else // only affin 1 thread 
						  {
						   paffinarray[tid] = affin;
						   assignedpaffin[tid] = TRUE;
						  }
						        
					   current_arg = current_arg + 2;
					}
				   break;

                 case 's':
				  if (argc < (current_arg + 2))
				    {
				      printf("ERROR: Parameter needed for time value. \n");
					  fflush(stdout);
					  exit(1);
				    }
				   else
				     {
				        totaltime = atoi(argv[current_arg + 1]);
					    ++current_arg;
					}
				   break;

				  case 't':
				    if (argc < (current_arg + 2))
					  {
					    printf("ERROR: Parameter needed for thread count value. \n");
						fflush(stdout);
						exit(1);
					  }
					else
					  {
					   threadcount = atoi(argv[current_arg + 1]);
					   if ((threadcount <1) || (threadcount > 8))
					     {
						   printf("ERROR: Thread count must be between 1 and 8 \n");
						   fflush(stdout);
						   exit(1);
						  }
						else ++current_arg;
					   }
					  break;

					case 'a':
					  /* set threads to only run on 1 processor this will help determine
					  if all processors are working if not certain threads will be starved */

					  setprocessoraffinity = TRUE;
					  break;
					  
					default: break;

	} /* end of switch */
						 
			   
    ++current_arg;
	if (current_arg >= argc)
	  more_args = FALSE;

    } while ((!done) && (more_args));
   
   } 
   /* initialize */

   
     printf("NT Multiprocessor Benchmark by L. Kahn (C) 1994 \n");
     printf("_________________________________________________\n\n");
     printf("Default time to run threads is %d milliseconds with %d Simultaneous Thread(s).\n",
       (int)totaltime,threadcount);
	 
   if (!GetProcessAffinityMask( GetCurrentProcess(), &ProcAff, &SysAff) )
     {
       printf( "ERROR: GetProcessAffinityMask failed, defaulting to 1 processor\n\n" );
       noprocessors = 1;
	   availprocessors = 1;
	 }

   else
      {
        printf( "System Affinity = %x\nProcess affinity = %x\n", SysAff, ProcAff );
		noprocessors = number_of_processors(SysAff);
	    availprocessors = number_of_processors(ProcAff);
	  
	    printf("Number of processors reported = %d \n",noprocessors);
		printf("Number of available processors reported = %d \n\n",availprocessors);
	    fflush(stdout);
	  }

	 if (setprocessoraffinity)
	   {
	    int i = 0;
	    printf("Each thread will be assigned to run ONLY on each sequential processor, or\n");
		printf("on a particular set of processors if the default values have been overridden\n");
		printf("with the -v option.  If you run more threads than you have processors the \n");
		printf("additional threads will run on all the processors.\n");
		printf("By assiging threads to particular processors (that exist in your machine) you \n");
		printf("can determine if they are working properly.\n");
		printf("The following threads have the affinity mask overridden with the following values: \n");

		for (i=0; i<threadcount; i++)
		  {
		   if (assignedpaffin[i])
		     {
			  printf(" -->  Thread %d will be assigned affinity of %ld\n",i,paffinarray[i]);
			  fflush(stdout);
			 }
		   }
	  }  

   /* now create the threads to calculate the flops */
	printf("Starting Floating Point pass.\n");
	fflush(stdout);

	for (i=0; i<threadcount; i++)
	   {
	     float_thread_start_time[i] = 0;
		 float_thread_stop_time[i] = 0;
		 float_counters[i] = 0;
		

	  switch (i)
	    {
	    
	    case 0:
	   threadhandle[0] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)thread0_float,NULL,CREATE_SUSPENDED,&threadid[0]);
        break;

        case 1:
       threadhandle[1] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)thread1_float,NULL,CREATE_SUSPENDED,&threadid[0]);
	    break;

	    case 2:
	   threadhandle[2] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)thread2_float,NULL,CREATE_SUSPENDED,&threadid[0]);
        break;

        case 3:
       threadhandle[3] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)thread3_float,NULL,CREATE_SUSPENDED,&threadid[0]);
	    break;

	    case 4:
	   threadhandle[4] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)thread4_float,NULL,CREATE_SUSPENDED,&threadid[0]);
        break;

        case 5:
       threadhandle[5] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)thread5_float,NULL,CREATE_SUSPENDED,&threadid[0]);
	    break;

	    case 6:
	   threadhandle[6] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)thread6_float,NULL,CREATE_SUSPENDED,&threadid[0]);
        break;

        case 7:
       threadhandle[7] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)thread7_float,NULL,CREATE_SUSPENDED,&threadid[0]);
		break;
	
	  default: break;

	}			// end of switch

 } // end of loop

	  /* now that the threads are created start them up */
	  floatstarttime = GetTickCount();
	  for (i=0; i<threadcount; i++)
	    
	    {

		  if (setprocessoraffinity)
		    set_thread_to_processor(threadhandle[i],i+1,i);

	    ResumeThread(threadhandle[i]);
		
		}

  	 /* now sleep for the required time */
	 Sleep(totaltime);

	 /* now kill the threads setting stop time for each */
	 for (i=0; i<threadcount; i++)
	   {
	     TerminateThread(threadhandle[i],1);
		 float_thread_stop_time[i] = GetTickCount();
	   }
 	floatstoptime = GetTickCount();

 /* now do the calcs for integer operations */
    printf("Starting Integer pass.\n");
	fflush(stdout);

 	for (i=0; i<threadcount; i++)
	   {
		 int_thread_start_time[i] = 0;
		 int_thread_stop_time[i] = 0;
		 int_counters[i] = 0;
		

	  switch (i)
	    {
	    
	    case 0:
	   threadhandle[0] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)thread0_int,NULL,CREATE_SUSPENDED,&threadid[0]);
        break;

        case 1:
       threadhandle[1] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)thread1_int,NULL,CREATE_SUSPENDED,&threadid[0]);
	    break;

	    case 2:
	   threadhandle[2] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)thread2_int,NULL,CREATE_SUSPENDED,&threadid[0]);
        break;

        case 3:
       threadhandle[3] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)thread3_int,NULL,CREATE_SUSPENDED,&threadid[0]);
	    break;

	    case 4:
	   threadhandle[4] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)thread4_int,NULL,CREATE_SUSPENDED,&threadid[0]);
        break;

        case 5:
       threadhandle[5] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)thread5_int,NULL,CREATE_SUSPENDED,&threadid[0]);
	    break;

	    case 6:
	   threadhandle[6] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)thread6_int,NULL,CREATE_SUSPENDED,&threadid[0]);
        break;

        case 7:
       threadhandle[7] = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)thread7_int,NULL,CREATE_SUSPENDED,&threadid[0]);
		break;
	
	  default: break;

	}			// end of switch

 } // end of loop

	  /* now that the threads are created start them up */
	  /* now that the threads are created start them up */
	  intstarttime = GetTickCount();
	  for (i=0; i<threadcount; i++)
	    
	    {

		  if (setprocessoraffinity)
		    set_thread_to_processor(threadhandle[i],i+1,i);

	    ResumeThread(threadhandle[i]);
		
		}
  
  	 /* now sleep for the required time */
	 Sleep(totaltime);

	 /* now kill the threads setting stop time for each */
	 for (i=0; i<threadcount; i++)
	   {
	     TerminateThread(threadhandle[i],1);
		 int_thread_stop_time[i] = GetTickCount();
	   }
   
       intstoptime = GetTickCount();

 // now report results

 report_results(totaltime,threadcount);

}






 
