// celltype.cpp : implementation file
//

#include "stdafx.h"
#include "mfcdemo.h"
#include "celltype.h" 
#include "demotbl.h"        
#include "cktbl.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCellTypeDialog dialog


CCellTypeDialog::CCellTypeDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CCellTypeDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCellTypeDialog)
	m_AutoGrow = FALSE;
	m_TabOnTextLimit = FALSE;
	m_TextLimit = 0;
	m_VScroll = FALSE;
	m_WordBreak = FALSE;
	m_HasTextlimit = -1;
	//}}AFX_DATA_INIT
}

void CCellTypeDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCellTypeDialog)
	DDX_Control(pDX, IDC_FORMAT_VALIGN, m_VAlign);
	DDX_Control(pDX, IDC_FORMAT_TYPE, m_Type);
	DDX_Control(pDX, IDC_FORMAT_HALIGN, m_HAlign);
	DDX_Check(pDX, IDC_FORMAT_AUTOGROW, m_AutoGrow);
	DDX_Check(pDX, IDC_FORMAT_TABONTEXTLIMIT, m_TabOnTextLimit);
	DDX_Text(pDX, IDC_FORMAT_TEXTLIMIT, m_TextLimit);
	DDV_MinMaxInt(pDX, m_TextLimit, 0, 32767);
	DDX_Check(pDX, IDC_FORMAT_VSCROLL, m_VScroll);
	DDX_Check(pDX, IDC_FORMAT_WORDBREAK, m_WordBreak);
	DDX_Radio(pDX, IDC_FORMAT_TEXTLIMIT_NONE, m_HasTextlimit);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCellTypeDialog, CDialog)
	//{{AFX_MSG_MAP(CCellTypeDialog)
	ON_BN_CLICKED(IDC_APPLY, OnApply)
	ON_BN_CLICKED(IDC_FORMAT_TEXTLIMIT_LIMIT, OnFormatTextlimitLimit)
	ON_BN_CLICKED(IDC_FORMAT_TEXTLIMIT_NONE, OnFormatTextlimitNone)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

              
              
/////////////////////////////////////////////////////////////////////////////
// CCellTypeDialog public protocol

void CCellTypeDialog::InitializeFrom( CDemoTableControl * aCKTBL )
{
	int row, col;
	     
	// retrieve attributes of current cell	   
	     
	cktbl = aCKTBL; 
	row = cktbl->GetCurrentRow();
	col = cktbl->GetCurrentColumn();
	cktbl->GetAttr( row, col, &attrib );

	// rest	
	
	m_AutoGrow = (attrib.format & (CKTBL_FMT_VGROW|CKTBL_FMT_VSHRINK))!=0;
	m_WordBreak = (attrib.format & CKTBL_FMT_WORDBREAK)!=0;
	m_VScroll = (attrib.format & CKTBL_FMT_VSCROLL)!=0; 
	   
	m_HasTextlimit = (attrib.format&CKTBL_FMT_TEXTLIMIT) ? 1 : 0; 	                                                        
	m_TextLimit =  (attrib.format&CKTBL_FMT_TEXTLIMIT) ? attrib.textLimit : 0;	                                                        
	m_TabOnTextLimit = (attrib.format & CKTBL_FMT_TABONLIMIT)!=0;
}    

void CCellTypeDialog::ApplyData()
{
	// TODO: Add your control notification handler code here
    
    DWORD	mask=0, value=0;
    
	mask |= CKTBL_MASK_HALIGN;
    switch(m_HAlign.GetCurSel()) {
    	case 0: value|=CKTBL_FMT_LEFT; break;
	   	case 1: value|=CKTBL_FMT_CENTER; break;
 	  	case 2: value|=CKTBL_FMT_RIGHT; break;  
 	}
 	
	mask |= CKTBL_MASK_VALIGN;
    switch(m_HAlign.GetCurSel()) {
    	case 0: value|=CKTBL_FMT_TOP; break;
	   	case 1: value|=CKTBL_FMT_BOTTOM; break;  
 	}
 	
    mask |= CKTBL_MASK_CELLTYPE;
    switch(m_Type.GetCurSel()) {
    	case 0: value|=CKTBL_FMT_SINGLE_LINE; break;
	   	case 1: value|=CKTBL_FMT_MULTI_LINE; break;   
 	}   
 	
	mask |= (CKTBL_FMT_VGROW|CKTBL_FMT_VSHRINK);
	if(m_AutoGrow) value |= (CKTBL_FMT_VGROW|CKTBL_FMT_VSHRINK);
	
	mask |= CKTBL_FMT_WORDBREAK;
	if(m_WordBreak) value |= CKTBL_FMT_WORDBREAK;
	
	mask |= CKTBL_FMT_VSCROLL;
	if(m_VScroll) value |= CKTBL_FMT_VSCROLL; 
	    
	mask |= CKTBL_FMT_AUTOVSCROLL;
	value |= CKTBL_FMT_AUTOVSCROLL;
	    
	mask |= CKTBL_FMT_TEXTLIMIT;	         
	if(m_HasTextlimit) 
		value |= CKTBL_FMT_TEXTLIMIT;
		
	attrib.textLimit = m_TextLimit;		
	
	mask |= CKTBL_FMT_TABONLIMIT; 
	if(m_TabOnTextLimit) value |= CKTBL_FMT_TABONLIMIT;

    attrib.format = (attrib.format & ~mask) | value;
	cktbl->ModifySelAttr( &attrib, CKTBL_ATTR_FORMAT|CKTBL_ATTR_TEXTLIMIT, mask );    
	cktbl->Invalidate();
}           


void CCellTypeDialog::UpdateHighlights()
{    
	CWnd * wnd;
	UpdateData();

	if(wnd = GetDlgItem(IDC_FORMAT_TEXTLIMIT)) wnd->EnableWindow( m_HasTextlimit );
	if(wnd = GetDlgItem(IDC_FORMAT_TABONTEXTLIMIT)) wnd->EnableWindow( m_HasTextlimit );
}
   
/////////////////////////////////////////////////////////////////////////////
// CCellTypeDialog message handlers

void CCellTypeDialog::OnApply()
{
	// TODO: Add your control notification handler code here
	if(UpdateData()) {
		ApplyData();
	}
}

void CCellTypeDialog::OnOK()
{
	// TODO: Add extra validation here
	
	CDialog::OnOK(); 
	ApplyData();
}

BOOL CCellTypeDialog::OnInitDialog()
{                  
	int sel;
	
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here     
	
	m_HAlign.Clear();
	m_HAlign.AddString( "Left Aligned" );
	m_HAlign.AddString( "Centered" );
	m_HAlign.AddString( "Right Aligned" );
		                           
	
	m_VAlign.Clear();
	m_VAlign.AddString( "Top" );
	m_VAlign.AddString( "Bottom" );        

	m_Type.Clear();
	m_Type.AddString( "Singleline" );
	m_Type.AddString( "Multiline" );
	
	// HAlign ComboBox	                           
	switch( attrib.format & CKTBL_MASK_HALIGN ) {
		case CKTBL_FMT_LEFT: 	sel = 0; break;
		case CKTBL_FMT_CENTER: 	sel = 1; break;
		case CKTBL_FMT_RIGHT: 	sel = 2; break;    
		default: sel=0;
	}
	m_HAlign.SetCurSel( sel );

	// VAlign ComboBox	                           
	switch( attrib.format & CKTBL_MASK_VALIGN ) {
		case CKTBL_FMT_TOP: 	sel = 0; break;
		case CKTBL_FMT_BOTTOM: 	sel = 1; break; 
		default: sel=0; 
	}
	m_VAlign.SetCurSel( sel );
	                         
 	// Type ComboBox	                           
	switch( attrib.format & CKTBL_MASK_CELLTYPE ) {
		case CKTBL_FMT_SINGLE_LINE: sel = 0; break;
		case CKTBL_FMT_MULTI_LINE: 	sel = 1; break; 
		default: sel=0; 
	}
	m_Type.SetCurSel( sel ); 
	
	UpdateHighlights();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCellTypeDialog::OnFormatTextlimitLimit()
{
	// TODO: Add your control notification handler code here
	UpdateHighlights();
}

void CCellTypeDialog::OnFormatTextlimitNone()
{
	// TODO: Add your control notification handler code here
	UpdateHighlights();
}
