program TestList;

{This is the TestProgram showing Subclassed ListBoxes. In this program you'll
get 4 listboxes. 3 are subclassed, the 4th isn't. The 3 LB are inited with
different mode to show how different modes work.
Test the program for further explanation.

This program is FREEWARE, no part of it can be sold. You can use the code for
your own apps provided that you won't ask money for features provided by this code.
Distribute it as well as you want. Have fun.
You may, but do not have to, acknowledge those who wrote this code, if you use it
in your apps.

Please Note that this code uses Microsoft ctl3dv2.dll. You must install it in
your windows/system directory (and nowhere else) to get this code work. This
DLL provides 3D look for controls and dialogs.}

uses ListPlus, Wobjects, WinTypes, ctl3dv2, WinProcs, Strings;

{$R ListPlus.res}

const
{IDs for Cursors}
	idc_interdit    = 100;
	Idc_Drag        = 101;
	Idc_Dragcopy    = 102;
	idc_drop        = 103;
	idc_dropcopy    = 104;

{IDs for listboxes: to subclass 3 of 4 LB}

	id_test_lst     = 100;
	id_test_lst2    = 101;
	id_test_lst3    = 102;
	id_test_lst4    = 103;

{ID of Dialog}

  id_testdlg      = 'TESTDLG';

{TApplication}

type
	TestApplication = object(TApplication)
    procedure InitMainWindow; virtual;
		end;             


{TDialog redefinitions
Init:        to subclass ListBoxes
SetUpWindow: to fill the first listbox}

	PTEST  = ^TTEST;
	TTEST = object(TDialog)
		constructor Init(AParent: PWindowsObject; AName: PChar);
		procedure setupwindow; virtual;
		procedure List(var msg: TMessage); virtual id_first + id_test_lst4;
    end;

constructor TTest.Init(AParent: PWindowsObject; AName: PChar);
var
	AControl: PControl;
begin
	TDialog.init(Aparent, AName);
{We're subclassing the ListBox controls, changing PListBox to PLis
Note that we're using InitResource to keep the dialog resource listplus.res
If we'd used Init we'd have to pass x,y,w,h of each LB. InitResource is easier
The last parameter of the Subclassed InitResource is the mode of the LB:
			-> Fully fonctionnal:}
	AControl :=New(PLis, InitResource(@Self, id_test_lst,mod_mask));
  {   -> DragCopy only, notify parent:}
	AControl :=New(PLis, InitResource(@Self, id_test_lst2,mod_dragcopy or mod_notify));
	{   -> AllMove only:}
	AControl :=New(PLis, InitResource(@Self, id_test_lst3,mod_allmove));

end;

procedure TTest.SetupWindow;
var
	str1, lst1: array[0..len_str1] of char;
	i: word;
	c: char;
begin
{We load the listbox with random Items here}
	TDialog.SetUpWindow;
	strcopy(lst1,'AZERTYUIOPQSDFGHJKLMWXCVBN');
	for i:=0 to 20 do begin
		wvsprintf(str1,'Item %c',lst1[i]);
		SendDlgItemMessage(HWindow, id_test_lst,lb_AddString,0,longint(@str1));
		end;
end;

procedure TTest.List(var msg: TMessage);
begin
	if msg.lparamHi=lbn_addstring then
		messagebox(HWindow,'You drop an item into listbox 4'+#13+'(from listbox 2)',
		'lbn message caught',mb_ok);
end;


{ -----------TestApplication Methods------------ }
procedure TestApplication.InitMainWindow;
begin
{We create the dialog here}
	MainWindow := New(PTEST,init(nil,id_testdlg));
end;

var
  TestApp : TestApplication;

{The program runs here}
begin
{Subclassing control to get 3D look: look at ctl3Dv2 for further infos}
	Ctl3dRegister(HInstance);
	Ctl3dAutoSubclass(HInstance);

{Main prog}
	TestApp.Init('Test App');
  TestApp.Run;
  TestApp.Done;


	Ctl3dUnregister(HInstance);


end.
