{ Program:   VbxDemo
  Version:   1.00
  Purpose:   this simple program demonstrates how to use of Vbx controls with
             Borland Pascal and tDialogWindow
  Uses:      BIVBX10.DLL and GAUGE.VBX from the BC4 package

  Developer: Peter Sawatzki (ps)
             Buchenhof 3, D58091 Hagen, Germany
 CompuServe: 100031,3002

  Date:     Author:
  02/25/94  ps       written

  Copyright (c) 1994 Peter Sawatzki. All Rights Reserved.
}
Program VbxDemo;
{$A+,B-,F-,G+,I-,K+,P-,Q-,R-,S-,T-,V-,X+}
{$R VbxDemo.Res}
Uses
  WinProcs,
  oWindows,
  oDialogs,
  WinTypes,
{$IfDef Debug} Debug, {$EndIf}
  Vbx,
  DialogWn;
Const
  VBXvalidation: tVbxValidation = cVbxValidation;

Type
  pGaugeControl = ^tGaugeControl;
  tGaugeControl = Object(tVbxControl)
    Procedure evMouseMove (Var Event: tVbxEvent); Virtual ev_First+0;
  End;

  pVbxWindow = ^tVbxWindow;
  tVbxWindow = Object(tDialogWindow)
    Gauge1: pGaugeControl;
    Option1,
    Option2: pVbxControl;
    Constructor Init (aParent: pWindowsObject; Name: pChar);
    Procedure SetupWindow; Virtual;
  End;

Procedure tGaugeControl.evMouseMove (Var Event: tVbxEvent);
Begin
  {$IfDef Debug} WriteLn('[tBIGAUGE.evMouseMove]'); {$EndIf}
  WriteLn('Shift= ',Integer(GetEventArg(Event, 2)^),
          ' x= ',Integer(GetEventArg(Event, 3)^),
          ' y= ',Integer(GetEventArg(Event, 4)^));
{4 params: Integer Integer Integer Integer
 descr= Button As Integer,Shift As Integer,X As Integer,Y As Integer}
End;

Constructor tVbxWindow.Init (aParent: pWindowsObject; Name: pChar);
{-Create a new DialogWindow with VBX childs}
Begin
  Inherited Init(aParent, Name);
  Gauge1:= New(pGaugeControl, InitResource(@Self, 100));
  Option1:= New(pVbxControl, InitResource(@Self, 101));
  Option2:= New(pVbxControl, InitResource(@Self, 102));
End;

Procedure tVbxWindow.SetupWindow;
Begin
  Inherited SetupWindow;
End;

{-------------------- the Application part }
Const
  ProgName = 'VbxDemo';
Type
  tProgApp = Object(tAdvApplication)
    Procedure InitMainWindow; Virtual;
  End;

Procedure tProgApp.InitMainWindow;
Begin
  MainWindow:= New(pVbxWindow, Init(Nil, ProgName))
End;

Var
  App: tProgApp;
Begin
  RegisterVBX(VBXvalidation);
  With App Do Begin
    Init(ProgName);
    Run;
    Done
  End
End.

