/*****************************************************************************

					Visualib Header File
					Copyright (c) 1994
					Visual Tech Co.
					P.O.Box 8735
					Fort Wayne, IN 46898-8735

*****************************************************************************/

#ifdef __cplusplus
extern "C"{
#endif

/*****************************************************************************

					Constants, types, and Macros

*****************************************************************************/

typedef float	REAL;

#define VOIDED  VOID FAR PASCAL
#define SHORT   int FAR PASCAL
#define BINARY  BOOL FAR PASCAL

typedef REAL far    *LPREAL;
typedef REAL		COORD;
typedef COORD		COORD2[2];
typedef COORD		COORD3[3];
typedef COORD		COORD4[4];
typedef COORD far	*LPCOORD;
typedef COORD2 far	*LPCOORD2;
typedef COORD3 far	*LPCOORD3;
typedef COORD4 far	*LPCOORD4;

typedef REAL far    *VECTOR;
typedef REAL far    *MATRIX;

typedef REAL    VECTOR2[2];
typedef REAL    VECTOR3[3];
typedef REAL    VECTOR4[4];
typedef REAL    MATRIX2D[9];
typedef REAL    MATRIX3D[16];
typedef VECTOR2	far	*LPVECT2;
typedef VECTOR3	far	*LPVECT3;
typedef	VECTOR4 far	*LPVECT4;
typedef VECTOR far *LPVECTOR;

typedef struct _tagPOINT2D {    /* 2D point coordinates */
    REAL    x, y;
} POINT2D, far *LPPOINT2D;

typedef struct _tagPOINT2H {    /* 2D homogeneous point coordinates */
    REAL    x, y, w;
} POINT2H, far *LPPOINT2H;

typedef struct _tagPOINT3D {    /* 3D point coordinates */
    REAL    x, y, z;
} POINT3D, far *LPPOINT3D;

typedef struct _tagPOINT3H {    /* 3D homogeneous point coordinates */
    REAL    x, y, z, w;
} POINT3H, far *LPPOINT3H;

typedef struct _tagBOX2D {
    REAL    xmin, xmax, ymin, ymax;
} BOX2D, far *LPBOX2D;

typedef struct _tagBOX3D {
    REAL    xmin, xmax, ymin, ymax, zmin, zmax;
} BOX3D, far *LPBOX3D;

typedef struct tagFACET {
    short	npts;
    VECTOR3 normal;
    LPINT   vindex;
    LPINT   nindex;
} FACET, far *LPFACET;

typedef struct tagWIRE {
	short	vert1;
	short	vert2;
} WIRE, far *LPWIRE;

typedef struct tagPOLYFACET {
    short       nvert;
    short       nnorm;
    short       nfacet;
	short		nwire;
    LPPOINT3D   vertex;
    LPVECT3     normal;
    LPFACET     facet;
	LPWIRE		wire;
} POLYFACET, far *LPPOLYFACET;

typedef MATRIX3D far	*LPMTRX3D;
typedef MATRIX2D far	*LPMTRX2D;

#define EPSILON (REAL) 1e-5
#define QUTRPI  (REAL) 0.78539816
#define HALFPI  (REAL) 1.57079633
#define PI      (REAL) 3.14159265
#define TWOPI   (REAL) 6.2831853
#define DTOR    (REAL) 0.0174532
#define ATOR    (REAL) 1.7453293e-3
#define RTOD    (REAL) 57.295779
#define	SQRT2	(REAL)1.414214
#define	SQRT3	(REAL)1.732051

/* coordinate type */
#define	VL_2D	0x1000
#define	VL_3D	0x2000
#define	VL_2H	0x0400
#define	VL_3H	0x0800

/* viewer status flag */
#define	VL_TWOD			8
#define	VL_THREED		16
#define	VL_CURRENT		128

/* light coordinate mode */
#define	VL_WORLDLIGHT		0x0001
#define	VL_CAMERALIGHT		0x0002
#define	VL_OBJECTLIGHT		0x0004

/* light type */
#define	VL_POINTLIGHT			0x0100
#define	VL_DISTLIGHT			0x0200
#define	VL_SPOTLIGHT			0x0400
#define VL_AREALIGHT			0x0800

/* color type */
#define	VL_MATERIALAMBIENT	0x0001
#define	VL_MATERIALDIFFUSE	0x0002
#define	VL_MATERIALSPECULAR	0x0003
#define	VL_MATERIALEMISSION	0x0004
#define	VL_AMBIENTREFLECT	0x0005
#define	VL_DIFFUSEREFLECT	0x0006
#define	VL_SPECULARREFLECT	0x0007
#define	VL_EMISSIONSTRENGTH	0x0008
#define	VL_SHININESS		0x0009

#define	VL_LIGHTCOLOR		0x0010
#define	VL_AMBIENTCONTRIB	0x0020
#define	VL_LIGHTLOCATION	0x0030
#define	VL_LIGHTDIRECTION	0x0040
#define	VL_LIGHTINTENSITY	0x0050
#define	VL_SPOTLIGHTANGLE	0x0060
#define	VL_SPOTLIGHTSPREAD	0x0070

#define	VL_ATTENUATION		0x0100
#define	VL_GLOBALAMBIENT	0x0200
#define	VL_BACKGROUNDCOLOR	0x0300
#define	VL_SHADINGMETHOD	0x0400
#define	VL_SHADINGMODEL		0x0500
#define	VL_LOCALVIEWER		0x0600
#define	VL_COUNTCLOCKWISE	0x0700
#define	VL_TWOSIDESHADE		0x0800
#define	VL_DEPTHBUFFER		0x0900
#define	VL_BACKFACEREMOVAL	0x0A00
#define	VL_PERTURBMATERIAL	0x0B00
#define VL_PERTURBNORMAL	0x0C00
#define	VL_PERTURBPIXEL		0x0D00
#define VL_PERTURBFACET		0x0E00
#define	VL_ENVIRONMENT		0x0F00

#define VL_INQUIRE        	-1

/* projection mode */
#define VL_PROJECTIONMODE  0x03
#define VL_PERSPECTIVE     0x01
#define VL_ORTHOGONAL      0x02

/* Viewport Mapping Mode */
/*
#define	VL_HORIZONTALFIT	1
#define	VL_VERTICALFIT		2
#define	VL_AUTOFIT			3
#define	VL_VIEWPORTFIT		4
*/
/* standard pen and brush color */
#define	VL_NONE			 0
#define VL_RED           1
#define VL_GREEN         2
#define VL_BLUE          3
#define VL_BROWN         4
#define VL_MAGENTA       5
#define VL_CYAN          6
#define VL_WHITE         7
#define VL_GRAY          8
#define VL_LIGHTRED      9
#define VL_LIGHTGREEN    10
#define VL_LIGHTBLUE     11
#define VL_YELLOW        12
#define VL_LIGHTMAGENTA  13
#define VL_LIGHTCYAN     14
#define VL_LIGHTGRAY     15
#define VL_BLACK         16

/* shading method */
#define	VL_WIREFRAME			0x0001
#define	VL_SOLIDFILL			0x0002
#define	VL_CONTOURSHADE			0x0004
#define	VL_GOURAUDSHADE			0x0008
#define	VL_PHONGSHADE			0x0010
#define	VL_FLATSHADE			0x0020

/* shading model */
#define	VL_PHONGMODEL			0x0100
#define	VL_SPECULARMODEL		0x0200

/* mark type */
#define	VL_NULLMARK			0x0000
#define	VL_CIRCLEMARK		0x0001
#define	VL_CROSSMARK		0x0002
#define	VL_XMARK			0x0004
#define	VL_TRIANGLEMARK		0x0008
#define	VL_BOXMARK			0x0010
#define	VL_DIAMONDMARK		0x0020
#define	VL_HEXAGONMARK		0x0040
#define	VL_OCTAGONMARK		0x0080

/* arrow head type */
#define	VL_NULLARROW		0x0000
#define	VL_OPENARROW		0X0100
#define	VL_CLOSEDARROW		0X0200

/* position mark type */
#define	VL_CROSSHAIR	1
#define	VL_ORIGIN		2

/* solid texture flag */
#define	VL_MARBLE		0x0001
#define	VL_WOODGRAIN	0x0002
#define	VL_GRANITE		0x0004
#define	VL_BUMPY		0x0008

/* Useful Macros */
#define ABS(x)      (((x)>0)?(x):-(x))
#define TRUNC(x)	((int) (x))
#define	FLOOR(x)	(((x)>0) ? (int)(x) : -(int)(-(x)+1))
#define	CEILING(x)	((x)==(int)(x)?(x):(((x)>0)?1+(int)(x):-(1+(int)(-(x)))))
#define	ROUND(x)	((x)>0 ? (int)(x+0.5f) : -(int)(0.5f-x))
#define SQR(x)          ((x)*(x))
#define SQR2(x,y)       ((REAL)(SQR(x)+SQR(y)))
#define SQR3(x,y,z)     ((REAL)(SQR(x)+SQR(y)+SQR(z)))

#define MAX(a,b)	(((a) > (b)) ? (a) : (b))
#define MIN(a,b)	(((a) < (b)) ? (a) : (b))
#define	SWAP(a,b)	{ a^=b; b^=a; a^=b; }
#define MIDVAL(a,b)     (((a)+(b))*0.5f)
#define	LERP(a,l,h)	((l)+(((h)-(l))*(a)))
#define	CLAMP(v,l,h)	((v)<(l) ? (l) : (v)>(h) ? (h) : (v))
#define	STEP(v,s)	((v)<(s) ? 0 : 1)
#define	SIGN(x)		(((x)<0) ? -1 : (x)>0 ? 1 : 0)

#define	NEWLIST(type,n)	(type far *)_fmalloc (sizeof (type) * (n))
#define	NEWITEM(type)	(type far *)_fmalloc (sizeof (type))

#define DIST2(x,y)      ((REAL)sqrt(SQR2(x,y)))
#define DIST3(x,y,z)    ((REAL)sqrt(SQR3(x,y,z)))
#define DETERM2(a,b,c,d)    ((a)*(d)-(b)*(c))
#define DETERM3(a,b,c,d,e,f,g,h,i) ((a)*DETERM2(e,f,h,i)+(b)*DETERM2(f,d,i,g)+(c)*DETERM2(d,e,g,h))

#define VSET2(v,x,y)		((v)[0]=(x),(v)[1]=(y))
#define VSET3(v,x,y,z)		((v)[0]=(x),(v)[1]=(y),(v)[2]=(z))
#define VSET4(v,x,y,z,w)	((v)[0]=(x),(v)[1]=(y),(v)[2]=(z),(v)[3]=(w))
#define	VGET2(v,x,y)		(x=(v)[0],y=(v)[1])
#define	VGET3(v,x,y,z)		(x=(v)[0],y=(v)[1],z=(v)[2])
#define	VGET4(v,x,y,z,w)	(x=(v)[0],y=(v)[1],z=(v)[2],w=(v)[3])

/*****************************************************************************

					Function Prototypes

*****************************************************************************/

/*****************************************************************************

					Basic Functions

*****************************************************************************/

BINARY	InitializeVisualib (void);
VOIDED  ExitVisualib (void);
VOIDED	AboutVisualib (void);
VOIDED	LicenseInfo (void);

/* utility functions */
int FAR CDECL	Message (WORD flag, LPSTR title, LPSTR format, ...);
COLORREF WINAPI	SelectColor (COLORREF color);

VOIDED  SetPoint2D (LPPOINT2D point, REAL x, REAL y);
VOIDED  SetPoint3D (LPPOINT3D point, REAL x, REAL y, REAL z);
VOIDED  SetPoint2H (LPPOINT2H point, REAL x, REAL y, REAL w);
VOIDED  SetPoint3H (LPPOINT3H point, REAL x, REAL y, REAL z, REAL w);
VOIDED  SetBox2D (LPBOX2D box, REAL xmin, REAL xmax, REAL ymin, REAL ymax);
VOIDED  SetBox3D (LPBOX3D box, REAL xmin, REAL xmax, REAL ymin, REAL ymax, REAL zmin, REAL zmax);

VOIDED	PenColor (HDC hdc, int color_index);
VOIDED	BrushColor (HDC hdc, int color_index);
VOIDED	TextColor (HDC hdc, int tcolor, int bcolor, int mode);
VOIDED	PaintColor (HDC hdc, int pen, int brush, int mode);

SHORT	CreateViewer (LPSTR name, RECT port, WORD type, WORD mode);
BINARY	DeleteViewer (int vid);

SHORT	ViewerMappingMode (int vid, int mode);
BINARY	CopyViewer (int vid1, int vid2);
BINARY	ResetViewer (int vid);
SHORT	SelectViewer (int vid);
BINARY	SetViewerName (int vid, LPSTR name);
BINARY	GetViewerName (int vid, LPSTR name);
BINARY	SetViewport (int vid, RECT port);
BINARY	GetViewport (int vid, LPRECT port);

BINARY	ClearViewer (HDC hdc, int vid, int color);
BINARY	DisplayViewerFrame (HDC hdc, int vid);
BINARY	DisplayViewerName (HDC hdc, int vid, int top);

BINARY	BeginDoubleBuffer (HDC far *hdc, int viewid);
BINARY	EndDoubleBuffer (HDC far *hdc, int viewid);
BINARY	UpdateDoubleBuffer (HDC hdc, int viewid);

/*****************************************************************************

						2D Functions

*****************************************************************************/

VOIDED  Translate2D (REAL x, REAL y);
VOIDED	TranslateTo2D (REAL x, REAL y);
VOIDED  Scale2D (REAL x, REAL y);
VOIDED	PointScale2D (REAL x, REAL y, REAL sx, REAL sy);
VOIDED	TranScale2D (REAL x, REAL y, REAL sx, REAL sy);
VOIDED	Shear2D (REAL x, REAL y, REAL a, REAL u, REAL v);
VOIDED	Stretch2D (REAL x, REAL y, REAL a, REAL f);
VOIDED	Mirror2D (REAL x, REAL y, REAL a);
VOIDED  Rotate2D (REAL angle);
VOIDED	PointRotate2D (REAL x, REAL y, REAL a);
BINARY	ViewerField2D (int vid,
			LPREAL left, LPREAL bottom, LPREAL right, LPREAL top);

BINARY	PushTransformation2D (MATRIX m);
BINARY	PopTransformation2D (MATRIX m);
VOIDED	ConcatTransformation2D (MATRIX m, BOOL post);
VOIDED	LoadTransformation2D (MATRIX m);

BINARY	SetProjection2D (int vid,
			REAL left, REAL bottom, REAL right, REAL top);
BINARY	SetView2D (int vid, REAL x, REAL y, REAL a);
BINARY	SetWindow2D (int vid, REAL left, REAL bottom, REAL right, REAL top);

BINARY	MoveViewer2D (int vid, REAL horizontal, REAL vertical, BOOL local);
BINARY	RotateViewer2D (int vid, REAL angle, BOOL local);
BINARY	ZoomViewer2D (int vid, REAL zoom);

VOIDED  MoveTo2D (HDC hdc, REAL x, REAL y);
VOIDED  RMoveTo2D (HDC hdc, REAL x, REAL y);
VOIDED  LineTo2D (HDC hdc, REAL x, REAL y);
VOIDED  RLineTo2D (HDC hdc, REAL x, REAL y);
VOIDED  Line2D (HDC hdc, REAL x1, REAL y1, REAL x2, REAL y2);
VOIDED  RLine2D (HDC hdc, REAL x, REAL y, REAL dx, REAL dy);
VOIDED	Label2D (HDC hdc, REAL x, REAL y, LPSTR label);
VOIDED	MoveTo2H (HDC hdc, REAL x, REAL y, REAL w);
VOIDED	LineTo2H (HDC hdc, REAL x, REAL y, REAL w);
VOIDED	Line2H (HDC hdc, REAL x1, REAL y1, REAL w1,
			REAL x2, REAL y2, REAL w2);

VOIDED  Polygon2D (HDC hdc, int type, LPCOORD vertex, int count);
VOIDED  PolyPolygon2D (HDC hdc, int type, LPCOORD vertex,
			LPINT polycount, int count);
VOIDED  Polyline2D (HDC hdc, int type, LPCOORD point, int count);
VOIDED  ClosedPolyline2D (HDC hdc, int type, LPCOORD point, int count);
VOIDED	Mark2D (HDC hdc, REAL x, REAL y, int hsize, int vsize, int head);
VOIDED	PolyMark2D (HDC hdc, int type, LPCOORD point, int n,
			int hsize, int vsize, int head);
VOIDED	Pointer2D (HDC hdc, REAL x1, REAL y1, REAL x2, REAL y2,
			REAL l, REAL w, int type);
VOIDED	Arrow2D (HDC hdc, REAL x, REAL y, REAL u, REAL v, REAL r, REAL l, 
			REAL w, int type);
VOIDED	Net2D (HDC hdc, int type, LPCOORD point, int m, int n);
VOIDED	MarkPosition2D (HDC hdc, REAL x, REAL y, REAL size, int type);

/*****************************************************************************

						3D Functions

*****************************************************************************/

SHORT	ProjectionMode (int vid, int mode);

VOIDED  Translate3D (REAL x, REAL y, REAL z);
VOIDED  TranslateTo3D (REAL x, REAL y, REAL z);
VOIDED  Scale3D (REAL sx, REAL sy, REAL sz);
VOIDED	PointScale3D (REAL x, REAL y, REAL z, REAL sx, REAL sy, REAL sz);
VOIDED  Rotate3D (REAL angle, char axis);
VOIDED	AxleRotate3D (VECTOR ref, VECTOR dir, REAL a);
VOIDED	Stretch3D (VECTOR ref, VECTOR dir, REAL f);
VOIDED	Shear3D (VECTOR ref, VECTOR dir, REAL u, REAL v);
VOIDED	Mirror3D (VECTOR ref, VECTOR dir);

BINARY	PushTransformation3D (MATRIX m);
BINARY	PopTransformation3D (MATRIX m);
VOIDED	ConcatTransformation3D (MATRIX m, BOOL post);
VOIDED	LoadTransformation3D (MATRIX m);

BINARY	ResetProjection3D (int vid);
BINARY	SetProjection3D (int vid, REAL left, REAL bottom, REAL right,
			REAL top, REAL front, REAL back, BYTE mode);
BINARY	SetPerspective (int vid, REAL fovy, REAL aspect,
			REAL zmin, REAL zmax);
BINARY	SetView3D (int vid, REAL ex, REAL ey, REAL ez,
			REAL ax, REAL ay, REAL az, REAL twist);
BINARY	SetPolarView (int vid, REAL ax, REAL ay, REAL az,
			REAL dist, REAL azim, REAL inc, REAL twist);

BINARY	ViewerLocation (int vid, LPREAL x, LPREAL y, LPREAL z);
BINARY	ViewerDirection (int vid, LPREAL x, LPREAL y, LPREAL z);
BINARY	ViewerField3D (int vid, LPREAL left, LPREAL bottom,
			LPREAL right, LPREAL top, LPREAL front, LPREAL back);

BINARY	MoveViewer3D (int vid, REAL horizontal, REAL vertical, REAL backforth,
			BOOL local);
BINARY	RotateViewer3D (int vid, REAL angle, char axis, BOOL local);
BINARY	ZoomViewer3D (int vid, REAL zoom);

VOIDED  MoveTo3D (HDC hdc, REAL x, REAL y, REAL z);
VOIDED  LineTo3D (HDC hdc, REAL x, REAL y, REAL z);
VOIDED  RMoveTo3D (HDC hdc, REAL x, REAL y, REAL z);
VOIDED  RLineTo3D (HDC hdc, REAL x, REAL y, REAL z);
VOIDED  MoveTo3H (HDC hdc, REAL x, REAL y, REAL z, REAL w);
VOIDED  LineTo3H (HDC hdc, REAL x, REAL y, REAL z, REAL w);

VOIDED  Line3D (HDC hdc, REAL x1, REAL y1, REAL z1,
			REAL x2, REAL y2, REAL z2);
VOIDED  RLine3D (HDC hdc, REAL x, REAL y, REAL z, REAL dx, REAL dy, REAL dz);

VOIDED	PolyArrow3D (HDC hdc, int type, LPCOORD poly, LPVECT3 dir, int n,
			REAL r, REAL l, REAL w, int htype);
VOIDED	Label3D (HDC hdc, REAL x, REAL y, REAL z, LPSTR label);
BINARY	Mark3D (HDC hdc, REAL x, REAL y, REAL z,
			int hsize, int vsize, int type);
VOIDED 	PolyMark3D (HDC hdc, int type, LPCOORD point, int n,
			int hsize, int vsize, int htype);


VOIDED	Polygon3D (HDC hdc, int type, LPCOORD vertex, int count);
VOIDED	PolyPolygon3D (HDC hdc, int type, LPCOORD vertex,
			LPINT polycount, int count);
VOIDED	Polyline3D (HDC hdc, int type, LPCOORD point, int count);
VOIDED  ClosedPolyline3D (HDC hdc, int type, LPCOORD point, int count);
VOIDED	MarkPosition3D (HDC hdc, REAL x, REAL y, REAL z, REAL size, int type);
VOIDED	Pointer3D (HDC hdc, REAL x1, REAL y1, REAL z1, REAL x2, REAL y2,
			REAL z2, REAL l, REAL w, int type);
VOIDED	Arrow3D (HDC hdc, REAL x, REAL y, REAL z, REAL u, REAL v, REAL w,
			REAL r, REAL l, REAL t, int type);
VOIDED	Net3D (HDC hdc, int type, LPCOORD point, int m, int n);

/*****************************************************************************

						Shading Functions

*****************************************************************************/

VOIDED	ResetShader (void);

/* depth buffer functions */
BINARY	SetDepthBuffer (int hview);
BINARY	SelectDepthBuffer (int hview);
BINARY	FreeDepthBuffer (int hview);
VOIDED	ClearDepthBuffer (WORD val);

/* light functions */
BINARY	CopyLight (int lid1, int lid2);
BINARY	ResetLight (int lid);
SHORT	CreateLight (LPSTR name, int type);
VOIDED	DeleteLight (int lid);
SHORT	SelectLight (int lid);
BINARY	CopyLModel (int lmid1, int lmid2);
SHORT	CreateLModel (LPSTR name);
VOIDED	DeleteLModel (int lmid);
SHORT	SelectLModel (int lmid);
SHORT	GetLightType (int lid);
BINARY	SwitchLight (int lid, int status);
BINARY	SetLightCoordinateType (int lid, int type);

/* material functions */
SHORT	CreateMaterial (LPSTR name);
VOIDED	DeleteMaterial (int mid);
SHORT	SelectMaterial (int mid);
BINARY	CopyMaterial (int mid1, int mid2);
BINARY	ResetMaterial (int mid);

/* shading parameter functions */
SHORT	ShadingOption (int id, int opt, int status);
COLORREF WINAPI	_ShadingColor (int id, int type, COLORREF color);
#define	ShadingColor(id,type,color)	_ShadingColor (id, type, (COLORREF) color)
BINARY	ShadingFactor (int id, int type, REAL f);
BINARY	ShadingParameter (int id, int type, BOOL inquire, VECTOR param);

HPALETTE WINAPI	SetRGBPalette (void);

/* shading primitive functions */
BINARY	_ShadeFacet (HDC hdc, VECTOR normal, int type, LPCOORD vertex, int count, LPVECT3 param);
#define	ShadeFacet(hdc, normal, type, vertex, count, param)	\
_ShadeFacet (hdc, normal, type, (LPCOORD) vertex, count, param)
BINARY	_ShadePolygon (HDC hdc, VECTOR normal, int type, LPCOORD point, int count);
#define	ShadePolygon(hdc, normal, type, point, count)	\
_ShadePolygon(hdc, normal, type, (LPCOORD) point, count)
BINARY	_ShadePolyPolygon (HDC hdc, VECTOR normal, int type, LPCOORD vertex, LPINT pcount, int count);
#define	ShadePolyPolygon(hdc, normal, type, vertex, pcount, count)	\
_ShadePolyPolygon (hdc, normal, type, (LPCOORD) vertex, pcount, count)

BINARY	ShadePolyFacet (HDC hdc, LPPOLYFACET polyfacet);
BINARY	ShadingPreview (HDC hdc, LPRECT rect, REAL r, REAL d);

/* programmable shader functions */
VOIDED	GetPixelPosition (LPINT x, LPINT y);
VOIDED	GetPixelViewNormal (VECTOR normal);
VOIDED	GetPixelWorldNormal (VECTOR normal);
VOIDED	GetPixelObjectNormal (VECTOR normal);
VOIDED	GetPixelViewCoordinate (VECTOR coord);
VOIDED	GetPixelWorldCoordinate (VECTOR coord);
VOIDED	GetPixelObjectCoordinate (VECTOR coord);
VOIDED	GetPixelViewCameraAxis (VECTOR vaxis);
VOIDED	GetPixelWorldCameraAxis (VECTOR vaxis);
VOIDED	GetPixelObjectCameraAxis (VECTOR vaxis);

VOIDED	SetPerturbation (int type, void (CALLBACK* proc)());
BINARY	SolidTexture (int type);

/*****************************************************************************

				Image Mapping and Printing Functions

*****************************************************************************/

typedef int (WINAPI *DRAWPROC)(HDC);

#define	VL_FLUSHTOP		0x0001
#define	VL_FLUSHBOTTOM	0x0002
#define	VL_FLUSHLEFT	0x0004
#define	VL_FLUSHRIGHT	0x0008

#define	VL_HORZFIT		0x0010
#define	VL_VERTFIT		0x0020
#define	VL_ALLFIT		0x0030
#define	VL_HORZCENTER	0x0040
#define	VL_VERTCENTER	0x0080

#define	VL_HORZSCALED	0x0100
#define	VL_VERTSCALED	0x0200
#define	VL_BESTFIT		0x0400
#define	VL_USE31APIS	0x0800

#define	VL_MILLIMETER	0x1000
#define	VL_CENTIMETER	0x2000
#define	VL_MARKCORNER	0x4000
#define	VL_MARKPAGE		0x8000

BINARY	ReadDIBFile (LPSTR fname, LPHANDLE hdib);
HANDLE	WINAPI	ScreenToDIB (LPRECT rect);
BINARY	WriteDIBFile (LPSTR fname, HANDLE hdib);
BINARY	SetPrintRect (HDC hdc, LPRECT rect, int mode, double x, double y,
			double w, double h, int bw, int bh);
VOIDED	GetScreenRect (HWND hwnd, BOOL withframe, LPRECT rect);
BINARY	PrintImage (HANDLE hdib, WORD mode, REAL x, REAL y, REAL w, REAL h);
BINARY	PrintDrawing (DRAWPROC draw, WORD mode,
			REAL x, REAL y, REAL w, REAL h);
BINARY	ImageMap2D (HDC hdc, HGLOBAL hdib, int type, LPCOORD vertex);
BINARY	ImageMap3D (HDC hdc, HGLOBAL hdib, int type, LPCOORD vertex);


/* text parameter */
#define	VL_TEXT_HEIGHT			0x0001
#define	VL_TEXT_ASPECT			0x0002
#define	VL_TEXT_THICKNESS		0x0004

BINARY	TextParameter (int type, REAL param);
BINARY	SelectFont (void);
BINARY	SetFont (const LPLOGFONT lplf);
BINARY	Text2D (HDC hdc, REAL x, REAL y, REAL a, LPSTR text);
BINARY	Text3D (HDC hdc, REAL x, REAL y, REAL a, LPSTR text);
BINARY	SolidText (HDC hdc, LPSTR text);

/*****************************************************************************

					2D Curve Functions

*****************************************************************************/

VOIDED  QBezierCurve2D (HDC hdc, int type, LPCOORD poly);
VOIDED  QBSplineCurve2D (HDC hdc, int type, LPCOORD poly, int n);
VOIDED  QNURBSCurve2D (HDC hdc, int type, LPCOORD poly, int n, VECTOR knot);

VOIDED  BezierCurve2D (HDC hdc, int type, LPCOORD poly);
VOIDED  HermitCurve2D (HDC hdc, int type, LPCOORD poly);
VOIDED  BSplineCurve2D (HDC hdc, int type, LPCOORD poly, int n);
VOIDED  NURBSCurve2D (HDC hdc, int type, LPCOORD poly, int n, VECTOR knot);
VOIDED  SplineInterp2D (HDC hdc, int type, LPCOORD poly, int n);

VOIDED  BSplineCurveClosed2D (HDC hdc, int type, LPCOORD poly, int n);
VOIDED  NURBSCurveClosed2D (HDC hdc, int type, LPCOORD poly,
			int n, VECTOR knot);

VOIDED	CatmullRomSpline2D (HDC hdc, int type, LPCOORD poly, int n);


/*****************************************************************************

					3D Curve Functions

*****************************************************************************/

VOIDED  QBezierCurve3D (HDC hdc, int type, LPCOORD poly);
VOIDED  QBSplineCurve3D (HDC hdc, int type, LPCOORD poly, int n);
VOIDED  QNURBSCurve3D (HDC hdc, int type, LPCOORD poly, int n, VECTOR knot);
VOIDED  BezierCurve3D (HDC hdc, int type, LPCOORD poly);
VOIDED	HermitCurve3D (HDC hdc, int type, LPCOORD poly);
VOIDED  BSplineCurve3D (HDC hdc, int type, LPCOORD poly, int n);
VOIDED  NURBSCurve3D (HDC hdc, int type, LPCOORD poly, int n, VECTOR knot);
VOIDED  SplineInterp3D (HDC hdc, int type, LPCOORD poly, int n);
VOIDED  BSplineCurveClosed3D (HDC hdc, int type, LPCOORD poly, int n);
VOIDED  NURBSCurveClosed3D (HDC hdc, int type, LPCOORD poly,
			int n, VECTOR knot);
VOIDED	CatmullRomSpline3D (HDC hdc, int type, LPCOORD poly, int n);
VOIDED	Spring (HDC hdc, int n, REAL radius, REAL height);

/*****************************************************************************

					3D Curve Functions

*****************************************************************************/

SHORT   CircleSide (short side);
VOIDED	TransfVertex (int type, REAL x, REAL y, REAL a, REAL sx, REAL sy, LPREAL vertex, int n);
SHORT	RectangleVertex (int type, REAL x1, REAL y1, REAL x2, REAL y2, LPREAL vertex);
SHORT	BoxVertex (int type, REAL x, REAL y, REAL t, REAL sx, REAL sy, LPREAL vertex);
SHORT   NgonVertex (int type, REAL x, REAL y, REAL t, REAL rx, REAL ry, int n, LPREAL vertex);
SHORT	FlowerVertex (int type, REAL x, REAL y, REAL t, REAL rx, REAL ry, int n, REAL r, LPREAL vertex);
SHORT	StarVertex (int type, REAL x, REAL y, REAL t, REAL rx, REAL ry, int n, LPREAL vertex);
SHORT	ArcVertex (int type, REAL x, REAL y, REAL t, REAL rx, REAL ry, int n, REAL a, REAL b, LPREAL vertex);
SHORT	PieVertex (int type, REAL x, REAL y, REAL t, REAL rx, REAL ry, int n, REAL a, REAL b, LPREAL vertex);
SHORT	RingVertex (int type, REAL x, REAL y, REAL t, REAL rx, REAL ry, int n, REAL a, REAL b, REAL w, LPREAL vertex);
SHORT	RoseVertex (int type, REAL x, REAL y, REAL a, REAL r, int m, int n, LPREAL vertex);

/*****************************************************************************

				2D Primitive Functions

*****************************************************************************/

VOIDED  Rectangle2D (HDC hdc, REAL x1, REAL y1, REAL x2, REAL y2);
VOIDED	Box2D (HDC hdc, REAL x, REAL y, REAL t, REAL w, REAL h);
VOIDED  Disk2D (HDC hdc, REAL x, REAL y, REAL t, REAL rx, REAL ry);
VOIDED  Pie2D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, REAL a, REAL b);
VOIDED  Ring2D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, REAL a, REAL b, REAL w);
VOIDED	Chord2D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, REAL a, REAL b);
VOIDED  Ngon2D (HDC hdc, REAL x, REAL y, REAL t, REAL rx, REAL ry, int n);
VOIDED  Flower2D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, int n, REAL ratio);
VOIDED  Star2D (HDC hdc, REAL x, REAL y, REAL t, REAL rx, REAL ry, int n);
VOIDED  Arc2D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, REAL a, REAL b);
VOIDED	Rose2D (HDC hdc, REAL x, REAL y, REAL t, REAL r, int m, int n);

VOIDED	Spiral2D (HDC hdc, REAL x, REAL y, REAL a, REAL b, REAL r, REAL dr);


/*****************************************************************************

				3D Primitive Functions

*****************************************************************************/

VOIDED  Rectangle3D (HDC hdc, REAL x1, REAL y1, REAL x2, REAL y2);
VOIDED  Box3D (HDC hdc, REAL x, REAL y, REAL t, REAL sx, REAL sy);
VOIDED	Ring3D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, REAL a, REAL b, REAL w);
VOIDED  Disk3D (HDC hdc, REAL x, REAL y, REAL t, REAL rx, REAL ry);
VOIDED  Pie3D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, REAL a, REAL b);
VOIDED  Chord3D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, REAL a, REAL b);
VOIDED  Ngon3D (HDC hdc, REAL x, REAL y, REAL t, REAL rx, REAL ry, int n);
VOIDED  Flower3D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, int n, REAL r);
VOIDED  Star3D (HDC hdc, REAL x, REAL y, REAL t, REAL rx, REAL ry, int n);

VOIDED  Arc3D (HDC hdc, REAL x, REAL y, REAL t,
			REAL rx, REAL ry, REAL a, REAL b);
VOIDED	Rose3D (HDC hdc, REAL x, REAL y, REAL t, REAL r, int m, int n);

VOIDED  Spiral3D (HDC hdc, REAL a, REAL b, REAL r, REAL dr, REAL h);
VOIDED	Spring3D (HDC hdc, REAL a, REAL b, REAL r, REAL h);


/*****************************************************************************

				3D Surface Functions

*****************************************************************************/

BINARY	BezierSurface (HDC hdc, int type, LPCOORD poly, int ns, int nt);
BINARY	HermitSurface (HDC hdc, int type, LPCOORD poly, int ns, int nt);
BINARY	BSplineSurface (HDC hdc, int type, LPCOORD poly,
			int Sc, int Tc, int ns, int nt);
BINARY	NURBSSurface (HDC hdc, int type, LPCOORD poly,
			int Sc, int Tc, VECTOR Skn, VECTOR Tkn, int ns, int nt);

BINARY	CoonsPatch (HDC hdc, int type, LPCOORD point, int nu, int nv);

/*****************************************************************************

							Solid Primitive Functions

*****************************************************************************/

BINARY	Cube (HDC hdc, REAL w, REAL l, REAL h);
BINARY	Cylinder (HDC hDC, REAL rx, REAL ry, REAL h);
BINARY	Cone (HDC hDC, REAL rx, REAL ry, REAL h);
BINARY	Ellipsoid (HDC hdc, REAL a, REAL b, REAL c);
BINARY	Sphere (HDC hdc, REAL r);
BINARY	HemiSphere (HDC hdc, REAL r, REAL h);
BINARY	SolidStar (HDC hdc, int n, REAL rx, REAL ry, REAL h);
BINARY	SolidFlower (HDC hdc, int n, REAL r, REAL rx, REAL ry, REAL h);
BINARY	SolidPie (HDC hdc, REAL rx, REAL ry, REAL h, REAL a, REAL b);
BINARY	Frustum (HDC hdc, REAL bw, REAL bl, REAL tw, REAL tl, REAL h);
BINARY	Ridge (HDC hdc, REAL w, REAL l, REAL h, REAL r);
BINARY	Prism (HDC hdc, int type, LPCOORD base, int n, REAL h);
BINARY	Pyramid (HDC hdc, LPPOINT3D base, int n, LPPOINT3D tip);
BINARY	WedgedCone (HDC hdc, REAL rx, REAL ry, REAL h, REAL a, REAL b);
BINARY	WedgedCylinder (HDC hdc, REAL rx, REAL ry, REAL h,
			REAL tr, REAL a, REAL b);
BINARY	WedgedSphere (HDC hdc, REAL rx, REAL ry, REAL rz,
			REAL a1, REAL a2, REAL b1, REAL b2);
BINARY	WedgedTorus (HDC hdc, REAL r1, REAL r2,
			REAL a1, REAL a2, REAL b1, REAL b2);

BINARY	Torus (HDC hdc, REAL r1, REAL r2);

BINARY	SolidRing (HDC hdc, REAL rtop, REAL rbot, REAL t, REAL h, REAL a,
			REAL b, REAL ratio);
BINARY	Tube (HDC hdc, REAL rtop, REAL rbot, REAL t, REAL h);
BINARY	Sweep (HDC hdc, MATRIX transf, int nstep, LPVECT3 vertex,
			LPVECT3 normals, int npts, int mode, VECTOR snormal);
BINARY	Revolution (HDC hdc, LPVECT3 vertex, LPVECT3 normal, short n,
			REAL angle, int mode, VECTOR snormal);
BINARY	Tetrahedron (HDC hdc, REAL r);
BINARY	Octahedron (HDC hdc, REAL r);
BINARY	Dodecahedron (HDC hdc, REAL r);
BINARY  Icosahedron (HDC hdc, REAL r);

/*****************************************************************************

							Object Array Functions

*****************************************************************************/

typedef	BOOL (WINAPI *RectArrayProc)(HDC hdc, int row, int col);
typedef BOOL (WINAPI *CubicArrayProc)(HDC hdc, int row, int col, int lev);
typedef	BOOL (WINAPI *PolarArrayProc)(HDC hdc, int row, int col);
typedef	BOOL (WINAPI *CylindricArrayProc)(HDC hdc, int row, int col, int lev);
typedef BOOL (WINAPI *SphericArrayProc)(HDC hdc, int row, int col, int lev);

BINARY	RectangularArray2D (HDC hdc, int m, int n,
			REAL xinc, REAL yinc, RectArrayProc fp);
BINARY	RectangularArray3D (HDC hdc, int m, int n,
			REAL xinc, REAL yinc, RectArrayProc fp);
BINARY	PolarArray2D (HDC hdc, int m, int n,
			REAL roff, REAL ainc, REAL rinc, PolarArrayProc);
BINARY	PolarArray3D (HDC hdc, int m, int n,
			REAL roff, REAL ainc, REAL rinc, PolarArrayProc);
BINARY	CubicArray (HDC hdc, int m, int n, int l,
			REAL xinc, REAL yinc, REAL zinc, CubicArrayProc fp);
BINARY	CylindricArray (HDC hdc, int m, int n, int l,
			REAL roff, REAL ainc, REAL rinc, REAL zinc,
			CylindricArrayProc fp);
BINARY	SphericArray (HDC hdc, int m, int n, int l,
			REAL roff, REAL toff, REAL ainc, REAL rinc, REAL tinc,
			SphericArrayProc fp);

#ifdef __cplusplus
}
#endif
